/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000bH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\u000bH\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\u000bH\u0002\u001a\u001a\u0010\u0015\u001a\u00020\n*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006\u001a\n\u0010\u001a\u001a\u00020\u000f*\u00020\u001b\u001a\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"QUOTED_STRING_DELIMITERS", "Lokio/ByteString;", "TOKEN_DELIMITERS", "parseChallenges", "", "Lokhttp3/Challenge;", "Lokhttp3/Headers;", "headerName", "", "readChallengeHeader", "", "Lokio/Buffer;", "result", "", "skipCommasAndWhitespace", "", "startsWith", "prefix", "", "readQuotedString", "readToken", "receiveHeaders", "Lokhttp3/CookieJar;", "url", "Lokhttp3/HttpUrl;", "headers", "promisesBody", "Lokhttp3/Response;", "hasBody", "response", "okhttp"})
@JvmName(name="HttpHeaders")
public final class HttpHeaders {
    @NotNull
    private static final ByteString QUOTED_STRING_DELIMITERS = ByteString.Companion.encodeUtf8("\"\\");
    @NotNull
    private static final ByteString TOKEN_DELIMITERS = ByteString.Companion.encodeUtf8("\t ,=");

    @NotNull
    public static final List<Challenge> parseChallenges(@NotNull Headers $this$parseChallenges, @NotNull String headerName) {
        Intrinsics.checkNotNullParameter($this$parseChallenges, "<this>");
        Intrinsics.checkNotNullParameter(headerName, "headerName");
        List result2 = new ArrayList();
        int n = $this$parseChallenges.size();
        for (int h = 0; h < n; ++h) {
            if (!StringsKt.equals(headerName, $this$parseChallenges.name(h), true)) continue;
            Buffer header2 = new Buffer().writeUtf8($this$parseChallenges.value(h));
            try {
                HttpHeaders.readChallengeHeader(header2, result2);
                continue;
            }
            catch (EOFException e) {
                Platform.Companion.get().log("Unable to parse challenge", 5, e);
            }
        }
        return result2;
    }

    private static final void readChallengeHeader(Buffer $this$readChallengeHeader, List<Challenge> result2) throws EOFException {
        String peek2 = null;
        while (true) {
            Map parameters;
            String schemeName;
            block11: {
                if (peek2 == null) {
                    HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader);
                    peek2 = HttpHeaders.readToken($this$readChallengeHeader);
                    if (peek2 == null) {
                        return;
                    }
                }
                schemeName = peek2;
                boolean commaPrefixed = HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader);
                peek2 = HttpHeaders.readToken($this$readChallengeHeader);
                if (peek2 == null) {
                    if (!$this$readChallengeHeader.exhausted()) {
                        return;
                    }
                    result2.add(new Challenge(schemeName, MapsKt.emptyMap()));
                    return;
                }
                int eqCount = _UtilCommonKt.skipAll($this$readChallengeHeader, (byte)61);
                boolean commaSuffixed = HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader);
                if (!commaPrefixed && (commaSuffixed || $this$readChallengeHeader.exhausted())) {
                    Map<Object, String> map2 = Collections.singletonMap(null, peek2 + StringsKt.repeat("=", eqCount));
                    Intrinsics.checkNotNullExpressionValue(map2, "singletonMap(...)");
                    result2.add(new Challenge(schemeName, map2));
                    peek2 = null;
                    continue;
                }
                parameters = new LinkedHashMap();
                eqCount += _UtilCommonKt.skipAll($this$readChallengeHeader, (byte)61);
                do {
                    String parameterValue;
                    if (peek2 == null) {
                        peek2 = HttpHeaders.readToken($this$readChallengeHeader);
                        if (HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader)) break block11;
                        eqCount = _UtilCommonKt.skipAll($this$readChallengeHeader, (byte)61);
                    }
                    if (eqCount == 0) break block11;
                    if (eqCount > 1) {
                        return;
                    }
                    if (HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader)) {
                        return;
                    }
                    if ((HttpHeaders.startsWith($this$readChallengeHeader, (byte)34) ? HttpHeaders.readQuotedString($this$readChallengeHeader) : HttpHeaders.readToken($this$readChallengeHeader)) == null) {
                        return;
                    }
                    parameterValue = parameterValue;
                    String replaced = parameters.put(peek2, parameterValue);
                    peek2 = null;
                    if (replaced == null) continue;
                    return;
                } while (HttpHeaders.skipCommasAndWhitespace($this$readChallengeHeader) || $this$readChallengeHeader.exhausted());
                return;
            }
            result2.add(new Challenge(schemeName, parameters));
        }
    }

    private static final boolean skipCommasAndWhitespace(Buffer $this$skipCommasAndWhitespace) {
        boolean commaFound = false;
        while (!$this$skipCommasAndWhitespace.exhausted()) {
            byte by = $this$skipCommasAndWhitespace.getByte(0L);
            if (by == 44) {
                $this$skipCommasAndWhitespace.readByte();
                commaFound = true;
                continue;
            }
            if (by != 32 && by != 9) break;
            $this$skipCommasAndWhitespace.readByte();
        }
        return commaFound;
    }

    private static final boolean startsWith(Buffer $this$startsWith, byte prefix) {
        return !$this$startsWith.exhausted() && $this$startsWith.getByte(0L) == prefix;
    }

    private static final String readQuotedString(Buffer $this$readQuotedString) throws EOFException {
        if (!($this$readQuotedString.readByte() == 34)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Buffer result2 = new Buffer();
        long i2;
        while ((i2 = $this$readQuotedString.indexOfElement(QUOTED_STRING_DELIMITERS)) != -1L) {
            if ($this$readQuotedString.getByte(i2) == 34) {
                result2.write($this$readQuotedString, i2);
                $this$readQuotedString.readByte();
                return result2.readUtf8();
            }
            if ($this$readQuotedString.size() == i2 + 1L) {
                return null;
            }
            result2.write($this$readQuotedString, i2);
            $this$readQuotedString.readByte();
            result2.write($this$readQuotedString, 1L);
        }
        return null;
    }

    private static final String readToken(Buffer $this$readToken) {
        long tokenSize = $this$readToken.indexOfElement(TOKEN_DELIMITERS);
        if (tokenSize == -1L) {
            tokenSize = $this$readToken.size();
        }
        return tokenSize != 0L ? $this$readToken.readUtf8(tokenSize) : null;
    }

    public static final void receiveHeaders(@NotNull CookieJar $this$receiveHeaders, @NotNull HttpUrl url2, @NotNull Headers headers2) {
        Intrinsics.checkNotNullParameter($this$receiveHeaders, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        if ($this$receiveHeaders == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> cookies2 = Cookie.Companion.parseAll(url2, headers2);
        if (cookies2.isEmpty()) {
            return;
        }
        $this$receiveHeaders.saveFromResponse(url2, cookies2);
    }

    public static final boolean promisesBody(@NotNull Response $this$promisesBody) {
        Intrinsics.checkNotNullParameter($this$promisesBody, "<this>");
        if (Intrinsics.areEqual($this$promisesBody.request().method(), "HEAD")) {
            return false;
        }
        int responseCode = $this$promisesBody.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return _UtilJvmKt.headersContentLength($this$promisesBody) != -1L || StringsKt.equals("chunked", Response.header$default($this$promisesBody, "Transfer-Encoding", null, 2, null), true);
    }

    @Deprecated(message="No longer supported", replaceWith=@ReplaceWith(expression="response.promisesBody()", imports={}), level=DeprecationLevel.ERROR)
    public static final boolean hasBody(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter(response2, "response");
        return HttpHeaders.promisesBody(response2);
    }
}

