/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.VersionCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnevaluatedItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedItemsValidator.class);
    private final JsonSchema schema;
    private final boolean isMinV202012;
    private static final SpecVersion.VersionFlag DEFAULT_VERSION = SpecVersion.VersionFlag.V201909;

    public UnevaluatedItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_ITEMS, validationContext);
        this.isMinV202012 = VersionCode.MinV202012.getVersions().contains((Object)validationContext.activeDialect().orElse(DEFAULT_VERSION));
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedItems' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (!node2.isArray()) {
            return Collections.emptySet();
        }
        UnevaluatedItemsValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        String itemsKeyword = this.isMinV202012 ? "prefixItems" : "items";
        String additionalItemsKeyword = this.isMinV202012 ? "items" : "additionalItems";
        boolean valid = false;
        int validCount = 0;
        boolean evaluated = false;
        Predicate<JsonNodeAnnotation> validEvaluationPathFilter = a2 -> executionContext.getResults().isValid(instanceLocation, a2.getEvaluationPath());
        Predicate<JsonNodeAnnotation> adjacentEvaluationPathFilter = a2 -> a2.getEvaluationPath().startsWith(this.evaluationPath.getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        if (this.getSchemaNode().isBoolean() && this.getSchemaNode().booleanValue()) {
            valid = true;
            if (!node2.isEmpty()) {
                evaluated = true;
            }
        } else {
            List items2 = instanceLocationAnnotations.stream().filter(a2 -> itemsKeyword.equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            if (items2.isEmpty()) {
                valid = false;
            } else {
                for (Object annotation : items2) {
                    if (((JsonNodeAnnotation)annotation).getValue() instanceof Number) {
                        Number value = (Number)((JsonNodeAnnotation)annotation).getValue();
                        int existing = value.intValue();
                        if (existing <= validCount) continue;
                        validCount = existing;
                        continue;
                    }
                    if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Boolean)) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List additionalItems = instanceLocationAnnotations.stream().filter(a2 -> additionalItemsKeyword.equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (JsonNodeAnnotation annotation : additionalItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List unevaluatedItems = instanceLocationAnnotations.stream().filter(a2 -> "unevaluatedItems".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (JsonNodeAnnotation annotation : unevaluatedItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
        }
        LinkedHashSet<ValidationMessage> messages = null;
        if (!valid) {
            List contains2 = instanceLocationAnnotations.stream().filter(a2 -> "contains".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            HashSet containsEvaluated = new HashSet();
            boolean containsEvaluatedAll = false;
            for (JsonNodeAnnotation a3 : contains2) {
                if (a3.getValue() instanceof List) {
                    List values2 = (List)a3.getValue();
                    containsEvaluated.addAll(values2);
                    continue;
                }
                if (!(a3.getValue() instanceof Boolean)) continue;
                containsEvaluatedAll = true;
            }
            messages = new LinkedHashSet<ValidationMessage>();
            if (!containsEvaluatedAll) {
                for (int x2 = validCount; x2 < node2.size(); ++x2) {
                    if (containsEvaluated.contains(x2)) continue;
                    if (this.schemaNode.isBoolean() && !this.schemaNode.booleanValue()) {
                        messages.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).arguments(x2)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).build());
                    } else {
                        messages.addAll(this.schema.validate(executionContext, node2.get(x2), node2, instanceLocation.append(x2)));
                    }
                    evaluated = true;
                }
            }
            if (messages.isEmpty()) {
                valid = true;
            }
        }
        if (evaluated) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword("unevaluatedItems").value(true).build());
        }
        return messages == null || messages.isEmpty() ? Collections.emptySet() : messages;
    }
}

