/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentEntryVersionDao;
import com.ustadmobile.lib.db.entities.ContentEntryVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ContentEntryVersionDao_Impl
extends ContentEntryVersionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentEntryVersion> __insertionAdapterOfContentEntryVersion;
    private final SharedSQLiteStatement __preparedStmtOfUpdateTransferJobItemEtag;

    public ContentEntryVersionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentEntryVersion = new EntityInsertionAdapter<ContentEntryVersion>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentEntryVersion` (`cevUid`,`cevContentEntryUid`,`cevOpenUri`,`cevContentType`,`cevManifestUrl`,`cevSize`,`cevInActive`,`cevLastModified`,`cevLct`,`cevStorageSize`,`cevOriginalSize`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryVersion entity) {
                statement.bindLong(1, entity.getCevUid());
                statement.bindLong(2, entity.getCevContentEntryUid());
                if (entity.getCevOpenUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCevOpenUri());
                }
                if (entity.getCevContentType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCevContentType());
                }
                if (entity.getCevManifestUrl() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCevManifestUrl());
                }
                statement.bindLong(6, entity.getCevSize());
                int _tmp = entity.getCevInActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getCevLastModified());
                statement.bindLong(9, entity.getCevLct());
                statement.bindLong(10, entity.getCevStorageSize());
                statement.bindLong(11, entity.getCevOriginalSize());
            }
        };
        this.__preparedStmtOfUpdateTransferJobItemEtag = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT cevLct\n                  FROM ContentEntryVersion\n                 WHERE cevUid = ?)\n         WHERE tjiUid = ?\n    ";
                return "\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT cevLct\n                  FROM ContentEntryVersion\n                 WHERE cevUid = ?)\n         WHERE tjiUid = ?\n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final ContentEntryVersion contentEntryVersion, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentEntryVersionDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentEntryVersionDao_Impl.this.__insertionAdapterOfContentEntryVersion.insertAndReturnId((Object)contentEntryVersion);
                    ContentEntryVersionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentEntryVersionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateTransferJobItemEtag(final long entityUid, final int transferJobItemUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContentEntryVersionDao_Impl.this.__preparedStmtOfUpdateTransferJobItemEtag.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, entityUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)transferJobItemUid);
                try {
                    Unit unit;
                    ContentEntryVersionDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ContentEntryVersionDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ContentEntryVersionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ContentEntryVersionDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ContentEntryVersionDao_Impl.this.__preparedStmtOfUpdateTransferJobItemEtag.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long cevUid, Continuation<? super ContentEntryVersion> $completion) {
        String _sql = "\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE cevUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE cevUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, cevUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryVersion>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryVersion call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryVersionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryVersion _result2;
                    int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevUid");
                    int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentEntryUid");
                    int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOpenUri");
                    int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentType");
                    int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevManifestUrl");
                    int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevSize");
                    int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevInActive");
                    int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLastModified");
                    int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLct");
                    int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevStorageSize");
                    int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOriginalSize");
                    if (_cursor.moveToFirst()) {
                        long _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
                        long _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
                        String _tmpCevOpenUri = _cursor.isNull(_cursorIndexOfCevOpenUri) ? null : _cursor.getString(_cursorIndexOfCevOpenUri);
                        String _tmpCevContentType = _cursor.isNull(_cursorIndexOfCevContentType) ? null : _cursor.getString(_cursorIndexOfCevContentType);
                        String _tmpCevManifestUrl = _cursor.isNull(_cursorIndexOfCevManifestUrl) ? null : _cursor.getString(_cursorIndexOfCevManifestUrl);
                        long _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
                        boolean _tmpCevInActive = _tmp != 0;
                        long _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
                        long _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
                        long _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
                        long _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
                        _result2 = new ContentEntryVersion(_tmpCevUid, _tmpCevContentEntryUid, _tmpCevOpenUri, _tmpCevContentType, _tmpCevManifestUrl, _tmpCevSize, _tmpCevInActive, _tmpCevLastModified, _tmpCevLct, _tmpCevStorageSize, _tmpCevOriginalSize);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryVersion contentEntryVersion = _result2;
                    return contentEntryVersion;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findLatestVersionUidByContentEntryUidEntity(long contentEntryUid, Continuation<? super ContentEntryVersion> $completion) {
        String _sql = "\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = ?\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = ?\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryVersion>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryVersion call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryVersionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryVersion _result2;
                    int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevUid");
                    int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentEntryUid");
                    int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOpenUri");
                    int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentType");
                    int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevManifestUrl");
                    int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevSize");
                    int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevInActive");
                    int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLastModified");
                    int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLct");
                    int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevStorageSize");
                    int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOriginalSize");
                    if (_cursor.moveToFirst()) {
                        long _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
                        long _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
                        String _tmpCevOpenUri = _cursor.isNull(_cursorIndexOfCevOpenUri) ? null : _cursor.getString(_cursorIndexOfCevOpenUri);
                        String _tmpCevContentType = _cursor.isNull(_cursorIndexOfCevContentType) ? null : _cursor.getString(_cursorIndexOfCevContentType);
                        String _tmpCevManifestUrl = _cursor.isNull(_cursorIndexOfCevManifestUrl) ? null : _cursor.getString(_cursorIndexOfCevManifestUrl);
                        long _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
                        boolean _tmpCevInActive = _tmp != 0;
                        long _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
                        long _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
                        long _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
                        long _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
                        _result2 = new ContentEntryVersion(_tmpCevUid, _tmpCevContentEntryUid, _tmpCevOpenUri, _tmpCevContentType, _tmpCevManifestUrl, _tmpCevSize, _tmpCevInActive, _tmpCevLastModified, _tmpCevLct, _tmpCevStorageSize, _tmpCevOriginalSize);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryVersion contentEntryVersion = _result2;
                    return contentEntryVersion;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ContentEntryVersion> findLatestByContentEntryUidAsFlow(long contentEntryUid) {
        String _sql = "\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = ?\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = ?\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ContentEntryVersion"}, (Callable)new Callable<ContentEntryVersion>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryVersion call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryVersionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ContentEntryVersion _result2;
                    int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevUid");
                    int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentEntryUid");
                    int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOpenUri");
                    int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentType");
                    int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevManifestUrl");
                    int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevSize");
                    int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevInActive");
                    int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLastModified");
                    int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLct");
                    int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevStorageSize");
                    int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOriginalSize");
                    if (_cursor.moveToFirst()) {
                        long _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
                        long _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
                        String _tmpCevOpenUri = _cursor.isNull(_cursorIndexOfCevOpenUri) ? null : _cursor.getString(_cursorIndexOfCevOpenUri);
                        String _tmpCevContentType = _cursor.isNull(_cursorIndexOfCevContentType) ? null : _cursor.getString(_cursorIndexOfCevContentType);
                        String _tmpCevManifestUrl = _cursor.isNull(_cursorIndexOfCevManifestUrl) ? null : _cursor.getString(_cursorIndexOfCevManifestUrl);
                        long _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
                        boolean _tmpCevInActive = _tmp != 0;
                        long _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
                        long _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
                        long _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
                        long _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
                        _result2 = new ContentEntryVersion(_tmpCevUid, _tmpCevContentEntryUid, _tmpCevOpenUri, _tmpCevContentType, _tmpCevManifestUrl, _tmpCevSize, _tmpCevInActive, _tmpCevLastModified, _tmpCevLct, _tmpCevStorageSize, _tmpCevOriginalSize);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryVersion contentEntryVersion = _result2;
                    return contentEntryVersion;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findContentEntryVersionsWithoutCacheLock(Continuation<? super List<ContentEntryVersion>> $completion) {
        String _sql = "\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE NOT EXISTS(\n               SELECT CacheLockJoin.cljId\n                 FROM CacheLockJoin\n                WHERE CacheLockJoin.cljTableId = 738\n                  AND CacheLockJoin.cljEntityUid = ContentEntryVersion.cevUid\n                  AND CacheLockJoin.cljUrl = ContentEntryVersion.cevManifestUrl) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE NOT EXISTS(\n               SELECT CacheLockJoin.cljId\n                 FROM CacheLockJoin\n                WHERE CacheLockJoin.cljTableId = 738\n                  AND CacheLockJoin.cljEntityUid = ContentEntryVersion.cevUid\n                  AND CacheLockJoin.cljUrl = ContentEntryVersion.cevManifestUrl) \n    ", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntryVersion>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntryVersion> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryVersionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevUid");
                    int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentEntryUid");
                    int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOpenUri");
                    int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentType");
                    int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevManifestUrl");
                    int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevSize");
                    int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevInActive");
                    int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLastModified");
                    int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLct");
                    int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevStorageSize");
                    int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOriginalSize");
                    ArrayList<ContentEntryVersion> _result2 = new ArrayList<ContentEntryVersion>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
                        long _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
                        String _tmpCevOpenUri = _cursor.isNull(_cursorIndexOfCevOpenUri) ? null : _cursor.getString(_cursorIndexOfCevOpenUri);
                        String _tmpCevContentType = _cursor.isNull(_cursorIndexOfCevContentType) ? null : _cursor.getString(_cursorIndexOfCevContentType);
                        String _tmpCevManifestUrl = _cursor.isNull(_cursorIndexOfCevManifestUrl) ? null : _cursor.getString(_cursorIndexOfCevManifestUrl);
                        long _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
                        boolean _tmpCevInActive = _tmp != 0;
                        long _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
                        long _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
                        long _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
                        long _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
                        ContentEntryVersion _item = new ContentEntryVersion(_tmpCevUid, _tmpCevContentEntryUid, _tmpCevOpenUri, _tmpCevContentType, _tmpCevManifestUrl, _tmpCevSize, _tmpCevInActive, _tmpCevLastModified, _tmpCevLct, _tmpCevStorageSize, _tmpCevOriginalSize);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntryVersion> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

