/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ReportDao;
import com.ustadmobile.lib.db.entities.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ReportDao_Impl
extends ReportDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Report> __insertionAdapterOfReport;
    private final EntityInsertionAdapter<Report> __insertionAdapterOfReport_1;
    private final EntityDeletionOrUpdateAdapter<Report> __updateAdapterOfReport;
    private final SharedSQLiteStatement __preparedStmtOfDeleteReportByUid;

    public ReportDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReport = new EntityInsertionAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Report` (`reportUid`,`reportTitle`,`reportOptions`,`reportIsTemplate`,`reportLastModTime`,`reportOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getReportTitle());
                }
                if (entity.getReportOptions() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getReportOptions());
                }
                int _tmp = entity.getReportIsTemplate() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getReportLastModTime());
                statement.bindLong(6, entity.getReportOwnerPersonUid());
            }
        };
        this.__insertionAdapterOfReport_1 = new EntityInsertionAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Report` (`reportUid`,`reportTitle`,`reportOptions`,`reportIsTemplate`,`reportLastModTime`,`reportOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getReportTitle());
                }
                if (entity.getReportOptions() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getReportOptions());
                }
                int _tmp = entity.getReportIsTemplate() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getReportLastModTime());
                statement.bindLong(6, entity.getReportOwnerPersonUid());
            }
        };
        this.__updateAdapterOfReport = new EntityDeletionOrUpdateAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Report` SET `reportUid` = ?,`reportTitle` = ?,`reportOptions` = ?,`reportIsTemplate` = ?,`reportLastModTime` = ?,`reportOwnerPersonUid` = ? WHERE `reportUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getReportTitle());
                }
                if (entity.getReportOptions() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getReportOptions());
                }
                int _tmp = entity.getReportIsTemplate() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getReportLastModTime());
                statement.bindLong(6, entity.getReportOwnerPersonUid());
                statement.bindLong(7, entity.getReportUid());
            }
        };
        this.__preparedStmtOfDeleteReportByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM Report WHERE reportUid = ?";
                return "DELETE FROM Report WHERE reportUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Report entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfReport.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Report entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ReportDao_Impl.this.__insertionAdapterOfReport.insertAndReturnId((Object)entity);
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Report> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReport.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void replaceList(List<Report> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReport_1.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Report entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfReport.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Report entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    ReportDao_Impl.this.__updateAdapterOfReport.handle((Object)entity);
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteReportByUid(final long reportUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ReportDao_Impl.this.__preparedStmtOfDeleteReportByUid.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, reportUid);
                try {
                    Unit unit;
                    ReportDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ReportDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ReportDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ReportDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ReportDao_Impl.this.__preparedStmtOfDeleteReportByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, Report> findAllReports() {
        String _sql = "SELECT * FROM Report ORDER BY reportTitle ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Report ORDER BY reportTitle ASC", (int)0);
        return new LimitOffsetPagingSource<Report>(_statement, this.__db, new String[]{"Report"}){

            @NonNull
            protected List<Report> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportUid");
                int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportTitle");
                int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportOptions");
                int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportIsTemplate");
                int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportLastModTime");
                int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportOwnerPersonUid");
                ArrayList<Report> _result2 = new ArrayList<Report>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
                    String _tmpReportTitle = cursor.isNull(_cursorIndexOfReportTitle) ? null : cursor.getString(_cursorIndexOfReportTitle);
                    String _tmpReportOptions = cursor.isNull(_cursorIndexOfReportOptions) ? null : cursor.getString(_cursorIndexOfReportOptions);
                    int _tmp = cursor.getInt(_cursorIndexOfReportIsTemplate);
                    boolean _tmpReportIsTemplate = _tmp != 0;
                    long _tmpReportLastModTime = cursor.getLong(_cursorIndexOfReportLastModTime);
                    long _tmpReportOwnerPersonUid = cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                    Report _item = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public PagingSource<Integer, Report> findAllActiveReport(String searchBit, boolean isTemplate) {
        String _sql = "\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        AND reportTitle LIKE ?\n        ORDER BY reportTitle\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        AND reportTitle LIKE ?\n        ORDER BY reportTitle\n    ", (int)2);
        int _argIndex = 1;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindString(_argIndex, searchBit);
        return new LimitOffsetPagingSource<Report>(_statement, this.__db, new String[]{"Report"}){

            @NonNull
            protected List<Report> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportUid");
                int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportTitle");
                int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportOptions");
                int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportIsTemplate");
                int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportLastModTime");
                int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportOwnerPersonUid");
                ArrayList<Report> _result2 = new ArrayList<Report>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
                    String _tmpReportTitle = cursor.isNull(_cursorIndexOfReportTitle) ? null : cursor.getString(_cursorIndexOfReportTitle);
                    String _tmpReportOptions = cursor.isNull(_cursorIndexOfReportOptions) ? null : cursor.getString(_cursorIndexOfReportOptions);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfReportIsTemplate);
                    boolean _tmpReportIsTemplate = _tmp_1 != 0;
                    long _tmpReportLastModTime = cursor.getLong(_cursorIndexOfReportLastModTime);
                    long _tmpReportOwnerPersonUid = cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                    Report _item = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findByUid(long entityUid, Continuation<? super Report> $completion) {
        String _sql = "SELECT * FROM Report WHERE reportUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Report WHERE reportUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Report>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Report call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Report _result2;
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOptions");
                    int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportIsTemplate");
                    int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastModTime");
                    int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        String _tmpReportOptions = _cursor.isNull(_cursorIndexOfReportOptions) ? null : _cursor.getString(_cursorIndexOfReportOptions);
                        int _tmp = _cursor.getInt(_cursorIndexOfReportIsTemplate);
                        boolean _tmpReportIsTemplate = _tmp != 0;
                        long _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
                        long _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                        _result2 = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Report report = _result2;
                    return report;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Report> findByUidLive(long uid) {
        String _sql = "SELECT * FROM Report WHERE reportUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Report WHERE reportUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Report"}, (Callable)new Callable<Report>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Report call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Report _result2;
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOptions");
                    int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportIsTemplate");
                    int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastModTime");
                    int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        String _tmpReportOptions = _cursor.isNull(_cursorIndexOfReportOptions) ? null : _cursor.getString(_cursorIndexOfReportOptions);
                        int _tmp = _cursor.getInt(_cursorIndexOfReportIsTemplate);
                        boolean _tmpReportIsTemplate = _tmp != 0;
                        long _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
                        long _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                        _result2 = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Report report = _result2;
                    return report;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<Report>> findAllActiveReportLive(boolean isTemplate) {
        String _sql = "\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        ORDER BY reportTitle ASC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        ORDER BY reportTitle ASC\n    ", (int)1);
        int _argIndex = 1;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Report"}, (Callable)new Callable<List<Report>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Report> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOptions");
                    int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportIsTemplate");
                    int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastModTime");
                    int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerPersonUid");
                    ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        String _tmpReportOptions = _cursor.isNull(_cursorIndexOfReportOptions) ? null : _cursor.getString(_cursorIndexOfReportOptions);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfReportIsTemplate);
                        boolean _tmpReportIsTemplate = _tmp_1 != 0;
                        long _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
                        long _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                        Report _item = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                        _result2.add(_item);
                    }
                    ArrayList<Report> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Report> findAllActiveReportList(boolean isTemplate) {
        String _sql = "\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        ORDER BY reportTitle ASC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * FROM Report \n        WHERE reportIsTemplate = ?\n        ORDER BY reportTitle ASC\n    ", (int)1);
        int _argIndex = 1;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
            int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
            int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOptions");
            int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportIsTemplate");
            int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastModTime");
            int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerPersonUid");
            ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                String _tmpReportOptions = _cursor.isNull(_cursorIndexOfReportOptions) ? null : _cursor.getString(_cursorIndexOfReportOptions);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfReportIsTemplate);
                boolean _tmpReportIsTemplate = _tmp_1 != 0;
                long _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
                long _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
                Report _item = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
                _result2.add(_item);
            }
            ArrayList<Report> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findByUidList(List<Long> uidList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT reportUid FROM Report WHERE reportUid IN (");
        int _inputSize = uidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : uidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Long _item_1 = _cursor.getLong(0);
                _result2.add(_item_1);
            }
            ArrayList<Long> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object toggleVisibilityReportItems(final boolean toggleVisibility, final List<Long> selectedItem, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE Report ");
                _stringBuilder.append("\n");
                _stringBuilder.append("        SET reportIsTemplate = ");
                _stringBuilder.append("?");
                _stringBuilder.append(",");
                _stringBuilder.append("\n");
                _stringBuilder.append("            reportLastModTime = ");
                _stringBuilder.append("?");
                _stringBuilder.append("\n");
                _stringBuilder.append("        WHERE reportUid IN (");
                int _inputSize = selectedItem.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ReportDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                int _tmp = toggleVisibility ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = selectedItem.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Report> getResults(SupportSQLiteQuery query) {
        this.__db.assertNotSuspendingTransaction();
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)query, (boolean)false, null);){
            ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Report _item = this.__entityCursorConverter_comUstadmobileLibDbEntitiesReport(_cursor);
                _result2.add(_item);
            }
            ArrayList<Report> arrayList = _result2;
            return arrayList;
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private Report __entityCursorConverter_comUstadmobileLibDbEntitiesReport(@NonNull Cursor cursor) {
        int _tmp;
        int _cursorIndexOfReportUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportUid");
        int _cursorIndexOfReportTitle = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportTitle");
        int _cursorIndexOfReportOptions = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportOptions");
        int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportIsTemplate");
        int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportLastModTime");
        int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportOwnerPersonUid");
        long _tmpReportUid = _cursorIndexOfReportUid == -1 ? 0L : cursor.getLong(_cursorIndexOfReportUid);
        String _tmpReportTitle = _cursorIndexOfReportTitle == -1 ? null : (cursor.isNull(_cursorIndexOfReportTitle) ? null : cursor.getString(_cursorIndexOfReportTitle));
        String _tmpReportOptions = _cursorIndexOfReportOptions == -1 ? null : (cursor.isNull(_cursorIndexOfReportOptions) ? null : cursor.getString(_cursorIndexOfReportOptions));
        boolean _tmpReportIsTemplate = _cursorIndexOfReportIsTemplate == -1 ? false : (_tmp = cursor.getInt(_cursorIndexOfReportIsTemplate)) != 0;
        long _tmpReportLastModTime = _cursorIndexOfReportLastModTime == -1 ? 0L : cursor.getLong(_cursorIndexOfReportLastModTime);
        long _tmpReportOwnerPersonUid = _cursorIndexOfReportOwnerPersonUid == -1 ? 0L : cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
        Report _entity = new Report(_tmpReportUid, _tmpReportTitle, _tmpReportOptions, _tmpReportIsTemplate, _tmpReportLastModTime, _tmpReportOwnerPersonUid);
        return _entity;
    }
}

