/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonParentJoinDao;
import com.ustadmobile.lib.db.entities.ParentEnrolmentRequired;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonParentJoinAndMinorPerson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class PersonParentJoinDao_Impl
extends PersonParentJoinDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonParentJoin> __insertionAdapterOfPersonParentJoin;
    private final EntityInsertionAdapter<PersonParentJoin> __insertionAdapterOfPersonParentJoin_1;
    private final EntityDeletionOrUpdateAdapter<PersonParentJoin> __updateAdapterOfPersonParentJoin;

    public PersonParentJoinDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonParentJoin = new EntityInsertionAdapter<PersonParentJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonParentJoin` (`ppjUid`,`ppjPcsn`,`ppjLcsn`,`ppjLcb`,`ppjLct`,`ppjParentPersonUid`,`ppjMinorPersonUid`,`ppjRelationship`,`ppjEmail`,`ppjPhone`,`ppjInactive`,`ppjStatus`,`ppjApprovalTiemstamp`,`ppjApprovalIpAddr`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonParentJoin entity) {
                statement.bindLong(1, entity.getPpjUid());
                statement.bindLong(2, entity.getPpjPcsn());
                statement.bindLong(3, entity.getPpjLcsn());
                statement.bindLong(4, (long)entity.getPpjLcb());
                statement.bindLong(5, entity.getPpjLct());
                statement.bindLong(6, entity.getPpjParentPersonUid());
                statement.bindLong(7, entity.getPpjMinorPersonUid());
                statement.bindLong(8, (long)entity.getPpjRelationship());
                if (entity.getPpjEmail() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getPpjEmail());
                }
                if (entity.getPpjPhone() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getPpjPhone());
                }
                int _tmp = entity.getPpjInactive() ? 1 : 0;
                statement.bindLong(11, (long)_tmp);
                statement.bindLong(12, (long)entity.getPpjStatus());
                statement.bindLong(13, entity.getPpjApprovalTiemstamp());
                if (entity.getPpjApprovalIpAddr() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getPpjApprovalIpAddr());
                }
            }
        };
        this.__insertionAdapterOfPersonParentJoin_1 = new EntityInsertionAdapter<PersonParentJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonParentJoin` (`ppjUid`,`ppjPcsn`,`ppjLcsn`,`ppjLcb`,`ppjLct`,`ppjParentPersonUid`,`ppjMinorPersonUid`,`ppjRelationship`,`ppjEmail`,`ppjPhone`,`ppjInactive`,`ppjStatus`,`ppjApprovalTiemstamp`,`ppjApprovalIpAddr`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonParentJoin entity) {
                statement.bindLong(1, entity.getPpjUid());
                statement.bindLong(2, entity.getPpjPcsn());
                statement.bindLong(3, entity.getPpjLcsn());
                statement.bindLong(4, (long)entity.getPpjLcb());
                statement.bindLong(5, entity.getPpjLct());
                statement.bindLong(6, entity.getPpjParentPersonUid());
                statement.bindLong(7, entity.getPpjMinorPersonUid());
                statement.bindLong(8, (long)entity.getPpjRelationship());
                if (entity.getPpjEmail() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getPpjEmail());
                }
                if (entity.getPpjPhone() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getPpjPhone());
                }
                int _tmp = entity.getPpjInactive() ? 1 : 0;
                statement.bindLong(11, (long)_tmp);
                statement.bindLong(12, (long)entity.getPpjStatus());
                statement.bindLong(13, entity.getPpjApprovalTiemstamp());
                if (entity.getPpjApprovalIpAddr() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getPpjApprovalIpAddr());
                }
            }
        };
        this.__updateAdapterOfPersonParentJoin = new EntityDeletionOrUpdateAdapter<PersonParentJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PersonParentJoin` SET `ppjUid` = ?,`ppjPcsn` = ?,`ppjLcsn` = ?,`ppjLcb` = ?,`ppjLct` = ?,`ppjParentPersonUid` = ?,`ppjMinorPersonUid` = ?,`ppjRelationship` = ?,`ppjEmail` = ?,`ppjPhone` = ?,`ppjInactive` = ?,`ppjStatus` = ?,`ppjApprovalTiemstamp` = ?,`ppjApprovalIpAddr` = ? WHERE `ppjUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonParentJoin entity) {
                statement.bindLong(1, entity.getPpjUid());
                statement.bindLong(2, entity.getPpjPcsn());
                statement.bindLong(3, entity.getPpjLcsn());
                statement.bindLong(4, (long)entity.getPpjLcb());
                statement.bindLong(5, entity.getPpjLct());
                statement.bindLong(6, entity.getPpjParentPersonUid());
                statement.bindLong(7, entity.getPpjMinorPersonUid());
                statement.bindLong(8, (long)entity.getPpjRelationship());
                if (entity.getPpjEmail() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getPpjEmail());
                }
                if (entity.getPpjPhone() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getPpjPhone());
                }
                int _tmp = entity.getPpjInactive() ? 1 : 0;
                statement.bindLong(11, (long)_tmp);
                statement.bindLong(12, (long)entity.getPpjStatus());
                statement.bindLong(13, entity.getPpjApprovalTiemstamp());
                if (entity.getPpjApprovalIpAddr() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getPpjApprovalIpAddr());
                }
                statement.bindLong(15, entity.getPpjUid());
            }
        };
    }

    @Override
    public Object insertListAsync(final List<PersonParentJoin> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonParentJoinDao_Impl.this.__db.beginTransaction();
                try {
                    PersonParentJoinDao_Impl.this.__insertionAdapterOfPersonParentJoin.insert((Iterable)entityList);
                    PersonParentJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonParentJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertAsync(final PersonParentJoin entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonParentJoinDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonParentJoinDao_Impl.this.__insertionAdapterOfPersonParentJoin_1.insertAndReturnId((Object)entity);
                    PersonParentJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonParentJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateAsync(final PersonParentJoin personParentJoin, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonParentJoinDao_Impl.this.__db.beginTransaction();
                try {
                    PersonParentJoinDao_Impl.this.__updateAdapterOfPersonParentJoin.handle((Object)personParentJoin);
                    PersonParentJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonParentJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithMinorAsync(long uid, Continuation<? super PersonParentJoinAndMinorPerson> $completion) {
        String _sql = "\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonParentJoinAndMinorPerson>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonParentJoinAndMinorPerson call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonParentJoinAndMinorPerson _result2;
                    int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjUid");
                    int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPcsn");
                    int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcsn");
                    int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcb");
                    int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLct");
                    int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjParentPersonUid");
                    int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjMinorPersonUid");
                    int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjRelationship");
                    int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjEmail");
                    int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPhone");
                    int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjInactive");
                    int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjStatus");
                    int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalTiemstamp");
                    int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalIpAddr");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        Person _tmpMinorPerson;
                        PersonParentJoin _tmpPersonParentJoin;
                        if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
                            long _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
                            long _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
                            long _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
                            int _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
                            long _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
                            long _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
                            long _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
                            int _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
                            String _tmpPpjEmail = _cursor.isNull(_cursorIndexOfPpjEmail) ? null : _cursor.getString(_cursorIndexOfPpjEmail);
                            String _tmpPpjPhone = _cursor.isNull(_cursorIndexOfPpjPhone) ? null : _cursor.getString(_cursorIndexOfPpjPhone);
                            int _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
                            boolean _tmpPpjInactive = _tmp != 0;
                            int _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
                            long _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
                            String _tmpPpjApprovalIpAddr = _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr) ? null : _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
                            _tmpPersonParentJoin = new PersonParentJoin(_tmpPpjUid, _tmpPpjPcsn, _tmpPpjLcsn, _tmpPpjLcb, _tmpPpjLct, _tmpPpjParentPersonUid, _tmpPpjMinorPersonUid, _tmpPpjRelationship, _tmpPpjEmail, _tmpPpjPhone, _tmpPpjInactive, _tmpPpjStatus, _tmpPpjApprovalTiemstamp, _tmpPpjApprovalIpAddr);
                        } else {
                            _tmpPersonParentJoin = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_2 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_3 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpMinorPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpMinorPerson = null;
                        }
                        _result2 = new PersonParentJoinAndMinorPerson(_tmpPersonParentJoin, _tmpMinorPerson);
                    } else {
                        _result2 = null;
                    }
                    PersonParentJoinAndMinorPerson personParentJoinAndMinorPerson = _result2;
                    return personParentJoinAndMinorPerson;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithMinorAsyncFromWeb(long uid, Continuation<? super PersonParentJoinAndMinorPerson> $completion) {
        String _sql = "\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonParentJoinAndMinorPerson>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonParentJoinAndMinorPerson call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonParentJoinAndMinorPerson _result2;
                    int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjUid");
                    int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPcsn");
                    int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcsn");
                    int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcb");
                    int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLct");
                    int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjParentPersonUid");
                    int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjMinorPersonUid");
                    int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjRelationship");
                    int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjEmail");
                    int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPhone");
                    int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjInactive");
                    int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjStatus");
                    int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalTiemstamp");
                    int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalIpAddr");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        Person _tmpMinorPerson;
                        PersonParentJoin _tmpPersonParentJoin;
                        if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
                            long _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
                            long _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
                            long _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
                            int _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
                            long _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
                            long _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
                            long _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
                            int _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
                            String _tmpPpjEmail = _cursor.isNull(_cursorIndexOfPpjEmail) ? null : _cursor.getString(_cursorIndexOfPpjEmail);
                            String _tmpPpjPhone = _cursor.isNull(_cursorIndexOfPpjPhone) ? null : _cursor.getString(_cursorIndexOfPpjPhone);
                            int _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
                            boolean _tmpPpjInactive = _tmp != 0;
                            int _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
                            long _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
                            String _tmpPpjApprovalIpAddr = _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr) ? null : _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
                            _tmpPersonParentJoin = new PersonParentJoin(_tmpPpjUid, _tmpPpjPcsn, _tmpPpjLcsn, _tmpPpjLcb, _tmpPpjLct, _tmpPpjParentPersonUid, _tmpPpjMinorPersonUid, _tmpPpjRelationship, _tmpPpjEmail, _tmpPpjPhone, _tmpPpjInactive, _tmpPpjStatus, _tmpPpjApprovalTiemstamp, _tmpPpjApprovalIpAddr);
                        } else {
                            _tmpPersonParentJoin = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_2 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_3 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpMinorPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpMinorPerson = null;
                        }
                        _result2 = new PersonParentJoinAndMinorPerson(_tmpPersonParentJoin, _tmpMinorPerson);
                    } else {
                        _result2 = null;
                    }
                    PersonParentJoinAndMinorPerson personParentJoinAndMinorPerson = _result2;
                    return personParentJoinAndMinorPerson;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByMinorPersonUid(long minorPersonUid, Continuation<? super List<PersonParentJoin>> $completion) {
        String _sql = "\n        SELECT PersonParentJoin.*\n          FROM PersonParentJoin\n         WHERE ppjMinorPersonUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonParentJoin.*\n          FROM PersonParentJoin\n         WHERE ppjMinorPersonUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, minorPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonParentJoin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonParentJoin> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjUid");
                    int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPcsn");
                    int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcsn");
                    int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcb");
                    int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLct");
                    int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjParentPersonUid");
                    int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjMinorPersonUid");
                    int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjRelationship");
                    int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjEmail");
                    int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPhone");
                    int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjInactive");
                    int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjStatus");
                    int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalTiemstamp");
                    int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalIpAddr");
                    ArrayList<PersonParentJoin> _result2 = new ArrayList<PersonParentJoin>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
                        long _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
                        long _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
                        int _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
                        long _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
                        long _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
                        long _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
                        int _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
                        String _tmpPpjEmail = _cursor.isNull(_cursorIndexOfPpjEmail) ? null : _cursor.getString(_cursorIndexOfPpjEmail);
                        String _tmpPpjPhone = _cursor.isNull(_cursorIndexOfPpjPhone) ? null : _cursor.getString(_cursorIndexOfPpjPhone);
                        int _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
                        boolean _tmpPpjInactive = _tmp != 0;
                        int _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
                        long _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
                        String _tmpPpjApprovalIpAddr = _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr) ? null : _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
                        PersonParentJoin _item = new PersonParentJoin(_tmpPpjUid, _tmpPpjPcsn, _tmpPpjLcsn, _tmpPpjLcb, _tmpPpjLct, _tmpPpjParentPersonUid, _tmpPpjMinorPersonUid, _tmpPpjRelationship, _tmpPpjEmail, _tmpPpjPhone, _tmpPpjInactive, _tmpPpjStatus, _tmpPpjApprovalTiemstamp, _tmpPpjApprovalIpAddr);
                        _result2.add(_item);
                    }
                    ArrayList<PersonParentJoin> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByMinorPersonUidWhereParentNotEnrolledInClazz(long minorPersonUid, long clazzUidFilter, Continuation<? super List<ParentEnrolmentRequired>> $completion) {
        String _sql = "\n        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n          FROM PersonParentJoin\n               JOIN ClazzEnrolment ChildEnrolment \n                    ON ChildEnrolment.clazzEnrolmentPersonUid = ?\n                   AND (? = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = ?)\n         WHERE PersonParentJoin.ppjMinorPersonUid = ?\n           AND PersonParentJoin.ppjParentPersonUid != 0\n           AND NOT EXISTS(\n               SELECT clazzEnrolmentUid \n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n          FROM PersonParentJoin\n               JOIN ClazzEnrolment ChildEnrolment \n                    ON ChildEnrolment.clazzEnrolmentPersonUid = ?\n                   AND (? = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = ?)\n         WHERE PersonParentJoin.ppjMinorPersonUid = ?\n           AND PersonParentJoin.ppjParentPersonUid != 0\n           AND NOT EXISTS(\n               SELECT clazzEnrolmentUid \n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, minorPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUidFilter);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUidFilter);
        _argIndex = 4;
        _statement.bindLong(_argIndex, minorPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ParentEnrolmentRequired>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ParentEnrolmentRequired> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfParentPersonUid = false;
                    boolean _cursorIndexOfClazzUid = true;
                    ArrayList<ParentEnrolmentRequired> _result2 = new ArrayList<ParentEnrolmentRequired>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpParentPersonUid = _cursor.getLong(0);
                        long _tmpClazzUid = _cursor.getLong(1);
                        ParentEnrolmentRequired _item = new ParentEnrolmentRequired(_tmpParentPersonUid, _tmpClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<ParentEnrolmentRequired> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object isParentOf(long userPersonUid, long minorPersonUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = ?\n                      AND ppjParentPersonUid = ?\n                      AND CAST(ppjInactive AS INTEGER) = 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = ?\n                      AND ppjParentPersonUid = ?\n                      AND CAST(ppjInactive AS INTEGER) = 0)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, minorPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, userPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object isMinorApproved(long minorPersonUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = ?\n                  AND CAST(ppjInactive AS INTEGER) = 0\n                  AND ppjStatus = 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = ?\n                  AND CAST(ppjInactive AS INTEGER) = 0\n                  AND ppjStatus = 1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, minorPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonParentJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

