/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.core.db.dao.OneToManyJoinDao;
import com.ustadmobile.lib.db.entities.SiteTerms;
import com.ustadmobile.lib.db.entities.SiteTermsWithLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u00a7@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u00a7@\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u000fH\u00a7@\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u000fH\u00a7@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u00a7@\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Lcom/ustadmobile/core/db/dao/SiteTermsDao;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "Lcom/ustadmobile/lib/db/entities/SiteTerms;", "()V", "findAllTerms", "", "activeOnly", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllTermsAsListFlow", "Lkotlinx/coroutines/flow/Flow;", "findAllWithLanguageAsList", "Lcom/ustadmobile/lib/db/entities/SiteTermsWithLanguage;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAvailableSiteTermLanguages", "", "active", "findByUidAsync", "uid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findLatestByLanguage", "lang", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSiteTerms", "langCode", "insertAsync", "siteTerms", "(Lcom/ustadmobile/lib/db/entities/SiteTerms;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateActiveByUid", "", "sTermsUid", "", "changeTime", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertList", "termList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class SiteTermsDao
implements OneToManyJoinDao<SiteTerms> {
    @Query(value="\n        SELECT * FROM SiteTerms WHERE sTermsUid = coalesce(\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = :langCode LIMIT 1),\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = 'en' LIMIT 1),\n            0)\n    ")
    @Nullable
    public abstract Object findSiteTerms(@NotNull String var1, @NotNull Continuation<? super SiteTerms> var2);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertAsync(@NotNull SiteTerms var1, @NotNull Continuation<? super Long> var2);

    @Query(value="SELECT * FROM SiteTerms WHERE sTermsUid = :uid")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super SiteTerms> var3);

    @Query(value="\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE :activeOnly = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ")
    @NotNull
    public abstract Flow<List<SiteTerms>> findAllTermsAsListFlow(int var1);

    @Query(value="\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE :activeOnly = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ")
    @Nullable
    public abstract Object findAllTerms(int var1, @NotNull Continuation<? super List<? extends SiteTerms>> var2);

    @Query(value="SELECT SiteTerms.*, Language.*\n        FROM SiteTerms\n        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n        WHERE CAST(sTermsActive AS INTEGER) = 1\n    ")
    @Nullable
    public abstract Object findAllWithLanguageAsList(@NotNull Continuation<? super List<SiteTermsWithLanguage>> var1);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertList(@NotNull List<? extends SiteTerms> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        UPDATE SiteTerms \n           SET sTermsActive = :active,\n               sTermsLct = :changeTime\n         WHERE sTermsUid = :sTermsUid\n        ")
    @Nullable
    public abstract Object updateActiveByUid(long var1, boolean var3, long var4, @NotNull Continuation<? super Unit> var6);

    @Query(value="\n        SELECT SiteTerms.sTermsLang\n          FROM SiteTerms\n         WHERE CAST(SiteTerms.sTermsActive AS INTEGER) = :active \n    ")
    @Nullable
    public abstract Object findAvailableSiteTermLanguages(int var1, @NotNull Continuation<? super List<String>> var2);

    @Query(value="\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE SiteTerms.sTermsLang = :lang\n           AND CAST(SiteTerms.sTermsActive AS INTEGER) = 1\n      ORDER BY SiteTerms.sTermsLct DESC\n         LIMIT 1     \n    ")
    @Nullable
    public abstract Object findLatestByLanguage(@NotNull String var1, @NotNull Continuation<? super SiteTerms> var2);
}

