/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.ActorDao;
import com.ustadmobile.lib.db.composites.ActorUidEtagAndLastMod;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActorDao_Impl
extends ActorDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ActorEntity> __insertionAdapterOfActorEntity;
    private final EntityInsertionAdapter<ActorEntity> __insertionAdapterOfActorEntity_1;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIfNameChanged;

    public ActorDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfActorEntity = new EntityInsertionAdapter<ActorEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `ActorEntity` (`actorUid`,`actorPersonUid`,`actorName`,`actorMbox`,`actorMbox_sha1sum`,`actorOpenid`,`actorAccountName`,`actorAccountHomePage`,`actorEtag`,`actorLct`,`actorObjectType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActorEntity entity) {
                statement.bindLong(1, entity.getActorUid());
                statement.bindLong(2, entity.getActorPersonUid());
                if (entity.getActorName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getActorName());
                }
                if (entity.getActorMbox() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getActorMbox());
                }
                if (entity.getActorMbox_sha1sum() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getActorMbox_sha1sum());
                }
                if (entity.getActorOpenid() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getActorOpenid());
                }
                if (entity.getActorAccountName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getActorAccountName());
                }
                if (entity.getActorAccountHomePage() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getActorAccountHomePage());
                }
                statement.bindLong(9, entity.getActorEtag());
                statement.bindLong(10, entity.getActorLct());
                statement.bindLong(11, (long)entity.getActorObjectType());
            }
        };
        this.__insertionAdapterOfActorEntity_1 = new EntityInsertionAdapter<ActorEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ActorEntity` (`actorUid`,`actorPersonUid`,`actorName`,`actorMbox`,`actorMbox_sha1sum`,`actorOpenid`,`actorAccountName`,`actorAccountHomePage`,`actorEtag`,`actorLct`,`actorObjectType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActorEntity entity) {
                statement.bindLong(1, entity.getActorUid());
                statement.bindLong(2, entity.getActorPersonUid());
                if (entity.getActorName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getActorName());
                }
                if (entity.getActorMbox() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getActorMbox());
                }
                if (entity.getActorMbox_sha1sum() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getActorMbox_sha1sum());
                }
                if (entity.getActorOpenid() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getActorOpenid());
                }
                if (entity.getActorAccountName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getActorAccountName());
                }
                if (entity.getActorAccountHomePage() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getActorAccountHomePage());
                }
                statement.bindLong(9, entity.getActorEtag());
                statement.bindLong(10, entity.getActorLct());
                statement.bindLong(11, (long)entity.getActorObjectType());
            }
        };
        this.__preparedStmtOfUpdateIfNameChanged = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ActorEntity\n           SET actorName = ?,\n               actorLct = ?\n         WHERE actorUid = ?\n           AND ActorEntity.actorName != ?\n    ";
                return "\n        UPDATE ActorEntity\n           SET actorName = ?,\n               actorLct = ?\n         WHERE actorUid = ?\n           AND ActorEntity.actorName != ?\n    ";
            }
        };
    }

    @Override
    public Object insertOrIgnoreListAsync(final List<ActorEntity> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActorDao_Impl.this.__db.beginTransaction();
                try {
                    ActorDao_Impl.this.__insertionAdapterOfActorEntity.insert((Iterable)entities);
                    ActorDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActorDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertListAsync(final List<ActorEntity> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActorDao_Impl.this.__db.beginTransaction();
                try {
                    ActorDao_Impl.this.__insertionAdapterOfActorEntity_1.insert((Iterable)entities);
                    ActorDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActorDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateIfNameChanged(final long uid, final String name, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActorDao_Impl.this.__preparedStmtOfUpdateIfNameChanged.acquire();
                int _argIndex = 1;
                if (name == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, name);
                }
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, uid);
                _argIndex = 4;
                if (name == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, name);
                }
                try {
                    Unit unit;
                    ActorDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ActorDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ActorDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ActorDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ActorDao_Impl.this.__preparedStmtOfUpdateIfNameChanged.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super ActorEntity> $completion) {
        String _sql = "\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ActorEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ActorEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ActorEntity _result2;
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    if (_cursor.moveToFirst()) {
                        long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                        long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                        String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                        String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                        String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                        String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                        String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                        String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                        long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                        long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                        int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                        _result2 = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                    } else {
                        _result2 = null;
                    }
                    ActorEntity actorEntity = _result2;
                    return actorEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAndPersonUidAsync(long actorUid, long accountPersonUid, Continuation<? super ActorEntity> $completion) {
        String _sql = "\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = ?\n           AND ActorEntity.actorPersonUid = ?  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = ?\n           AND ActorEntity.actorPersonUid = ?  \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ActorEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ActorEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ActorEntity _result2;
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    if (_cursor.moveToFirst()) {
                        long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                        long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                        String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                        String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                        String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                        String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                        String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                        String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                        long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                        long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                        int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                        _result2 = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                    } else {
                        _result2 = null;
                    }
                    ActorEntity actorEntity = _result2;
                    return actorEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findUidAndEtagByListAsync(List<Long> uidList, Continuation<? super List<ActorUidEtagAndLastMod>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT ActorEntity.actorUid, ActorEntity.actorEtag, ActorEntity.actorLct");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ActorEntity.actorUid IN (");
        int _inputSize = uidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : uidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActorUidEtagAndLastMod>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActorUidEtagAndLastMod> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfActorUid = false;
                    boolean _cursorIndexOfActorEtag = true;
                    int _cursorIndexOfActorLct = 2;
                    ArrayList<ActorUidEtagAndLastMod> _result2 = new ArrayList<ActorUidEtagAndLastMod>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpActorUid = _cursor.getLong(0);
                        long _tmpActorEtag = _cursor.getLong(1);
                        long _tmpActorLct = _cursor.getLong(2);
                        ActorUidEtagAndLastMod _item_1 = new ActorUidEtagAndLastMod(_tmpActorUid, _tmpActorEtag, _tmpActorLct);
                        _result2.add(_item_1);
                    }
                    ArrayList<ActorUidEtagAndLastMod> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findGroupMembers(long groupActorUid, Continuation<? super List<ActorEntity>> $completion) {
        String _sql = "\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid IN (\n               SELECT GroupMemberActorJoin.gmajMemberActorUid\n                 FROM GroupMemberActorJoin\n                WHERE GroupMemberActorJoin.gmajGroupActorUid = ?\n                  AND GroupMemberActorJoin.gmajLastMod = (\n                      SELECT GroupActorEntity.actorLct\n                        FROM ActorEntity GroupActorEntity\n                       WHERE GroupActorEntity.actorUid = ?)\n              ) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid IN (\n               SELECT GroupMemberActorJoin.gmajMemberActorUid\n                 FROM GroupMemberActorJoin\n                WHERE GroupMemberActorJoin.gmajGroupActorUid = ?\n                  AND GroupMemberActorJoin.gmajLastMod = (\n                      SELECT GroupActorEntity.actorLct\n                        FROM ActorEntity GroupActorEntity\n                       WHERE GroupActorEntity.actorUid = ?)\n              ) \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupActorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, groupActorUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActorEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActorEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    ArrayList<ActorEntity> _result2 = new ArrayList<ActorEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                        long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                        String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                        String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                        String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                        String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                        String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                        String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                        long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                        long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                        int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                        ActorEntity _item = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                        _result2.add(_item);
                    }
                    ArrayList<ActorEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

