/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzDao;
import com.ustadmobile.lib.db.composites.ClazzAndDetailPermissions;
import com.ustadmobile.lib.db.composites.ClazzAndDisplayDetails;
import com.ustadmobile.lib.db.composites.ClazzNameAndTerminology;
import com.ustadmobile.lib.db.composites.ClazzUidAndName;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndAndTerminology;
import com.ustadmobile.lib.db.entities.ClazzWithListDisplayDetails;
import com.ustadmobile.lib.db.entities.CoursePicture;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ClazzDao_Impl
extends ClazzDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Clazz> __insertionAdapterOfClazz;
    private final EntityDeletionOrUpdateAdapter<Clazz> __updateAdapterOfClazz;
    private final SharedSQLiteStatement __preparedStmtOfUpdateClazzAttendanceAverageAsync;

    public ClazzDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazz = new EntityInsertionAdapter<Clazz>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Clazz` (`clazzUid`,`clazzName`,`clazzDesc`,`attendanceAverage`,`clazzHolidayUMCalendarUid`,`clazzScheuleUMCalendarUid`,`isClazzActive`,`clazzLocationUid`,`clazzStartTime`,`clazzEndTime`,`clazzFeatures`,`clazzSchoolUid`,`clazzEnrolmentPolicy`,`clazzTerminologyUid`,`clazzMasterChangeSeqNum`,`clazzLocalChangeSeqNum`,`clazzLastChangedBy`,`clazzLct`,`clazzTimeZone`,`clazzStudentsPersonGroupUid`,`clazzTeachersPersonGroupUid`,`clazzPendingStudentsPersonGroupUid`,`clazzParentsPersonGroupUid`,`clazzCode`,`clazzOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Clazz entity) {
                statement.bindLong(1, entity.getClazzUid());
                if (entity.getClazzName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getClazzName());
                }
                if (entity.getClazzDesc() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getClazzDesc());
                }
                statement.bindDouble(4, (double)entity.getAttendanceAverage());
                statement.bindLong(5, entity.getClazzHolidayUMCalendarUid());
                statement.bindLong(6, entity.getClazzScheuleUMCalendarUid());
                int _tmp = entity.isClazzActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getClazzLocationUid());
                statement.bindLong(9, entity.getClazzStartTime());
                statement.bindLong(10, entity.getClazzEndTime());
                statement.bindLong(11, entity.getClazzFeatures());
                statement.bindLong(12, entity.getClazzSchoolUid());
                statement.bindLong(13, (long)entity.getClazzEnrolmentPolicy());
                statement.bindLong(14, entity.getClazzTerminologyUid());
                statement.bindLong(15, entity.getClazzMasterChangeSeqNum());
                statement.bindLong(16, entity.getClazzLocalChangeSeqNum());
                statement.bindLong(17, (long)entity.getClazzLastChangedBy());
                statement.bindLong(18, entity.getClazzLct());
                if (entity.getClazzTimeZone() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindString(19, entity.getClazzTimeZone());
                }
                statement.bindLong(20, entity.getClazzStudentsPersonGroupUid());
                statement.bindLong(21, entity.getClazzTeachersPersonGroupUid());
                statement.bindLong(22, entity.getClazzPendingStudentsPersonGroupUid());
                statement.bindLong(23, entity.getClazzParentsPersonGroupUid());
                if (entity.getClazzCode() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getClazzCode());
                }
                statement.bindLong(25, entity.getClazzOwnerPersonUid());
            }
        };
        this.__updateAdapterOfClazz = new EntityDeletionOrUpdateAdapter<Clazz>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Clazz` SET `clazzUid` = ?,`clazzName` = ?,`clazzDesc` = ?,`attendanceAverage` = ?,`clazzHolidayUMCalendarUid` = ?,`clazzScheuleUMCalendarUid` = ?,`isClazzActive` = ?,`clazzLocationUid` = ?,`clazzStartTime` = ?,`clazzEndTime` = ?,`clazzFeatures` = ?,`clazzSchoolUid` = ?,`clazzEnrolmentPolicy` = ?,`clazzTerminologyUid` = ?,`clazzMasterChangeSeqNum` = ?,`clazzLocalChangeSeqNum` = ?,`clazzLastChangedBy` = ?,`clazzLct` = ?,`clazzTimeZone` = ?,`clazzStudentsPersonGroupUid` = ?,`clazzTeachersPersonGroupUid` = ?,`clazzPendingStudentsPersonGroupUid` = ?,`clazzParentsPersonGroupUid` = ?,`clazzCode` = ?,`clazzOwnerPersonUid` = ? WHERE `clazzUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Clazz entity) {
                statement.bindLong(1, entity.getClazzUid());
                if (entity.getClazzName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getClazzName());
                }
                if (entity.getClazzDesc() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getClazzDesc());
                }
                statement.bindDouble(4, (double)entity.getAttendanceAverage());
                statement.bindLong(5, entity.getClazzHolidayUMCalendarUid());
                statement.bindLong(6, entity.getClazzScheuleUMCalendarUid());
                int _tmp = entity.isClazzActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getClazzLocationUid());
                statement.bindLong(9, entity.getClazzStartTime());
                statement.bindLong(10, entity.getClazzEndTime());
                statement.bindLong(11, entity.getClazzFeatures());
                statement.bindLong(12, entity.getClazzSchoolUid());
                statement.bindLong(13, (long)entity.getClazzEnrolmentPolicy());
                statement.bindLong(14, entity.getClazzTerminologyUid());
                statement.bindLong(15, entity.getClazzMasterChangeSeqNum());
                statement.bindLong(16, entity.getClazzLocalChangeSeqNum());
                statement.bindLong(17, (long)entity.getClazzLastChangedBy());
                statement.bindLong(18, entity.getClazzLct());
                if (entity.getClazzTimeZone() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindString(19, entity.getClazzTimeZone());
                }
                statement.bindLong(20, entity.getClazzStudentsPersonGroupUid());
                statement.bindLong(21, entity.getClazzTeachersPersonGroupUid());
                statement.bindLong(22, entity.getClazzPendingStudentsPersonGroupUid());
                statement.bindLong(23, entity.getClazzParentsPersonGroupUid());
                if (entity.getClazzCode() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getClazzCode());
                }
                statement.bindLong(25, entity.getClazzOwnerPersonUid());
                statement.bindLong(26, entity.getClazzUid());
            }
        };
        this.__preparedStmtOfUpdateClazzAttendanceAverageAsync = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE Clazz \n           SET attendanceAverage = \n               COALESCE(CAST(\n                    (SELECT SUM(clazzLogNumPresent) \n                       FROM ClazzLog \n                      WHERE clazzLogClazzUid = ?\n                       AND clazzLogStatusFlag = 4) AS REAL) /\n                    \n                    CAST(MAX(1.0, \n                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n                        FROM ClazzLog \n                       WHERE clazzLogClazzUid = ? \n                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n               clazzLct = ?         \n         WHERE clazzUid = ?\n    ";
                return "\n        UPDATE Clazz \n           SET attendanceAverage = \n               COALESCE(CAST(\n                    (SELECT SUM(clazzLogNumPresent) \n                       FROM ClazzLog \n                      WHERE clazzLogClazzUid = ?\n                       AND clazzLogStatusFlag = 4) AS REAL) /\n                    \n                    CAST(MAX(1.0, \n                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n                        FROM ClazzLog \n                       WHERE clazzLogClazzUid = ? \n                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n               clazzLct = ?         \n         WHERE clazzUid = ?\n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Clazz entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazz.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Clazz entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzDao_Impl.this.__insertionAdapterOfClazz.insertAndReturnId((Object)entity);
                    ClazzDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Clazz> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazz.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Clazz entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazz.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Clazz entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                ClazzDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ClazzDao_Impl.this.__updateAdapterOfClazz.handle((Object)entity);
                    return n;
                }
                finally {
                    ClazzDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateClazzAttendanceAverageAsync(final long clazzUid, final long timeChanged, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzDao_Impl.this.__preparedStmtOfUpdateClazzAttendanceAverageAsync.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, clazzUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, clazzUid);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, timeChanged);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, clazzUid);
                try {
                    Unit unit;
                    ClazzDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ClazzDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ClazzDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ClazzDao_Impl.this.__preparedStmtOfUpdateClazzAttendanceAverageAsync.release(_stmt);
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clazz findByUid(long uid) {
        String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Clazz _result2;
            int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
            int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
            int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
            int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
            int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
            int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
            int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
            int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
            int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
            int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
            int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
            int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
            int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
            int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
            int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
            int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
            int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
            int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
            int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
            int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
            int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
            int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
            int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
            int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
            int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
            if (_cursor.moveToFirst()) {
                _result2 = new Clazz();
                long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                _result2.setClazzUid(_tmpClazzUid);
                String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                _result2.setClazzName(_tmpClazzName);
                String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                _result2.setClazzDesc(_tmpClazzDesc);
                float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                _result2.setAttendanceAverage(_tmpAttendanceAverage);
                long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                boolean _tmpIsClazzActive = _tmp != 0;
                _result2.setClazzActive(_tmpIsClazzActive);
                long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                _result2.setClazzLocationUid(_tmpClazzLocationUid);
                long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                _result2.setClazzStartTime(_tmpClazzStartTime);
                long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                _result2.setClazzEndTime(_tmpClazzEndTime);
                long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                _result2.setClazzFeatures(_tmpClazzFeatures);
                long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                _result2.setClazzLct(_tmpClazzLct);
                String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                _result2.setClazzTimeZone(_tmpClazzTimeZone);
                long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                _result2.setClazzCode(_tmpClazzCode);
                long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
                _result2 = null;
            }
            Clazz clazz = _result2;
            return clazz;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<Clazz> findByUidLive(long uid) {
        String _sql = "SELECT * From Clazz WHERE clazzUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * From Clazz WHERE clazzUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz"}, (Callable)new Callable<Clazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Clazz call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Clazz _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Clazz clazz = _result2;
                    return clazz;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByClazzCode(String code, Continuation<? super Clazz> $completion) {
        String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzCode = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, code);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Clazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Clazz call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Clazz _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Clazz clazz = _result2;
                    return clazz;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzCodeFromWeb(String code, Continuation<? super Clazz> $completion) {
        String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzCode = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, code);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Clazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Clazz call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Clazz _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Clazz clazz = _result2;
                    return clazz;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<Clazz>> findAllLive() {
        String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz"}, (Callable)new Callable<List<Clazz>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Clazz> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    ArrayList<Clazz> _result2 = new ArrayList<Clazz>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Clazz _item = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _item.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _item.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _item.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _item.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _item.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _item.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _item.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _item.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _item.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _item.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _item.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _item.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        _result2.add(_item);
                    }
                    ArrayList<Clazz> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Clazz> findAll() {
        String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
            int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
            int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
            int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
            int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
            int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
            int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
            int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
            int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
            int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
            int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
            int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
            int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
            int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
            int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
            int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
            int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
            int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
            int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
            int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
            int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
            int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
            int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
            int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
            int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
            ArrayList<Clazz> _result2 = new ArrayList<Clazz>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Clazz _item = new Clazz();
                long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                _item.setClazzUid(_tmpClazzUid);
                String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                _item.setClazzName(_tmpClazzName);
                String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                _item.setClazzDesc(_tmpClazzDesc);
                float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                _item.setAttendanceAverage(_tmpAttendanceAverage);
                long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                boolean _tmpIsClazzActive = _tmp != 0;
                _item.setClazzActive(_tmpIsClazzActive);
                long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                _item.setClazzLocationUid(_tmpClazzLocationUid);
                long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                _item.setClazzStartTime(_tmpClazzStartTime);
                long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                _item.setClazzEndTime(_tmpClazzEndTime);
                long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                _item.setClazzFeatures(_tmpClazzFeatures);
                long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                _item.setClazzSchoolUid(_tmpClazzSchoolUid);
                int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                _item.setClazzLct(_tmpClazzLct);
                String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                _item.setClazzTimeZone(_tmpClazzTimeZone);
                long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                _item.setClazzCode(_tmpClazzCode);
                long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                _result2.add(_item);
            }
            ArrayList<Clazz> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidAsync(long clazzUid, Continuation<? super Clazz> $completion) {
        String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Clazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Clazz call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Clazz _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Clazz clazz = _result2;
                    return clazz;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object clazzUidExistsAsync(long clazzUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT Clazz.clazzUid\n                 FROM Clazz\n                WHERE Clazz.clazzUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT Clazz.clazzUid\n                 FROM Clazz\n                WHERE Clazz.clazzUid = ?)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Clazz> findByUidAsFlow(long uid) {
        String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz"}, (Callable)new Callable<Clazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Clazz call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Clazz _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    } else {
                        _result2 = null;
                    }
                    Clazz clazz = _result2;
                    return clazz;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByUidWithHolidayCalendarAsync(long uid, Continuation<? super ClazzWithHolidayCalendarAndAndTerminology> $completion) {
        String _sql = "\n        SELECT Clazz.*, \n               CoursePicture.*,\n               HolidayCalendar.*, \n               CourseTerminology.*\n          FROM Clazz \n               LEFT JOIN HolidayCalendar \n                         ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n                      \n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = ?\n         WHERE Clazz.clazzUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.*, \n               CoursePicture.*,\n               HolidayCalendar.*, \n               CourseTerminology.*\n          FROM Clazz \n               LEFT JOIN HolidayCalendar \n                         ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n                      \n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = ?\n         WHERE Clazz.clazzUid = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzWithHolidayCalendarAndAndTerminology>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzWithHolidayCalendarAndAndTerminology call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzWithHolidayCalendarAndAndTerminology _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUid");
                    int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureLct");
                    int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUri");
                    int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureThumbnailUri");
                    int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureActive");
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
                    int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
                    int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
                    int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
                    int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
                    int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
                    int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
                    int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctUid");
                    int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTitle");
                    int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTerminology");
                    int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctLct");
                    if (_cursor.moveToFirst()) {
                        CourseTerminology _tmpTerminology;
                        HolidayCalendar _tmpHolidayCalendar;
                        CoursePicture _tmpCoursePicture;
                        if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
                            long _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
                            long _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
                            String _tmpCoursePictureUri = _cursor.isNull(_cursorIndexOfCoursePictureUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureUri);
                            String _tmpCoursePictureThumbnailUri = _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
                            int _tmp = _cursor.getInt(_cursorIndexOfCoursePictureActive);
                            boolean _tmpCoursePictureActive = _tmp != 0;
                            _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid, _tmpCoursePictureLct, _tmpCoursePictureUri, _tmpCoursePictureThumbnailUri, _tmpCoursePictureActive);
                        } else {
                            _tmpCoursePicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
                            _tmpHolidayCalendar = new HolidayCalendar();
                            long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                            _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
                            String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                            _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
                            int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                            _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                            boolean _tmpUmCalendarActive = _tmp_1 != 0;
                            _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
                            long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                            _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                            long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                            _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                            int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                            _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                            long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                            _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
                        } else {
                            _tmpHolidayCalendar = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
                            _tmpTerminology = new CourseTerminology();
                            long _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
                            _tmpTerminology.setCtUid(_tmpCtUid);
                            String _tmpCtTitle = _cursor.isNull(_cursorIndexOfCtTitle) ? null : _cursor.getString(_cursorIndexOfCtTitle);
                            _tmpTerminology.setCtTitle(_tmpCtTitle);
                            String _tmpCtTerminology = _cursor.isNull(_cursorIndexOfCtTerminology) ? null : _cursor.getString(_cursorIndexOfCtTerminology);
                            _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                            long _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
                            _tmpTerminology.setCtLct(_tmpCtLct);
                        } else {
                            _tmpTerminology = null;
                        }
                        _result2 = new ClazzWithHolidayCalendarAndAndTerminology();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _result2.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _result2.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _result2.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _result2.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _result2.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _result2.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp_2 != 0;
                        _result2.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _result2.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _result2.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _result2.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _result2.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _result2.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _result2.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _result2.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _result2.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _result2.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _result2.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _result2.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _result2.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _result2.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _result2.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _result2.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _result2.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _result2.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _result2.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        _result2.setCoursePicture(_tmpCoursePicture);
                        _result2.setHolidayCalendar(_tmpHolidayCalendar);
                        _result2.setTerminology(_tmpTerminology);
                    } else {
                        _result2 = null;
                    }
                    ClazzWithHolidayCalendarAndAndTerminology clazzWithHolidayCalendarAndAndTerminology = _result2;
                    return clazzWithHolidayCalendarAndAndTerminology;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, ClazzWithListDisplayDetails> findClazzesWithPermission(String searchQuery, long accountPersonUid, List<Long> excludeSelectedClazzList, int sortOrder, int filter, long currentTime, long permission) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT Clazz.*, ClazzEnrolment.*, CoursePicture.*,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  FROM ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   AND clazzEnrolmentRole = 1000 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  FROM ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   AND clazzEnrolmentRole = 1001");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               '' AS teacherNames,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               0 AS lastRecorded,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CourseTerminology.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM Clazz");
        _stringBuilder.append("\n");
        _stringBuilder.append("               LEFT JOIN ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ON ClazzEnrolment.clazzEnrolmentUid =");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       COALESCE(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       (SELECT ClazzEnrolment.clazzEnrolmentUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          FROM ClazzEnrolment");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentActive");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         LIMIT 1), 0)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                LEFT JOIN CourseTerminology   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                LEFT JOIN CoursePicture");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          ON CoursePicture.coursePictureUid = Clazz.clazzUid           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE /* Begin permission check clause */");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    Clazz.clazzOwnerPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 OR EXISTS(SELECT CoursePermission.cpUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                             FROM CoursePermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              AND (   CoursePermission.cpToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              AND (CoursePermission.cpPermissionsFlag & ");
        _stringBuilder.append("?");
        _stringBuilder.append(") > 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              AND NOT CoursePermission.cpIsDeleted)   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 OR (");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        EXISTS(SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM SystemPermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("          ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
        _stringBuilder.append("\n");
        _stringBuilder.append("      ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )             ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                /* End permission check clause */ ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND CAST(Clazz.isClazzActive AS INTEGER) = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND Clazz.clazzName like ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (Clazz.clazzUid NOT IN (");
        int _inputSize = excludeSelectedClazzList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND ( ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 OR (CASE WHEN ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 5 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      THEN ");
        _stringBuilder.append("?");
        _stringBuilder.append(" BETWEEN Clazz.clazzStartTime AND Clazz.clazzEndTime");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      ELSE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" > Clazz.clazzEndTime ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      END))");
        _stringBuilder.append("\n");
        _stringBuilder.append("      GROUP BY Clazz.clazzUid, ClazzEnrolment.clazzEnrolmentUid, CourseTerminology.ctUid, CoursePicture.coursePictureUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("      ORDER BY CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 3 THEN Clazz.attendanceAverage");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END ASC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 1 THEN Clazz.clazzName");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END ASC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 4 THEN Clazz.attendanceAverage");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END DESC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 2 THEN clazz.Clazzname");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 19 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 2;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 11;
        _statement.bindString(_argIndex, searchQuery);
        _argIndex = 12;
        for (long _item : excludeSelectedClazzList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 12 + _inputSize;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 13 + _inputSize;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 14 + _inputSize;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 15 + _inputSize;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 16 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 18 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 19 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<ClazzWithListDisplayDetails>(_statement, this.__db, new String[]{"ClazzEnrolment", "Clazz", "CourseTerminology", "CoursePicture", "CoursePermission", "SystemPermission"}){

            @NonNull
            protected List<ClazzWithListDisplayDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzUid");
                int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzName");
                int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzDesc");
                int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"attendanceAverage");
                int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzHolidayUMCalendarUid");
                int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzScheuleUMCalendarUid");
                int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isClazzActive");
                int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLocationUid");
                int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzStartTime");
                int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEndTime");
                int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzFeatures");
                int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzSchoolUid");
                int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentPolicy");
                int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzTerminologyUid");
                int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzMasterChangeSeqNum");
                int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLocalChangeSeqNum");
                int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLastChangedBy");
                int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLct");
                int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzTimeZone");
                int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzStudentsPersonGroupUid");
                int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzTeachersPersonGroupUid");
                int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzPendingStudentsPersonGroupUid");
                int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzParentsPersonGroupUid");
                int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzCode");
                int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzOwnerPersonUid");
                int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentUid");
                int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentPersonUid");
                int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentClazzUid");
                int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentDateJoined");
                int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentDateLeft");
                int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentRole");
                int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentAttendancePercentage");
                int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentActive");
                int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentLeavingReasonUid");
                int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentOutcome");
                int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentLastChangedBy");
                int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentLct");
                int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzEnrolmentInviteUid");
                int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"coursePictureUid");
                int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"coursePictureLct");
                int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"coursePictureUri");
                int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"coursePictureThumbnailUri");
                int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"coursePictureActive");
                int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"numStudents");
                int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"numTeachers");
                int _cursorIndexOfTeacherNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"teacherNames");
                int _cursorIndexOfLastRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastRecorded");
                int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ctUid");
                int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ctTitle");
                int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ctTerminology");
                int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ctLct");
                ArrayList<ClazzWithListDisplayDetails> _result2 = new ArrayList<ClazzWithListDisplayDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    CourseTerminology _tmpTerminology;
                    CoursePicture _tmpCoursePicture;
                    ClazzEnrolment _tmpClazzActiveEnrolment;
                    if (!(cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
                        _tmpClazzActiveEnrolment = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _tmpClazzActiveEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _tmpClazzActiveEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                    } else {
                        _tmpClazzActiveEnrolment = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCoursePictureUid) && cursor.isNull(_cursorIndexOfCoursePictureLct) && cursor.isNull(_cursorIndexOfCoursePictureUri) && cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && cursor.isNull(_cursorIndexOfCoursePictureActive))) {
                        long _tmpCoursePictureUid = cursor.getLong(_cursorIndexOfCoursePictureUid);
                        long _tmpCoursePictureLct = cursor.getLong(_cursorIndexOfCoursePictureLct);
                        String _tmpCoursePictureUri = cursor.isNull(_cursorIndexOfCoursePictureUri) ? null : cursor.getString(_cursorIndexOfCoursePictureUri);
                        String _tmpCoursePictureThumbnailUri = cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfCoursePictureActive);
                        boolean _tmpCoursePictureActive = _tmp_1 != 0;
                        _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid, _tmpCoursePictureLct, _tmpCoursePictureUri, _tmpCoursePictureThumbnailUri, _tmpCoursePictureActive);
                    } else {
                        _tmpCoursePicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCtUid) && cursor.isNull(_cursorIndexOfCtTitle) && cursor.isNull(_cursorIndexOfCtTerminology) && cursor.isNull(_cursorIndexOfCtLct))) {
                        _tmpTerminology = new CourseTerminology();
                        long _tmpCtUid = cursor.getLong(_cursorIndexOfCtUid);
                        _tmpTerminology.setCtUid(_tmpCtUid);
                        String _tmpCtTitle = cursor.isNull(_cursorIndexOfCtTitle) ? null : cursor.getString(_cursorIndexOfCtTitle);
                        _tmpTerminology.setCtTitle(_tmpCtTitle);
                        String _tmpCtTerminology = cursor.isNull(_cursorIndexOfCtTerminology) ? null : cursor.getString(_cursorIndexOfCtTerminology);
                        _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                        long _tmpCtLct = cursor.getLong(_cursorIndexOfCtLct);
                        _tmpTerminology.setCtLct(_tmpCtLct);
                    } else {
                        _tmpTerminology = null;
                    }
                    ClazzWithListDisplayDetails _item_1 = new ClazzWithListDisplayDetails();
                    long _tmpClazzUid = cursor.getLong(_cursorIndexOfClazzUid);
                    _item_1.setClazzUid(_tmpClazzUid);
                    String _tmpClazzName = cursor.isNull(_cursorIndexOfClazzName) ? null : cursor.getString(_cursorIndexOfClazzName);
                    _item_1.setClazzName(_tmpClazzName);
                    String _tmpClazzDesc = cursor.isNull(_cursorIndexOfClazzDesc) ? null : cursor.getString(_cursorIndexOfClazzDesc);
                    _item_1.setClazzDesc(_tmpClazzDesc);
                    float _tmpAttendanceAverage = cursor.getFloat(_cursorIndexOfAttendanceAverage);
                    _item_1.setAttendanceAverage(_tmpAttendanceAverage);
                    long _tmpClazzHolidayUMCalendarUid = cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                    _item_1.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                    long _tmpClazzScheuleUMCalendarUid = cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                    _item_1.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfIsClazzActive);
                    boolean _tmpIsClazzActive = _tmp_2 != 0;
                    _item_1.setClazzActive(_tmpIsClazzActive);
                    long _tmpClazzLocationUid = cursor.getLong(_cursorIndexOfClazzLocationUid);
                    _item_1.setClazzLocationUid(_tmpClazzLocationUid);
                    long _tmpClazzStartTime = cursor.getLong(_cursorIndexOfClazzStartTime);
                    _item_1.setClazzStartTime(_tmpClazzStartTime);
                    long _tmpClazzEndTime = cursor.getLong(_cursorIndexOfClazzEndTime);
                    _item_1.setClazzEndTime(_tmpClazzEndTime);
                    long _tmpClazzFeatures = cursor.getLong(_cursorIndexOfClazzFeatures);
                    _item_1.setClazzFeatures(_tmpClazzFeatures);
                    long _tmpClazzSchoolUid = cursor.getLong(_cursorIndexOfClazzSchoolUid);
                    _item_1.setClazzSchoolUid(_tmpClazzSchoolUid);
                    int _tmpClazzEnrolmentPolicy = cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                    _item_1.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                    long _tmpClazzTerminologyUid = cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                    _item_1.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                    long _tmpClazzMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                    _item_1.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                    long _tmpClazzLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                    _item_1.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                    int _tmpClazzLastChangedBy = cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                    _item_1.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                    long _tmpClazzLct = cursor.getLong(_cursorIndexOfClazzLct);
                    _item_1.setClazzLct(_tmpClazzLct);
                    String _tmpClazzTimeZone = cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : cursor.getString(_cursorIndexOfClazzTimeZone);
                    _item_1.setClazzTimeZone(_tmpClazzTimeZone);
                    long _tmpClazzStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                    _item_1.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                    long _tmpClazzTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                    _item_1.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                    long _tmpClazzPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                    _item_1.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                    long _tmpClazzParentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                    _item_1.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                    String _tmpClazzCode = cursor.isNull(_cursorIndexOfClazzCode) ? null : cursor.getString(_cursorIndexOfClazzCode);
                    _item_1.setClazzCode(_tmpClazzCode);
                    long _tmpClazzOwnerPersonUid = cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                    _item_1.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                    int _tmpNumStudents = cursor.getInt(_cursorIndexOfNumStudents);
                    _item_1.setNumStudents(_tmpNumStudents);
                    int _tmpNumTeachers = cursor.getInt(_cursorIndexOfNumTeachers);
                    _item_1.setNumTeachers(_tmpNumTeachers);
                    String _tmpTeacherNames = cursor.isNull(_cursorIndexOfTeacherNames) ? null : cursor.getString(_cursorIndexOfTeacherNames);
                    _item_1.setTeacherNames(_tmpTeacherNames);
                    long _tmpLastRecorded = cursor.getLong(_cursorIndexOfLastRecorded);
                    _item_1.setLastRecorded(_tmpLastRecorded);
                    _item_1.setClazzActiveEnrolment(_tmpClazzActiveEnrolment);
                    _item_1.setCoursePicture(_tmpCoursePicture);
                    _item_1.setTerminology(_tmpTerminology);
                    _result2.add(_item_1);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object getClassNamesFromListOfIds(List<Long> ids, Continuation<? super List<UidAndLabel>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT Clazz.clazzUid AS uid, Clazz.clazzName AS labelName From Clazz WHERE clazzUid IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : ids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UidAndLabel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<UidAndLabel> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfUid = false;
                    boolean _cursorIndexOfLabelName = true;
                    ArrayList<UidAndLabel> _result2 = new ArrayList<UidAndLabel>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        UidAndLabel _item_1 = new UidAndLabel();
                        long _tmpUid = _cursor.getLong(0);
                        _item_1.setUid(_tmpUid);
                        String _tmpLabelName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        _item_1.setLabelName(_tmpLabelName);
                        _result2.add(_item_1);
                    }
                    ArrayList<UidAndLabel> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Clazz> findByClazzName(String name) {
        String _sql = "SELECT * FROM Clazz WHERE clazzName = ? and CAST(isClazzActive AS INTEGER) = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Clazz WHERE clazzName = ? and CAST(isClazzActive AS INTEGER) = 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
            int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
            int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
            int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
            int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
            int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
            int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
            int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
            int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
            int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
            int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
            int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
            int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
            int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
            int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
            int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
            int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
            int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
            int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
            int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
            int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
            int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
            int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
            int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
            int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
            ArrayList<Clazz> _result2 = new ArrayList<Clazz>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Clazz _item = new Clazz();
                long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                _item.setClazzUid(_tmpClazzUid);
                String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                _item.setClazzName(_tmpClazzName);
                String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                _item.setClazzDesc(_tmpClazzDesc);
                float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                _item.setAttendanceAverage(_tmpAttendanceAverage);
                long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                boolean _tmpIsClazzActive = _tmp != 0;
                _item.setClazzActive(_tmpIsClazzActive);
                long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                _item.setClazzLocationUid(_tmpClazzLocationUid);
                long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                _item.setClazzStartTime(_tmpClazzStartTime);
                long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                _item.setClazzEndTime(_tmpClazzEndTime);
                long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                _item.setClazzFeatures(_tmpClazzFeatures);
                long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                _item.setClazzSchoolUid(_tmpClazzSchoolUid);
                int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                _item.setClazzLct(_tmpClazzLct);
                String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                _item.setClazzTimeZone(_tmpClazzTimeZone);
                long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                _item.setClazzCode(_tmpClazzCode);
                long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                _result2.add(_item);
            }
            ArrayList<Clazz> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<ClazzAndDetailPermissions> clazzAndDetailPermissionsAsFlow(long accountPersonUid, long clazzUid) {
        String _sql = "\n        SELECT Clazz.*,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  32\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  32\n                  \n        ) > 0)\n               )\n    \n               ) AS hasAttendancePermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  8192\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  8192\n                  \n        ) > 0)\n               )\n    \n               ) AS hasViewMembersPermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  128\n                  \n        ) > 0)\n               )\n    \n               ) AS hasLearningRecordPermission\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?\n           AND (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  1\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  1\n                  \n        ) > 0)\n               )\n    \n               )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.*,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  32\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  32\n                  \n        ) > 0)\n               )\n    \n               ) AS hasAttendancePermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  8192\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  8192\n                  \n        ) > 0)\n               )\n    \n               ) AS hasViewMembersPermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  128\n                  \n        ) > 0)\n               )\n    \n               ) AS hasLearningRecordPermission\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?\n           AND (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  1\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  1\n                  \n        ) > 0)\n               )\n    \n               )\n    ", (int)25);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 24;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 25;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission"}, (Callable)new Callable<ClazzAndDetailPermissions>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAndDetailPermissions call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzAndDetailPermissions _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    int _cursorIndexOfHasAttendancePermission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasAttendancePermission");
                    int _cursorIndexOfHasViewMembersPermission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasViewMembersPermission");
                    int _cursorIndexOfHasLearningRecordPermission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasLearningRecordPermission");
                    if (_cursor.moveToFirst()) {
                        Clazz _tmpClazz;
                        boolean _tmpHasLearningRecordPermission;
                        int _tmp = _cursor.getInt(_cursorIndexOfHasAttendancePermission);
                        boolean _tmpHasAttendancePermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfHasViewMembersPermission);
                        boolean _tmpHasViewMembersPermission = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfHasLearningRecordPermission);
                        boolean bl = _tmpHasLearningRecordPermission = _tmp_2 != 0;
                        if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
                            _tmpClazz = new Clazz();
                            long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                            _tmpClazz.setClazzUid(_tmpClazzUid);
                            String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                            _tmpClazz.setClazzName(_tmpClazzName);
                            String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                            _tmpClazz.setClazzDesc(_tmpClazzDesc);
                            float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                            _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                            long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                            _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                            long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                            _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfIsClazzActive);
                            boolean _tmpIsClazzActive = _tmp_3 != 0;
                            _tmpClazz.setClazzActive(_tmpIsClazzActive);
                            long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                            _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                            long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                            _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                            long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                            _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                            long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                            _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                            long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                            _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                            int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                            _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                            long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                            _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                            long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                            _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                            long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                            _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                            int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                            _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                            long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                            _tmpClazz.setClazzLct(_tmpClazzLct);
                            String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                            _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                            long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                            _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                            long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                            _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                            long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                            _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                            long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                            _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                            String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                            _tmpClazz.setClazzCode(_tmpClazzCode);
                            long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                            _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        } else {
                            _tmpClazz = null;
                        }
                        _result2 = new ClazzAndDetailPermissions(_tmpClazz, _tmpHasAttendancePermission, _tmpHasViewMembersPermission, _tmpHasLearningRecordPermission);
                    } else {
                        _result2 = null;
                    }
                    ClazzAndDetailPermissions clazzAndDetailPermissions = _result2;
                    return clazzAndDetailPermissions;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<ClazzAndDisplayDetails> getClazzWithDisplayDetails(long clazzUid, long currentTime, long accountPersonUid) {
        String _sql = "\n        SELECT Clazz.*, \n               CoursePicture.*,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001 \n                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n                CourseTerminology.*,\n                (SELECT EXISTS(\n                        SELECT 1\n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentRole = 1000\n)\n                ) AS activeUserIsStudent\n         FROM Clazz \n              LEFT JOIN CourseTerminology\n                        ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = ?\n        WHERE Clazz.clazzUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.*, \n               CoursePicture.*,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001 \n                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n                CourseTerminology.*,\n                (SELECT EXISTS(\n                        SELECT 1\n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentRole = 1000\n)\n                ) AS activeUserIsStudent\n         FROM Clazz \n              LEFT JOIN CourseTerminology\n                        ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = ?\n        WHERE Clazz.clazzUid = ?", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 2;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "Clazz", "CourseTerminology", "CoursePicture"}, (Callable)new Callable<ClazzAndDisplayDetails>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAndDisplayDetails call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzAndDisplayDetails _result2;
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUid");
                    int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureLct");
                    int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUri");
                    int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureThumbnailUri");
                    int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureActive");
                    int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"numStudents");
                    int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"numTeachers");
                    int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctUid");
                    int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTitle");
                    int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTerminology");
                    int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctLct");
                    int _cursorIndexOfActiveUserIsStudent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activeUserIsStudent");
                    if (_cursor.moveToFirst()) {
                        CourseTerminology _tmpTerminology;
                        CoursePicture _tmpCoursePicture;
                        Clazz _tmpClazz;
                        boolean _tmpActiveUserIsStudent;
                        int _tmpNumStudents = _cursor.getInt(_cursorIndexOfNumStudents);
                        int _tmpNumTeachers = _cursor.getInt(_cursorIndexOfNumTeachers);
                        int _tmp = _cursor.getInt(_cursorIndexOfActiveUserIsStudent);
                        boolean bl = _tmpActiveUserIsStudent = _tmp != 0;
                        if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
                            _tmpClazz = new Clazz();
                            long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                            _tmpClazz.setClazzUid(_tmpClazzUid);
                            String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                            _tmpClazz.setClazzName(_tmpClazzName);
                            String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                            _tmpClazz.setClazzDesc(_tmpClazzDesc);
                            float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                            _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                            long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                            _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                            long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                            _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsClazzActive);
                            boolean _tmpIsClazzActive = _tmp_1 != 0;
                            _tmpClazz.setClazzActive(_tmpIsClazzActive);
                            long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                            _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                            long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                            _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                            long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                            _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                            long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                            _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                            long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                            _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                            int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                            _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                            long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                            _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                            long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                            _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                            long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                            _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                            int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                            _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                            long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                            _tmpClazz.setClazzLct(_tmpClazzLct);
                            String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                            _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                            long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                            _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                            long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                            _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                            long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                            _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                            long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                            _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                            String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                            _tmpClazz.setClazzCode(_tmpClazzCode);
                            long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                            _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        } else {
                            _tmpClazz = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
                            long _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
                            long _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
                            String _tmpCoursePictureUri = _cursor.isNull(_cursorIndexOfCoursePictureUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureUri);
                            String _tmpCoursePictureThumbnailUri = _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
                            boolean _tmpCoursePictureActive = _tmp_2 != 0;
                            _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid, _tmpCoursePictureLct, _tmpCoursePictureUri, _tmpCoursePictureThumbnailUri, _tmpCoursePictureActive);
                        } else {
                            _tmpCoursePicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
                            _tmpTerminology = new CourseTerminology();
                            long _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
                            _tmpTerminology.setCtUid(_tmpCtUid);
                            String _tmpCtTitle = _cursor.isNull(_cursorIndexOfCtTitle) ? null : _cursor.getString(_cursorIndexOfCtTitle);
                            _tmpTerminology.setCtTitle(_tmpCtTitle);
                            String _tmpCtTerminology = _cursor.isNull(_cursorIndexOfCtTerminology) ? null : _cursor.getString(_cursorIndexOfCtTerminology);
                            _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                            long _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
                            _tmpTerminology.setCtLct(_tmpCtLct);
                        } else {
                            _tmpTerminology = null;
                        }
                        _result2 = new ClazzAndDisplayDetails(_tmpClazz, _tmpTerminology, _tmpCoursePicture, _tmpNumStudents, _tmpNumTeachers, _tmpActiveUserIsStudent);
                    } else {
                        _result2 = null;
                    }
                    ClazzAndDisplayDetails clazzAndDisplayDetails = _result2;
                    return clazzAndDisplayDetails;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClazzWithHolidayCalendarAndAndTerminology> findClazzesWithEffectiveHolidayCalendarAndFilter(long filterUid) {
        String _sql = "\n        SELECT Clazz.*, \n               HolidayCalendar.*,\n               CourseTerminology.*,\n               CoursePicture.*\n         FROM Clazz \n              LEFT JOIN HolidayCalendar \n              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n                AND HolidayCalendar.umCalendarUid = 0) \n              LEFT JOIN CourseTerminology\n              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              \n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = 0\n                \n        WHERE ? = 0 \n           OR Clazz.clazzUid = ?\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.*, \n               HolidayCalendar.*,\n               CourseTerminology.*,\n               CoursePicture.*\n         FROM Clazz \n              LEFT JOIN HolidayCalendar \n              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n                AND HolidayCalendar.umCalendarUid = 0) \n              LEFT JOIN CourseTerminology\n              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              \n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = 0\n                \n        WHERE ? = 0 \n           OR Clazz.clazzUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, filterUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, filterUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
            int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
            int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
            int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
            int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
            int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
            int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
            int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
            int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
            int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
            int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
            int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
            int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
            int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
            int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
            int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
            int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
            int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
            int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
            int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
            int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
            int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
            int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
            int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
            int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
            int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
            int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
            int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
            int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
            int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
            int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
            int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
            int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
            int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctUid");
            int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTitle");
            int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTerminology");
            int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctLct");
            int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUid");
            int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureLct");
            int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUri");
            int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureThumbnailUri");
            int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureActive");
            ArrayList<ClazzWithHolidayCalendarAndAndTerminology> _result2 = new ArrayList<ClazzWithHolidayCalendarAndAndTerminology>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CoursePicture _tmpCoursePicture;
                CourseTerminology _tmpTerminology;
                HolidayCalendar _tmpHolidayCalendar;
                if (!(_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
                    _tmpHolidayCalendar = new HolidayCalendar();
                    long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                    _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
                    String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                    _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
                    int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                    _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
                    int _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                    boolean _tmpUmCalendarActive = _tmp != 0;
                    _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
                    long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                    _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                    long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                    _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                    int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                    _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                    long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                    _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
                } else {
                    _tmpHolidayCalendar = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
                    _tmpTerminology = new CourseTerminology();
                    long _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
                    _tmpTerminology.setCtUid(_tmpCtUid);
                    String _tmpCtTitle = _cursor.isNull(_cursorIndexOfCtTitle) ? null : _cursor.getString(_cursorIndexOfCtTitle);
                    _tmpTerminology.setCtTitle(_tmpCtTitle);
                    String _tmpCtTerminology = _cursor.isNull(_cursorIndexOfCtTerminology) ? null : _cursor.getString(_cursorIndexOfCtTerminology);
                    _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                    long _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
                    _tmpTerminology.setCtLct(_tmpCtLct);
                } else {
                    _tmpTerminology = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
                    long _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
                    long _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
                    String _tmpCoursePictureUri = _cursor.isNull(_cursorIndexOfCoursePictureUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureUri);
                    String _tmpCoursePictureThumbnailUri = _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
                    boolean _tmpCoursePictureActive = _tmp_1 != 0;
                    _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid, _tmpCoursePictureLct, _tmpCoursePictureUri, _tmpCoursePictureThumbnailUri, _tmpCoursePictureActive);
                } else {
                    _tmpCoursePicture = null;
                }
                ClazzWithHolidayCalendarAndAndTerminology _item = new ClazzWithHolidayCalendarAndAndTerminology();
                long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                _item.setClazzUid(_tmpClazzUid);
                String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                _item.setClazzName(_tmpClazzName);
                String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                _item.setClazzDesc(_tmpClazzDesc);
                float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                _item.setAttendanceAverage(_tmpAttendanceAverage);
                long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
                boolean _tmpIsClazzActive = _tmp_2 != 0;
                _item.setClazzActive(_tmpIsClazzActive);
                long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                _item.setClazzLocationUid(_tmpClazzLocationUid);
                long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                _item.setClazzStartTime(_tmpClazzStartTime);
                long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                _item.setClazzEndTime(_tmpClazzEndTime);
                long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                _item.setClazzFeatures(_tmpClazzFeatures);
                long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                _item.setClazzSchoolUid(_tmpClazzSchoolUid);
                int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                _item.setClazzLct(_tmpClazzLct);
                String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                _item.setClazzTimeZone(_tmpClazzTimeZone);
                long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                _item.setClazzCode(_tmpClazzCode);
                long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                _item.setHolidayCalendar(_tmpHolidayCalendar);
                _item.setTerminology(_tmpTerminology);
                _item.setCoursePicture(_tmpCoursePicture);
                _result2.add(_item);
            }
            ArrayList<ClazzWithHolidayCalendarAndAndTerminology> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<String> getTitleByUidAsFlow(long clazzUid) {
        String _sql = "\n        SELECT Clazz.clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz"}, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<ClazzNameAndTerminology> getClazzNameAndTerminologyAsFlow(long clazzUid) {
        String _sql = "\n        SELECT Clazz.clazzName AS clazzName,\n               CourseTerminology.*\n          FROM Clazz\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE Clazz.clazzUid = ?                \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.clazzName AS clazzName,\n               CourseTerminology.*\n          FROM Clazz\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE Clazz.clazzUid = ?                \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CourseTerminology"}, (Callable)new Callable<ClazzNameAndTerminology>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzNameAndTerminology call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzNameAndTerminology _result2;
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctUid");
                    int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTitle");
                    int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTerminology");
                    int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctLct");
                    if (_cursor.moveToFirst()) {
                        CourseTerminology _tmpTerminology;
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
                            _tmpTerminology = new CourseTerminology();
                            long _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
                            _tmpTerminology.setCtUid(_tmpCtUid);
                            String _tmpCtTitle = _cursor.isNull(_cursorIndexOfCtTitle) ? null : _cursor.getString(_cursorIndexOfCtTitle);
                            _tmpTerminology.setCtTitle(_tmpCtTitle);
                            String _tmpCtTerminology = _cursor.isNull(_cursorIndexOfCtTerminology) ? null : _cursor.getString(_cursorIndexOfCtTerminology);
                            _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                            long _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
                            _tmpTerminology.setCtLct(_tmpCtLct);
                        } else {
                            _tmpTerminology = null;
                        }
                        _result2 = new ClazzNameAndTerminology(_tmpClazzName, _tmpTerminology);
                    } else {
                        _result2 = null;
                    }
                    ClazzNameAndTerminology clazzNameAndTerminology = _result2;
                    return clazzNameAndTerminology;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<String> getClazzNameAsFlow(long clazzUid) {
        String _sql = "\n        SELECT Clazz.clazzName AS clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?                \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.clazzName AS clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = ?                \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz"}, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getClazzTimeZoneByClazzUidAsync(long clazzUid, Continuation<? super String> $completion) {
        String _sql = "\n        SELECT Clazz.clazzTimeZone\n          FROM Clazz\n         WHERE Clazz.clazzUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.clazzTimeZone\n          FROM Clazz\n         WHERE Clazz.clazzUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getCoursesByName(List<String> names, Continuation<? super List<? extends Clazz>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT Clazz.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM Clazz");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE Clazz.clazzName IN (");
        int _inputSize = names.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : names) {
            _statement.bindString(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Clazz>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Clazz> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    ArrayList<Clazz> _result2 = new ArrayList<Clazz>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Clazz _item_1 = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _item_1.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _item_1.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _item_1.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _item_1.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _item_1.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _item_1.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _item_1.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _item_1.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _item_1.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _item_1.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _item_1.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _item_1.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _item_1.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _item_1.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _item_1.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _item_1.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _item_1.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _item_1.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _item_1.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _item_1.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _item_1.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _item_1.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _item_1.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _item_1.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _item_1.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        _result2.add(_item_1);
                    }
                    ArrayList<Clazz> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findOneRosterUserClazzes(long accountPersonUid, long filterByEnrolledMemberPersonUid, Continuation<? super List<? extends Clazz>> $completion) {
        String _sql = "\n        SELECT Clazz.*\n          FROM CLAZZ\n               LEFT JOIN ClazzEnrolment \n                    ON ClazzEnrolment.clazzEnrolmentUid =\n                       COALESCE(\n                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentActive\n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                         LIMIT 1), 0)\n          WHERE (   Clazz.clazzOwnerPersonUid = ?\n                 OR EXISTS(SELECT CoursePermission.cpUid\n                             FROM CoursePermission\n                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid\n                              AND (   CoursePermission.cpToPersonUid = ? \n                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                              AND (CoursePermission.cpPermissionsFlag & 1) > 0 \n                              AND NOT CoursePermission.cpIsDeleted)   \n                 OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                     1\n                     \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    \n                    )             \n                )\n           AND EXISTS \n                (SELECT ClazzEnrolment.clazzEnrolmentUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n                )  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Clazz.*\n          FROM CLAZZ\n               LEFT JOIN ClazzEnrolment \n                    ON ClazzEnrolment.clazzEnrolmentUid =\n                       COALESCE(\n                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                           AND ClazzEnrolment.clazzEnrolmentActive\n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                         LIMIT 1), 0)\n          WHERE (   Clazz.clazzOwnerPersonUid = ?\n                 OR EXISTS(SELECT CoursePermission.cpUid\n                             FROM CoursePermission\n                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid\n                              AND (   CoursePermission.cpToPersonUid = ? \n                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                              AND (CoursePermission.cpPermissionsFlag & 1) > 0 \n                              AND NOT CoursePermission.cpIsDeleted)   \n                 OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                     1\n                     \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    \n                    )             \n                )\n           AND EXISTS \n                (SELECT ClazzEnrolment.clazzEnrolmentUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n                )  \n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, filterByEnrolledMemberPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Clazz>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Clazz> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    ArrayList<Clazz> _result2 = new ArrayList<Clazz>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Clazz _item = new Clazz();
                        long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                        _item.setClazzUid(_tmpClazzUid);
                        String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                        _item.setClazzName(_tmpClazzName);
                        String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                        _item.setClazzDesc(_tmpClazzDesc);
                        float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                        _item.setAttendanceAverage(_tmpAttendanceAverage);
                        long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                        long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                        boolean _tmpIsClazzActive = _tmp != 0;
                        _item.setClazzActive(_tmpIsClazzActive);
                        long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                        _item.setClazzLocationUid(_tmpClazzLocationUid);
                        long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                        _item.setClazzStartTime(_tmpClazzStartTime);
                        long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                        _item.setClazzEndTime(_tmpClazzEndTime);
                        long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                        _item.setClazzFeatures(_tmpClazzFeatures);
                        long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
                        int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                        long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                        long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                        long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                        int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                        long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                        _item.setClazzLct(_tmpClazzLct);
                        String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                        _item.setClazzTimeZone(_tmpClazzTimeZone);
                        long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                        long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                        long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                        long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                        String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                        _item.setClazzCode(_tmpClazzCode);
                        long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                        _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        _result2.add(_item);
                    }
                    ArrayList<Clazz> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findClazzNamesByUids(List<Long> uidList, Continuation<? super List<ClazzUidAndName>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT Clazz.clazzUid, Clazz.clazzName");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM Clazz");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE Clazz.clazzUid IN (");
        int _inputSize = uidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : uidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzUidAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzUidAndName> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfClazzUid = false;
                    boolean _cursorIndexOfClazzName = true;
                    ArrayList<ClazzUidAndName> _result2 = new ArrayList<ClazzUidAndName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpClazzUid = _cursor.getLong(0);
                        String _tmpClazzName = _cursor.getString(1);
                        ClazzUidAndName _item_1 = new ClazzUidAndName(_tmpClazzUid, _tmpClazzName);
                        _result2.add(_item_1);
                    }
                    ArrayList<ClazzUidAndName> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

