package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ReportQueryResult;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ReportQueryResultDao_Impl extends ReportQueryResultDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ReportQueryResult> __insertionAdapterOfReportQueryResult;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByReportUidAndTimeZone;

  public ReportQueryResultDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfReportQueryResult = new EntityInsertionAdapter<ReportQueryResult>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ReportQueryResult` (`rqrUid`,`rqrReportUid`,`rqrLastModified`,`rqrLastValidated`,`rqrReportSeriesUid`,`rqrXAxis`,`rqrYAxis`,`rqrSubgroup`,`rqrTimeZone`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ReportQueryResult entity) {
        statement.bindLong(1, entity.getRqrUid());
        statement.bindLong(2, entity.getRqrReportUid());
        statement.bindLong(3, entity.getRqrLastModified());
        statement.bindLong(4, entity.getRqrLastValidated());
        statement.bindLong(5, entity.getRqrReportSeriesUid());
        statement.bindString(6, entity.getRqrXAxis());
        statement.bindDouble(7, entity.getRqrYAxis());
        statement.bindString(8, entity.getRqrSubgroup());
        statement.bindString(9, entity.getRqrTimeZone());
      }
    };
    this.__preparedStmtOfDeleteByReportUidAndTimeZone = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        DELETE FROM ReportQueryResult\n"
                + "         WHERE rqrReportUid = ?\n"
                + "           AND rqrTimeZone = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAllAsync(final List<ReportQueryResult> results,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfReportQueryResult.insert(results);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteByReportUidAndTimeZone(final long reportUid, final String timeZone,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByReportUidAndTimeZone.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, reportUid);
        _argIndex = 2;
        _stmt.bindString(_argIndex, timeZone);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByReportUidAndTimeZone.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllByReportUidAndTimeZone(final long reportUid, final String timeZone,
      final Continuation<? super List<ReportQueryResult>> $completion) {
    final String _sql = "\n"
            + "        SELECT ReportQueryResult.*\n"
            + "          FROM ReportQueryResult\n"
            + "         WHERE ReportQueryResult.rqrReportUid = ? \n"
            + "           AND ReportQueryResult.rqrTimeZone = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, reportUid);
    _argIndex = 2;
    _statement.bindString(_argIndex, timeZone);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ReportQueryResult>>() {
      @Override
      @NonNull
      public List<ReportQueryResult> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfRqrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrUid");
          final int _cursorIndexOfRqrReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrReportUid");
          final int _cursorIndexOfRqrLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrLastModified");
          final int _cursorIndexOfRqrLastValidated = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrLastValidated");
          final int _cursorIndexOfRqrReportSeriesUid = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrReportSeriesUid");
          final int _cursorIndexOfRqrXAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrXAxis");
          final int _cursorIndexOfRqrYAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrYAxis");
          final int _cursorIndexOfRqrSubgroup = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrSubgroup");
          final int _cursorIndexOfRqrTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "rqrTimeZone");
          final List<ReportQueryResult> _result = new ArrayList<ReportQueryResult>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ReportQueryResult _item;
            final long _tmpRqrUid;
            _tmpRqrUid = _cursor.getLong(_cursorIndexOfRqrUid);
            final long _tmpRqrReportUid;
            _tmpRqrReportUid = _cursor.getLong(_cursorIndexOfRqrReportUid);
            final long _tmpRqrLastModified;
            _tmpRqrLastModified = _cursor.getLong(_cursorIndexOfRqrLastModified);
            final long _tmpRqrLastValidated;
            _tmpRqrLastValidated = _cursor.getLong(_cursorIndexOfRqrLastValidated);
            final int _tmpRqrReportSeriesUid;
            _tmpRqrReportSeriesUid = _cursor.getInt(_cursorIndexOfRqrReportSeriesUid);
            final String _tmpRqrXAxis;
            _tmpRqrXAxis = _cursor.getString(_cursorIndexOfRqrXAxis);
            final double _tmpRqrYAxis;
            _tmpRqrYAxis = _cursor.getDouble(_cursorIndexOfRqrYAxis);
            final String _tmpRqrSubgroup;
            _tmpRqrSubgroup = _cursor.getString(_cursorIndexOfRqrSubgroup);
            final String _tmpRqrTimeZone;
            _tmpRqrTimeZone = _cursor.getString(_cursorIndexOfRqrTimeZone);
            _item = new ReportQueryResult(_tmpRqrUid,_tmpRqrReportUid,_tmpRqrLastModified,_tmpRqrLastValidated,_tmpRqrReportSeriesUid,_tmpRqrXAxis,_tmpRqrYAxis,_tmpRqrSubgroup,_tmpRqrTimeZone);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object isReportFresh(final long reportUid, final String timeZone,
      final long freshThresholdTime, final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT ReportQueryResult.rqrLastModified\n"
            + "                  FROM ReportQueryResult\n"
            + "                 WHERE ReportQueryResult.rqrReportUid = ?\n"
            + "                   AND ReportQueryResult.rqrTimeZone = ?\n"
            + "                 LIMIT 1), 0) >= \n"
            + "               (SELECT MAX(?, \n"
            + "                            (SELECT COALESCE(\n"
            + "                                    (SELECT Report.reportLastModTime\n"
            + "                                       FROM Report\n"
            + "                                      WHERE Report.reportUid = ?), 0))))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, reportUid);
    _argIndex = 2;
    _statement.bindString(_argIndex, timeZone);
    _argIndex = 3;
    _statement.bindLong(_argIndex, freshThresholdTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, reportUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
