package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ActivityLangMapEntryDao_Impl extends ActivityLangMapEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ActivityLangMapEntry> __insertionAdapterOfActivityLangMapEntry;

  private final SharedSQLiteStatement __preparedStmtOfUpsertIfInteractionEntityExists;

  private final SharedSQLiteStatement __preparedStmtOfUpdateIfChanged;

  public ActivityLangMapEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfActivityLangMapEntry = new EntityInsertionAdapter<ActivityLangMapEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ActivityLangMapEntry` (`almeActivityUid`,`almeHash`,`almeLangCode`,`almePropName`,`almeValue`,`almeAieHash`,`almeLastMod`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActivityLangMapEntry entity) {
        statement.bindLong(1, entity.getAlmeActivityUid());
        statement.bindLong(2, entity.getAlmeHash());
        if (entity.getAlmeLangCode() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getAlmeLangCode());
        }
        if (entity.getAlmePropName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getAlmePropName());
        }
        if (entity.getAlmeValue() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAlmeValue());
        }
        statement.bindLong(6, entity.getAlmeAieHash());
        statement.bindLong(7, entity.getAlmeLastMod());
      }
    };
    this.__preparedStmtOfUpsertIfInteractionEntityExists = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        INSERT OR REPLACE \n"
                + "        INTO ActivityLangMapEntry(almeActivityUid, almeHash, almeLangCode, almePropName, almeValue, almeAieHash, almeLastMod)\n"
                + "        SELECT ? AS almeActivityUid,\n"
                + "               ? AS almeHash,\n"
                + "               ? AS almeLangCode,\n"
                + "               ? AS almePropName,\n"
                + "               ? AS almeValue,\n"
                + "               ? AS almeAieHash,\n"
                + "               ? AS almeLastMod\n"
                + "         WHERE EXISTS(SELECT 1\n"
                + "                        FROM ActivityInteractionEntity\n"
                + "                       WHERE ActivityInteractionEntity.aieActivityUid = ?\n"
                + "                         AND ActivityInteractionEntity.aieHash = ?)\n"
                + "          \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateIfChanged = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ActivityLangMapEntry\n"
                + "           SET almeValue = ?,\n"
                + "               almeLastMod = ?\n"
                + "         WHERE almeActivityUid = ?\n"
                + "           AND almeHash = ?\n"
                + "           AND almeValue != ?       \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object upsertList(final List<ActivityLangMapEntry> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActivityLangMapEntry.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertIfInteractionEntityExists(final long almeActivityUid, final long almeHash,
      final String almePropName, final String almeLangCode, final String almeValue,
      final long almeAieHash, final long almeLastMod,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpsertIfInteractionEntityExists.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, almeActivityUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, almeHash);
        _argIndex = 3;
        if (almeLangCode == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, almeLangCode);
        }
        _argIndex = 4;
        if (almePropName == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, almePropName);
        }
        _argIndex = 5;
        if (almeValue == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, almeValue);
        }
        _argIndex = 6;
        _stmt.bindLong(_argIndex, almeAieHash);
        _argIndex = 7;
        _stmt.bindLong(_argIndex, almeLastMod);
        _argIndex = 8;
        _stmt.bindLong(_argIndex, almeActivityUid);
        _argIndex = 9;
        _stmt.bindLong(_argIndex, almeAieHash);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeInsert();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpsertIfInteractionEntityExists.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateIfChanged(final long almeActivityUid, final long almeHash,
      final String almeValue, final long almeLastMod,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateIfChanged.acquire();
        int _argIndex = 1;
        if (almeValue == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, almeValue);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, almeLastMod);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, almeActivityUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, almeHash);
        _argIndex = 5;
        if (almeValue == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, almeValue);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateIfChanged.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByActivityUid(final long activityUid,
      final Continuation<? super List<ActivityLangMapEntry>> $completion) {
    final String _sql = "\n"
            + "        SELECT ActivityLangMapEntry.*\n"
            + "          FROM ActivityLangMapEntry\n"
            + "         WHERE ActivityLangMapEntry.almeActivityUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActivityLangMapEntry>>() {
      @Override
      @NonNull
      public List<ActivityLangMapEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAlmeActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "almeActivityUid");
          final int _cursorIndexOfAlmeHash = CursorUtil.getColumnIndexOrThrow(_cursor, "almeHash");
          final int _cursorIndexOfAlmeLangCode = CursorUtil.getColumnIndexOrThrow(_cursor, "almeLangCode");
          final int _cursorIndexOfAlmePropName = CursorUtil.getColumnIndexOrThrow(_cursor, "almePropName");
          final int _cursorIndexOfAlmeValue = CursorUtil.getColumnIndexOrThrow(_cursor, "almeValue");
          final int _cursorIndexOfAlmeAieHash = CursorUtil.getColumnIndexOrThrow(_cursor, "almeAieHash");
          final int _cursorIndexOfAlmeLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "almeLastMod");
          final List<ActivityLangMapEntry> _result = new ArrayList<ActivityLangMapEntry>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActivityLangMapEntry _item;
            final long _tmpAlmeActivityUid;
            _tmpAlmeActivityUid = _cursor.getLong(_cursorIndexOfAlmeActivityUid);
            final long _tmpAlmeHash;
            _tmpAlmeHash = _cursor.getLong(_cursorIndexOfAlmeHash);
            final String _tmpAlmeLangCode;
            if (_cursor.isNull(_cursorIndexOfAlmeLangCode)) {
              _tmpAlmeLangCode = null;
            } else {
              _tmpAlmeLangCode = _cursor.getString(_cursorIndexOfAlmeLangCode);
            }
            final String _tmpAlmePropName;
            if (_cursor.isNull(_cursorIndexOfAlmePropName)) {
              _tmpAlmePropName = null;
            } else {
              _tmpAlmePropName = _cursor.getString(_cursorIndexOfAlmePropName);
            }
            final String _tmpAlmeValue;
            if (_cursor.isNull(_cursorIndexOfAlmeValue)) {
              _tmpAlmeValue = null;
            } else {
              _tmpAlmeValue = _cursor.getString(_cursorIndexOfAlmeValue);
            }
            final long _tmpAlmeAieHash;
            _tmpAlmeAieHash = _cursor.getLong(_cursorIndexOfAlmeAieHash);
            final long _tmpAlmeLastMod;
            _tmpAlmeLastMod = _cursor.getLong(_cursorIndexOfAlmeLastMod);
            _item = new ActivityLangMapEntry(_tmpAlmeActivityUid,_tmpAlmeHash,_tmpAlmeLangCode,_tmpAlmePropName,_tmpAlmeValue,_tmpAlmeAieHash,_tmpAlmeLastMod);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
