package com.ustadmobile.core.db.dao

import com.ustadmobile.lib.db.entities.PersonAuth2
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public actual abstract class PersonAuth2Dao {
  public actual abstract suspend fun insertListAsync(auths: List<PersonAuth2>)

  public actual abstract suspend fun insertAsync(auth: PersonAuth2): Long

  public actual abstract suspend fun findByPersonUid(personUid: Long): PersonAuth2?

  public actual abstract fun findByPersonUidFlow(personUid: Long): Flow<PersonAuth2?>

  public actual abstract suspend fun findByUsername(username: String): PersonAuth2?

  public actual abstract fun findByUsernames(username: String): Flow<PersonAuth2?>
}
