package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz;
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzInvite;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzInviteDao_Impl extends ClazzInviteDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite;

  private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite_1;

  private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite_2;

  private final EntityDeletionOrUpdateAdapter<ClazzInvite> __updateAdapterOfClazzInvite;

  private final EntityDeletionOrUpdateAdapter<ClazzInvite> __updateAdapterOfClazzInvite_1;

  private final SharedSQLiteStatement __preparedStmtOfUpdateInviteStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzInviteToRevokeInvite;

  public ClazzInviteDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzInvite = new EntityInsertionAdapter<ClazzInvite>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzInvite entity) {
        statement.bindLong(1, entity.getCiUid());
        statement.bindLong(2, entity.getCiPersonUid());
        statement.bindLong(3, entity.getCiRoleId());
        statement.bindLong(4, entity.getCiClazzUid());
        statement.bindLong(5, entity.getInviteType());
        statement.bindString(6, entity.getInviteContact());
        statement.bindString(7, entity.getInviteToken());
        statement.bindLong(8, entity.getInviteStatus());
        statement.bindLong(9, entity.getInviteExpire());
        statement.bindLong(10, entity.getInviteLct());
      }
    };
    this.__insertionAdapterOfClazzInvite_1 = new EntityInsertionAdapter<ClazzInvite>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzInvite entity) {
        statement.bindLong(1, entity.getCiUid());
        statement.bindLong(2, entity.getCiPersonUid());
        statement.bindLong(3, entity.getCiRoleId());
        statement.bindLong(4, entity.getCiClazzUid());
        statement.bindLong(5, entity.getInviteType());
        statement.bindString(6, entity.getInviteContact());
        statement.bindString(7, entity.getInviteToken());
        statement.bindLong(8, entity.getInviteStatus());
        statement.bindLong(9, entity.getInviteExpire());
        statement.bindLong(10, entity.getInviteLct());
      }
    };
    this.__insertionAdapterOfClazzInvite_2 = new EntityInsertionAdapter<ClazzInvite>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzInvite entity) {
        statement.bindLong(1, entity.getCiUid());
        statement.bindLong(2, entity.getCiPersonUid());
        statement.bindLong(3, entity.getCiRoleId());
        statement.bindLong(4, entity.getCiClazzUid());
        statement.bindLong(5, entity.getInviteType());
        statement.bindString(6, entity.getInviteContact());
        statement.bindString(7, entity.getInviteToken());
        statement.bindLong(8, entity.getInviteStatus());
        statement.bindLong(9, entity.getInviteExpire());
        statement.bindLong(10, entity.getInviteLct());
      }
    };
    this.__updateAdapterOfClazzInvite = new EntityDeletionOrUpdateAdapter<ClazzInvite>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ClazzInvite` SET `ciUid` = ?,`ciPersonUid` = ?,`ciRoleId` = ?,`ciClazzUid` = ?,`inviteType` = ?,`inviteContact` = ?,`inviteToken` = ?,`inviteStatus` = ?,`inviteExpire` = ?,`inviteLct` = ? WHERE `ciUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzInvite entity) {
        statement.bindLong(1, entity.getCiUid());
        statement.bindLong(2, entity.getCiPersonUid());
        statement.bindLong(3, entity.getCiRoleId());
        statement.bindLong(4, entity.getCiClazzUid());
        statement.bindLong(5, entity.getInviteType());
        statement.bindString(6, entity.getInviteContact());
        statement.bindString(7, entity.getInviteToken());
        statement.bindLong(8, entity.getInviteStatus());
        statement.bindLong(9, entity.getInviteExpire());
        statement.bindLong(10, entity.getInviteLct());
        statement.bindLong(11, entity.getCiUid());
      }
    };
    this.__updateAdapterOfClazzInvite_1 = new EntityDeletionOrUpdateAdapter<ClazzInvite>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR IGNORE `ClazzInvite` SET `ciUid` = ?,`ciPersonUid` = ?,`ciRoleId` = ?,`ciClazzUid` = ?,`inviteType` = ?,`inviteContact` = ?,`inviteToken` = ?,`inviteStatus` = ?,`inviteExpire` = ?,`inviteLct` = ? WHERE `ciUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzInvite entity) {
        statement.bindLong(1, entity.getCiUid());
        statement.bindLong(2, entity.getCiPersonUid());
        statement.bindLong(3, entity.getCiRoleId());
        statement.bindLong(4, entity.getCiClazzUid());
        statement.bindLong(5, entity.getInviteType());
        statement.bindString(6, entity.getInviteContact());
        statement.bindString(7, entity.getInviteToken());
        statement.bindLong(8, entity.getInviteStatus());
        statement.bindLong(9, entity.getInviteExpire());
        statement.bindLong(10, entity.getInviteLct());
        statement.bindLong(11, entity.getCiUid());
      }
    };
    this.__preparedStmtOfUpdateInviteStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzInvite \n"
                + "           SET inviteStatus = ?,\n"
                + "               inviteLct = ?\n"
                + "         WHERE ClazzInvite.ciUid =?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzInviteToRevokeInvite = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzInvite \n"
                + "          SET inviteStatus = 3\n"
                + "        WHERE inviteContact = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzInvite entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzInvite.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzInvite entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzInvite.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ClazzInvite> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzInvite.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replace(final ClazzInvite entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzInvite_1.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertAll(final List<ClazzInvite> entity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzInvite_2.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final ClazzInvite entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzInvite.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAll(final List<ClazzInvite> entity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzInvite_1.handleMultiple(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateInviteStatus(final int status, final long ciUid, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateInviteStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, ciUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateInviteStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateClazzInviteToRevokeInvite(final String inviteContact,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzInviteToRevokeInvite.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, inviteContact);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateClazzInviteToRevokeInvite.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findInviteAsync(final Continuation<? super List<ClazzInvite>> $completion) {
    final String _sql = "SELECT * FROM ClazzInvite";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzInvite>>() {
      @Override
      @NonNull
      public List<ClazzInvite> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciUid");
          final int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciPersonUid");
          final int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow(_cursor, "ciRoleId");
          final int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciClazzUid");
          final int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteType");
          final int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteContact");
          final int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteToken");
          final int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteStatus");
          final int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteExpire");
          final int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteLct");
          final List<ClazzInvite> _result = new ArrayList<ClazzInvite>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzInvite _item;
            final long _tmpCiUid;
            _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
            final long _tmpCiPersonUid;
            _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
            final long _tmpCiRoleId;
            _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
            final long _tmpCiClazzUid;
            _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
            final int _tmpInviteType;
            _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
            final String _tmpInviteContact;
            _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
            final String _tmpInviteToken;
            _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
            final int _tmpInviteStatus;
            _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
            final long _tmpInviteExpire;
            _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
            final long _tmpInviteLct;
            _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
            _item = new ClazzInvite(_tmpCiUid,_tmpCiPersonUid,_tmpCiRoleId,_tmpCiClazzUid,_tmpInviteType,_tmpInviteContact,_tmpInviteToken,_tmpInviteStatus,_tmpInviteExpire,_tmpInviteLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findClazzInviteEntityForInviteToken(final String inviteTokenUid,
      final Continuation<? super ClazzInviteWithTimeZone> $completion) {
    final String _sql = "\n"
            + "    SELECT ClazzInvite.*, \n"
            + "           COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n"
            + "      FROM ClazzInvite\n"
            + "           LEFT JOIN Clazz \n"
            + "                     ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n"
            + "     WHERE ClazzInvite.inviteToken = ?\n";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, inviteTokenUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzInviteWithTimeZone>() {
      @Override
      @Nullable
      public ClazzInviteWithTimeZone call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciUid");
          final int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciPersonUid");
          final int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow(_cursor, "ciRoleId");
          final int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciClazzUid");
          final int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteType");
          final int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteContact");
          final int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteToken");
          final int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteStatus");
          final int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteExpire");
          final int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteLct");
          final int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "timeZone");
          final ClazzInviteWithTimeZone _result;
          if (_cursor.moveToFirst()) {
            final String _tmpTimeZone;
            if (_cursor.isNull(_cursorIndexOfTimeZone)) {
              _tmpTimeZone = null;
            } else {
              _tmpTimeZone = _cursor.getString(_cursorIndexOfTimeZone);
            }
            final ClazzInvite _tmpClazzInvite;
            if (!(_cursor.isNull(_cursorIndexOfCiUid) && _cursor.isNull(_cursorIndexOfCiPersonUid) && _cursor.isNull(_cursorIndexOfCiRoleId) && _cursor.isNull(_cursorIndexOfCiClazzUid) && _cursor.isNull(_cursorIndexOfInviteType) && _cursor.isNull(_cursorIndexOfInviteContact) && _cursor.isNull(_cursorIndexOfInviteToken) && _cursor.isNull(_cursorIndexOfInviteStatus) && _cursor.isNull(_cursorIndexOfInviteExpire) && _cursor.isNull(_cursorIndexOfInviteLct))) {
              final long _tmpCiUid;
              _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
              final long _tmpCiPersonUid;
              _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
              final long _tmpCiRoleId;
              _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
              final long _tmpCiClazzUid;
              _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
              final int _tmpInviteType;
              _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
              final String _tmpInviteContact;
              _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
              final String _tmpInviteToken;
              _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
              final int _tmpInviteStatus;
              _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
              final long _tmpInviteExpire;
              _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
              final long _tmpInviteLct;
              _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
              _tmpClazzInvite = new ClazzInvite(_tmpCiUid,_tmpCiPersonUid,_tmpCiRoleId,_tmpCiClazzUid,_tmpInviteType,_tmpInviteContact,_tmpInviteToken,_tmpInviteStatus,_tmpInviteExpire,_tmpInviteLct);
            } else {
              _tmpClazzInvite = null;
            }
            _result = new ClazzInviteWithTimeZone(_tmpClazzInvite,_tmpTimeZone);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ClazzInviteAndClazz> findClazzInviteEntityForInviteTokenAsFlow(
      final String inviteTokenUid) {
    final String _sql = "\n"
            + "    SELECT ClazzInvite.*, Clazz.*\n"
            + "      FROM ClazzInvite\n"
            + "           JOIN Clazz \n"
            + "                ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n"
            + "     WHERE ClazzInvite.inviteToken = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, inviteTokenUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzInvite",
        "Clazz"}, new Callable<ClazzInviteAndClazz>() {
      @Override
      @Nullable
      public ClazzInviteAndClazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciUid");
          final int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciPersonUid");
          final int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow(_cursor, "ciRoleId");
          final int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciClazzUid");
          final int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteType");
          final int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteContact");
          final int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteToken");
          final int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteStatus");
          final int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteExpire");
          final int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteLct");
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final ClazzInviteAndClazz _result;
          if (_cursor.moveToFirst()) {
            final ClazzInvite _tmpClazzInvite;
            if (!(_cursor.isNull(_cursorIndexOfCiUid) && _cursor.isNull(_cursorIndexOfCiPersonUid) && _cursor.isNull(_cursorIndexOfCiRoleId) && _cursor.isNull(_cursorIndexOfCiClazzUid) && _cursor.isNull(_cursorIndexOfInviteType) && _cursor.isNull(_cursorIndexOfInviteContact) && _cursor.isNull(_cursorIndexOfInviteToken) && _cursor.isNull(_cursorIndexOfInviteStatus) && _cursor.isNull(_cursorIndexOfInviteExpire) && _cursor.isNull(_cursorIndexOfInviteLct))) {
              final long _tmpCiUid;
              _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
              final long _tmpCiPersonUid;
              _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
              final long _tmpCiRoleId;
              _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
              final long _tmpCiClazzUid;
              _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
              final int _tmpInviteType;
              _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
              final String _tmpInviteContact;
              _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
              final String _tmpInviteToken;
              _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
              final int _tmpInviteStatus;
              _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
              final long _tmpInviteExpire;
              _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
              final long _tmpInviteLct;
              _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
              _tmpClazzInvite = new ClazzInvite(_tmpCiUid,_tmpCiPersonUid,_tmpCiRoleId,_tmpCiClazzUid,_tmpInviteType,_tmpInviteContact,_tmpInviteToken,_tmpInviteStatus,_tmpInviteExpire,_tmpInviteLct);
            } else {
              _tmpClazzInvite = null;
            }
            final Clazz _tmpClazz;
            if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
              final long _tmpClazzOwnerPersonUid;
              _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
              _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
              _tmpClazz = null;
            }
            _result = new ClazzInviteAndClazz(_tmpClazzInvite,_tmpClazz);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, ClazzInvite> findPendingInviteByPersonUid(final long ciPersonUid,
      final long clazzUid, final long currentTime) {
    final String _sql = "SELECT * FROM ClazzInvite \n"
            + "                 WHERE ciPersonUid = ? AND ciClazzUid = ? \n"
            + "              AND inviteExpire > ? AND inviteStatus = 0";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, ciPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, currentTime);
    return new LimitOffsetPagingSource<ClazzInvite>(_statement, __db, "ClazzInvite") {
      @Override
      @NonNull
      protected List<ClazzInvite> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow(cursor, "ciUid");
        final int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "ciPersonUid");
        final int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow(cursor, "ciRoleId");
        final int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "ciClazzUid");
        final int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow(cursor, "inviteType");
        final int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow(cursor, "inviteContact");
        final int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow(cursor, "inviteToken");
        final int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow(cursor, "inviteStatus");
        final int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow(cursor, "inviteExpire");
        final int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow(cursor, "inviteLct");
        final List<ClazzInvite> _result = new ArrayList<ClazzInvite>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ClazzInvite _item;
          final long _tmpCiUid;
          _tmpCiUid = cursor.getLong(_cursorIndexOfCiUid);
          final long _tmpCiPersonUid;
          _tmpCiPersonUid = cursor.getLong(_cursorIndexOfCiPersonUid);
          final long _tmpCiRoleId;
          _tmpCiRoleId = cursor.getLong(_cursorIndexOfCiRoleId);
          final long _tmpCiClazzUid;
          _tmpCiClazzUid = cursor.getLong(_cursorIndexOfCiClazzUid);
          final int _tmpInviteType;
          _tmpInviteType = cursor.getInt(_cursorIndexOfInviteType);
          final String _tmpInviteContact;
          _tmpInviteContact = cursor.getString(_cursorIndexOfInviteContact);
          final String _tmpInviteToken;
          _tmpInviteToken = cursor.getString(_cursorIndexOfInviteToken);
          final int _tmpInviteStatus;
          _tmpInviteStatus = cursor.getInt(_cursorIndexOfInviteStatus);
          final long _tmpInviteExpire;
          _tmpInviteExpire = cursor.getLong(_cursorIndexOfInviteExpire);
          final long _tmpInviteLct;
          _tmpInviteLct = cursor.getLong(_cursorIndexOfInviteLct);
          _item = new ClazzInvite(_tmpCiUid,_tmpCiPersonUid,_tmpCiRoleId,_tmpCiClazzUid,_tmpInviteType,_tmpInviteContact,_tmpInviteToken,_tmpInviteStatus,_tmpInviteExpire,_tmpInviteLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findClazzInviteFromContact(final String inviteContact,
      final Continuation<? super ClazzInvite> $completion) {
    final String _sql = "SELECT * FROM ClazzInvite WHERE inviteContact = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, inviteContact);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzInvite>() {
      @Override
      @Nullable
      public ClazzInvite call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciUid");
          final int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciPersonUid");
          final int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow(_cursor, "ciRoleId");
          final int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ciClazzUid");
          final int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteType");
          final int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteContact");
          final int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteToken");
          final int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteStatus");
          final int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteExpire");
          final int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "inviteLct");
          final ClazzInvite _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCiUid;
            _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
            final long _tmpCiPersonUid;
            _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
            final long _tmpCiRoleId;
            _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
            final long _tmpCiClazzUid;
            _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
            final int _tmpInviteType;
            _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
            final String _tmpInviteContact;
            _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
            final String _tmpInviteToken;
            _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
            final int _tmpInviteStatus;
            _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
            final long _tmpInviteExpire;
            _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
            final long _tmpInviteLct;
            _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
            _result = new ClazzInvite(_tmpCiUid,_tmpCiPersonUid,_tmpCiRoleId,_tmpCiClazzUid,_tmpInviteType,_tmpInviteContact,_tmpInviteToken,_tmpInviteStatus,_tmpInviteExpire,_tmpInviteLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
