package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ContentEntryContentCategoryJoinDao :
    BaseDao<ContentEntryContentCategoryJoin> {
  @Query(`value` =
      "SELECT ContentEntryContentCategoryJoin.* FROM ContentEntryContentCategoryJoin LEFT JOIN ContentEntry ON ContentEntryContentCategoryJoin.ceccjContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik")
  public actual abstract fun publicContentEntryContentCategoryJoins():
      List<ContentEntryContentCategoryJoin>

  @Query(`value` =
      "SELECT * from ContentEntryContentCategoryJoin WHERE ceccjContentCategoryUid = :categoryUid AND ceccjContentEntryUid = :contentEntry")
  public actual abstract fun findJoinByParentChildUuids(categoryUid: Long, contentEntry: Long):
      ContentEntryContentCategoryJoin?
}
