package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class PeerReviewerAllocationDao : BaseDao<PeerReviewerAllocation> {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun replaceListAsync(entries: List<PeerReviewerAllocation>)

  @Query(`value` =
      "\n        SELECT *\n         FROM PeerReviewerAllocation\n        WHERE praAssignmentUid IN (:assignmentUid)\n          AND praActive \n    ")
  public actual abstract suspend fun getAllPeerReviewerAllocations(assignmentUid: List<Long>):
      List<PeerReviewerAllocation>

  @Query(`value` =
      "\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid IN\n               (SELECT CourseBlock.cbEntityUid\n                  FROM CourseBlock\n                 WHERE CourseBlock.cbClazzUid = :clazzUid\n                   AND CourseBlock.cbType = 103\n                   AND (CAST(:includeInactive AS INTEGER) = 1 OR CourseBlock.cbActive))\n           AND (CAST(:includeInactive AS INTEGER) = 1 OR PeerReviewerAllocation.praActive)\n    ")
  public actual abstract suspend fun getAllPeerReviewerAllocationsByClazzUid(clazzUid: Long,
      includeInactive: Boolean): List<PeerReviewerAllocation>

  @Query(`value` =
      "\n        UPDATE PeerReviewerAllocation \n           SET praActive = :active, \n               praLct = :changeTime\n         WHERE praUid = :cbUid")
  public actual abstract suspend fun updateActiveByUid(
    cbUid: Long,
    active: Boolean,
    changeTime: Long,
  )

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertList(entityList: List<PeerReviewerAllocation>)
}
