package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.lib.db.entities.PersonPasskey
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public actual abstract class PersonPasskeyDao {
  public actual abstract suspend fun insertAsync(personPasskey: PersonPasskey): Long

  public actual abstract suspend fun allPasskey(): List<String>

  public actual abstract fun getAllActivePasskeys(uid: Long): Flow<List<PersonPasskey>>

  public actual abstract fun getAllActivePasskeysPaging(uid: Long): PagingSource<Int, PersonPasskey>

  public actual abstract suspend fun findPersonPasskeyFromClientDataJson(id: String): PersonPasskey?

  public actual abstract suspend fun revokePersonPasskey(uid: Long)
}
