package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.ClazzAssignmentDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<ClazzAssignmentDao>) {
  `get`("getAssignmentSubmitterSummaryListForAssignment") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getAssignmentSubmitterSummaryListForAssignment_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getSubmitterUidsAndNameByClazzOrGroupSetUid") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getSubmitterUidsAndNameByClazzOrGroupSetUid_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getSubmitterUid") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getSubmitterUid_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidAsync_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidAndClazzUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidAndClazzUidAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidWithBlockAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidWithBlockAsync_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findAssignmentCourseBlockAndSubmitterUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findAssignmentCourseBlockAndSubmitterUidAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
