package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.ClazzLogDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<ClazzLogDao>) {
  `get`("findByClazzUidAsFactory") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByClazzUidAsFactory_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByClazzUidAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByClazzUidAsync_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findAllForClazzByClazzLogUid") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findAllForClazzByClazzLogUid_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
