package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.ext.doorNodeIdHeader
import com.ustadmobile.door.ext.setRepoUrl
import com.ustadmobile.door.http.replicateHttpRequestCatchAndLog
import com.ustadmobile.door.replication.onClientRepoDoorMessageHttpResponse
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry
import io.ktor.client.HttpClient
import io.ktor.client.request.`get`
import io.ktor.client.request.`header`
import io.ktor.client.request.parameter
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.builtins.serializer

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class ActivityLangMapEntryDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: ActivityLangMapEntryDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : ActivityLangMapEntryDao() {
  override suspend fun upsertList(entities: List<ActivityLangMapEntry>) {
    _repo.withRepoChangeMonitorAsync("ActivityLangMapEntry") {
      _dao.upsertList(entities)
    }
  }

  override suspend fun upsertIfInteractionEntityExists(
    almeActivityUid: Long,
    almeHash: Long,
    almePropName: String?,
    almeLangCode: String?,
    almeValue: String?,
    almeAieHash: Long,
    almeLastMod: Long,
  ) {
    _repo.withRepoChangeMonitorAsync("ActivityLangMapEntry") {
      _dao.upsertIfInteractionEntityExists(almeActivityUid, almeHash, almePropName, almeLangCode,
          almeValue, almeAieHash, almeLastMod)
    }
  }

  override suspend fun updateIfChanged(
    almeActivityUid: Long,
    almeHash: Long,
    almeValue: String?,
    almeLastMod: Long,
  ) {
    _repo.withRepoChangeMonitorAsync("ActivityLangMapEntry") {
      _dao.updateIfChanged(almeActivityUid, almeHash, almeValue, almeLastMod)
    }
  }

  override suspend fun findAllByActivityUid(activityUid: Long): List<ActivityLangMapEntry> {
    _repo.replicateHttpRequestCatchAndLog(repoPath =
        "ActivityLangMapEntryDao/findAllByActivityUid") {
      val _response = _httpClient.`get` {
        setRepoUrl(_repo.config, "ActivityLangMapEntryDao/findAllByActivityUid")
        doorNodeIdHeader(_repo)
        `header`("cache-control", "no-store")
        parameter("activityUid", _repo.config.json.encodeToString(Long.serializer(), activityUid))
      }

      _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
    }
    val _result = _dao.findAllByActivityUid(activityUid)
    return _result
  }
}
