package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Language;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LanguageDao_Impl extends LanguageDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Language> __insertionAdapterOfLanguage;

  private final EntityInsertionAdapter<Language> __insertionAdapterOfLanguage_1;

  private final EntityDeletionOrUpdateAdapter<Language> __updateAdapterOfLanguage;

  public LanguageDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLanguage = new EntityInsertionAdapter<Language>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Language` (`langUid`,`name`,`iso_639_1_standard`,`iso_639_2_standard`,`iso_639_3_standard`,`Language_Type`,`languageActive`,`langLocalChangeSeqNum`,`langMasterChangeSeqNum`,`langLastChangedBy`,`langLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Language entity) {
        statement.bindLong(1, entity.getLangUid());
        if (entity.getName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getName());
        }
        if (entity.getIso_639_1_standard() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getIso_639_1_standard());
        }
        if (entity.getIso_639_2_standard() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getIso_639_2_standard());
        }
        if (entity.getIso_639_3_standard() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getIso_639_3_standard());
        }
        if (entity.getLanguage_Type() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLanguage_Type());
        }
        final int _tmp = entity.getLanguageActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getLangLocalChangeSeqNum());
        statement.bindLong(9, entity.getLangMasterChangeSeqNum());
        statement.bindLong(10, entity.getLangLastChangedBy());
        statement.bindLong(11, entity.getLangLct());
      }
    };
    this.__insertionAdapterOfLanguage_1 = new EntityInsertionAdapter<Language>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Language` (`langUid`,`name`,`iso_639_1_standard`,`iso_639_2_standard`,`iso_639_3_standard`,`Language_Type`,`languageActive`,`langLocalChangeSeqNum`,`langMasterChangeSeqNum`,`langLastChangedBy`,`langLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Language entity) {
        statement.bindLong(1, entity.getLangUid());
        if (entity.getName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getName());
        }
        if (entity.getIso_639_1_standard() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getIso_639_1_standard());
        }
        if (entity.getIso_639_2_standard() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getIso_639_2_standard());
        }
        if (entity.getIso_639_3_standard() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getIso_639_3_standard());
        }
        if (entity.getLanguage_Type() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLanguage_Type());
        }
        final int _tmp = entity.getLanguageActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getLangLocalChangeSeqNum());
        statement.bindLong(9, entity.getLangMasterChangeSeqNum());
        statement.bindLong(10, entity.getLangLastChangedBy());
        statement.bindLong(11, entity.getLangLct());
      }
    };
    this.__updateAdapterOfLanguage = new EntityDeletionOrUpdateAdapter<Language>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Language` SET `langUid` = ?,`name` = ?,`iso_639_1_standard` = ?,`iso_639_2_standard` = ?,`iso_639_3_standard` = ?,`Language_Type` = ?,`languageActive` = ?,`langLocalChangeSeqNum` = ?,`langMasterChangeSeqNum` = ?,`langLastChangedBy` = ?,`langLct` = ? WHERE `langUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Language entity) {
        statement.bindLong(1, entity.getLangUid());
        if (entity.getName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getName());
        }
        if (entity.getIso_639_1_standard() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getIso_639_1_standard());
        }
        if (entity.getIso_639_2_standard() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getIso_639_2_standard());
        }
        if (entity.getIso_639_3_standard() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getIso_639_3_standard());
        }
        if (entity.getLanguage_Type() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLanguage_Type());
        }
        final int _tmp = entity.getLanguageActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getLangLocalChangeSeqNum());
        statement.bindLong(9, entity.getLangMasterChangeSeqNum());
        statement.bindLong(10, entity.getLangLastChangedBy());
        statement.bindLong(11, entity.getLangLct());
        statement.bindLong(12, entity.getLangUid());
      }
    };
  }

  @Override
  public long insert(final Language entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfLanguage.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Language entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfLanguage.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Language> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLanguage.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<Language> languageList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLanguage.insert(languageList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void replaceList(final List<Language> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLanguage_1.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Language entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLanguage.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Language entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfLanguage.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, Language> findLanguagesAsSource(final int sortOrder,
      final String searchText) {
    final String _sql = "\n"
            + "        SELECT Language.* \n"
            + "        FROM Language\n"
            + "        WHERE name LIKE ?\n"
            + "        ORDER BY CASE(?)\n"
            + "            WHEN 1 THEN Language.name \n"
            + "            WHEN 3 THEN Language.iso_639_1_standard \n"
            + "            WHEN 5 THEN Language.iso_639_2_standard \n"
            + "            ELSE ''\n"
            + "        END ASC,\n"
            + "        CASE(?)\n"
            + "            WHEN 2 THEN Language.name \n"
            + "            WHEN 4 THEN Language.iso_639_1_standard \n"
            + "            WHEN 6 THEN Language.iso_639_2_standard \n"
            + "            ELSE ''\n"
            + "        END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 2;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 3;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<Language>(_statement, __db, "Language") {
      @Override
      @NonNull
      protected List<Language> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(cursor, "langUid");
        final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(cursor, "name");
        final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_1_standard");
        final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_2_standard");
        final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_3_standard");
        final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(cursor, "Language_Type");
        final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(cursor, "languageActive");
        final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langLocalChangeSeqNum");
        final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langMasterChangeSeqNum");
        final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "langLastChangedBy");
        final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(cursor, "langLct");
        final List<Language> _result = new ArrayList<Language>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Language _item;
          _item = new Language();
          final long _tmpLangUid;
          _tmpLangUid = cursor.getLong(_cursorIndexOfLangUid);
          _item.setLangUid(_tmpLangUid);
          final String _tmpName;
          if (cursor.isNull(_cursorIndexOfName)) {
            _tmpName = null;
          } else {
            _tmpName = cursor.getString(_cursorIndexOfName);
          }
          _item.setName(_tmpName);
          final String _tmpIso_639_1_standard;
          if (cursor.isNull(_cursorIndexOfIso6391Standard)) {
            _tmpIso_639_1_standard = null;
          } else {
            _tmpIso_639_1_standard = cursor.getString(_cursorIndexOfIso6391Standard);
          }
          _item.setIso_639_1_standard(_tmpIso_639_1_standard);
          final String _tmpIso_639_2_standard;
          if (cursor.isNull(_cursorIndexOfIso6392Standard)) {
            _tmpIso_639_2_standard = null;
          } else {
            _tmpIso_639_2_standard = cursor.getString(_cursorIndexOfIso6392Standard);
          }
          _item.setIso_639_2_standard(_tmpIso_639_2_standard);
          final String _tmpIso_639_3_standard;
          if (cursor.isNull(_cursorIndexOfIso6393Standard)) {
            _tmpIso_639_3_standard = null;
          } else {
            _tmpIso_639_3_standard = cursor.getString(_cursorIndexOfIso6393Standard);
          }
          _item.setIso_639_3_standard(_tmpIso_639_3_standard);
          final String _tmpLanguage_Type;
          if (cursor.isNull(_cursorIndexOfLanguageType)) {
            _tmpLanguage_Type = null;
          } else {
            _tmpLanguage_Type = cursor.getString(_cursorIndexOfLanguageType);
          }
          _item.setLanguage_Type(_tmpLanguage_Type);
          final boolean _tmpLanguageActive;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfLanguageActive);
          _tmpLanguageActive = _tmp != 0;
          _item.setLanguageActive(_tmpLanguageActive);
          final long _tmpLangLocalChangeSeqNum;
          _tmpLangLocalChangeSeqNum = cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
          _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
          final long _tmpLangMasterChangeSeqNum;
          _tmpLangMasterChangeSeqNum = cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
          _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
          final int _tmpLangLastChangedBy;
          _tmpLangLastChangedBy = cursor.getInt(_cursorIndexOfLangLastChangedBy);
          _item.setLangLastChangedBy(_tmpLangLastChangedBy);
          final long _tmpLangLct;
          _tmpLangLct = cursor.getLong(_cursorIndexOfLangLct);
          _item.setLangLct(_tmpLangLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<Language> findLanguagesList() {
    final String _sql = "SELECT * FROM Language";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
      final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
      final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
      final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
      final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
      final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
      final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
      final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
      final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
      final List<Language> _result = new ArrayList<Language>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Language _item;
        _item = new Language();
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _item.setLangUid(_tmpLangUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _item.setName(_tmpName);
        final String _tmpIso_639_1_standard;
        if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
          _tmpIso_639_1_standard = null;
        } else {
          _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
        }
        _item.setIso_639_1_standard(_tmpIso_639_1_standard);
        final String _tmpIso_639_2_standard;
        if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
          _tmpIso_639_2_standard = null;
        } else {
          _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
        }
        _item.setIso_639_2_standard(_tmpIso_639_2_standard);
        final String _tmpIso_639_3_standard;
        if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
          _tmpIso_639_3_standard = null;
        } else {
          _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
        }
        _item.setIso_639_3_standard(_tmpIso_639_3_standard);
        final String _tmpLanguage_Type;
        if (_cursor.isNull(_cursorIndexOfLanguageType)) {
          _tmpLanguage_Type = null;
        } else {
          _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
        }
        _item.setLanguage_Type(_tmpLanguage_Type);
        final boolean _tmpLanguageActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
        _tmpLanguageActive = _tmp != 0;
        _item.setLanguageActive(_tmpLanguageActive);
        final long _tmpLangLocalChangeSeqNum;
        _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
        _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
        final long _tmpLangMasterChangeSeqNum;
        _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
        _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
        final int _tmpLangLastChangedBy;
        _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
        _item.setLangLastChangedBy(_tmpLangLastChangedBy);
        final long _tmpLangLct;
        _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
        _item.setLangLct(_tmpLangLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Language findByName(final String name) {
    final String _sql = "SELECT * FROM Language WHERE name = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, name);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
      final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
      final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
      final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
      final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
      final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
      final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
      final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
      final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
      final Language _result;
      if (_cursor.moveToFirst()) {
        _result = new Language();
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final String _tmpIso_639_1_standard;
        if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
          _tmpIso_639_1_standard = null;
        } else {
          _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
        }
        _result.setIso_639_1_standard(_tmpIso_639_1_standard);
        final String _tmpIso_639_2_standard;
        if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
          _tmpIso_639_2_standard = null;
        } else {
          _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
        }
        _result.setIso_639_2_standard(_tmpIso_639_2_standard);
        final String _tmpIso_639_3_standard;
        if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
          _tmpIso_639_3_standard = null;
        } else {
          _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
        }
        _result.setIso_639_3_standard(_tmpIso_639_3_standard);
        final String _tmpLanguage_Type;
        if (_cursor.isNull(_cursorIndexOfLanguageType)) {
          _tmpLanguage_Type = null;
        } else {
          _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
        }
        _result.setLanguage_Type(_tmpLanguage_Type);
        final boolean _tmpLanguageActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
        _tmpLanguageActive = _tmp != 0;
        _result.setLanguageActive(_tmpLanguageActive);
        final long _tmpLangLocalChangeSeqNum;
        _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
        _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
        final long _tmpLangMasterChangeSeqNum;
        _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
        _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
        final int _tmpLangLastChangedBy;
        _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
        _result.setLangLastChangedBy(_tmpLangLastChangedBy);
        final long _tmpLangLct;
        _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
        _result.setLangLct(_tmpLangLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Language findByTwoCode(final String langCode) {
    final String _sql = "SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, langCode);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
      final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
      final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
      final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
      final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
      final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
      final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
      final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
      final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
      final Language _result;
      if (_cursor.moveToFirst()) {
        _result = new Language();
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final String _tmpIso_639_1_standard;
        if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
          _tmpIso_639_1_standard = null;
        } else {
          _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
        }
        _result.setIso_639_1_standard(_tmpIso_639_1_standard);
        final String _tmpIso_639_2_standard;
        if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
          _tmpIso_639_2_standard = null;
        } else {
          _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
        }
        _result.setIso_639_2_standard(_tmpIso_639_2_standard);
        final String _tmpIso_639_3_standard;
        if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
          _tmpIso_639_3_standard = null;
        } else {
          _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
        }
        _result.setIso_639_3_standard(_tmpIso_639_3_standard);
        final String _tmpLanguage_Type;
        if (_cursor.isNull(_cursorIndexOfLanguageType)) {
          _tmpLanguage_Type = null;
        } else {
          _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
        }
        _result.setLanguage_Type(_tmpLanguage_Type);
        final boolean _tmpLanguageActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
        _tmpLanguageActive = _tmp != 0;
        _result.setLanguageActive(_tmpLanguageActive);
        final long _tmpLangLocalChangeSeqNum;
        _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
        _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
        final long _tmpLangMasterChangeSeqNum;
        _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
        _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
        final int _tmpLangLastChangedBy;
        _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
        _result.setLangLastChangedBy(_tmpLangLastChangedBy);
        final long _tmpLangLct;
        _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
        _result.setLangLct(_tmpLangLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByTwoCodeAsync(final String langCode,
      final Continuation<? super Language> $completion) {
    final String _sql = "SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, langCode);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Language>() {
      @Override
      @Nullable
      public Language call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final Language _result;
          if (_cursor.moveToFirst()) {
            _result = new Language();
            final long _tmpLangUid;
            _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
            _result.setLangUid(_tmpLangUid);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _result.setName(_tmpName);
            final String _tmpIso_639_1_standard;
            if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
              _tmpIso_639_1_standard = null;
            } else {
              _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
            }
            _result.setIso_639_1_standard(_tmpIso_639_1_standard);
            final String _tmpIso_639_2_standard;
            if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
              _tmpIso_639_2_standard = null;
            } else {
              _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
            }
            _result.setIso_639_2_standard(_tmpIso_639_2_standard);
            final String _tmpIso_639_3_standard;
            if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
              _tmpIso_639_3_standard = null;
            } else {
              _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
            }
            _result.setIso_639_3_standard(_tmpIso_639_3_standard);
            final String _tmpLanguage_Type;
            if (_cursor.isNull(_cursorIndexOfLanguageType)) {
              _tmpLanguage_Type = null;
            } else {
              _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
            }
            _result.setLanguage_Type(_tmpLanguage_Type);
            final boolean _tmpLanguageActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
            _tmpLanguageActive = _tmp != 0;
            _result.setLanguageActive(_tmpLanguageActive);
            final long _tmpLangLocalChangeSeqNum;
            _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
            _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
            final long _tmpLangMasterChangeSeqNum;
            _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
            _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
            final int _tmpLangLastChangedBy;
            _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
            _result.setLangLastChangedBy(_tmpLangLastChangedBy);
            final long _tmpLangLct;
            _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
            _result.setLangLct(_tmpLangLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Language findByThreeCode(final String langCode) {
    final String _sql = "SELECT * FROM LANGUAGE WHERE iso_639_3_standard = ? OR iso_639_2_standard = ? LIMIT 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindString(_argIndex, langCode);
    _argIndex = 2;
    _statement.bindString(_argIndex, langCode);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
      final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
      final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
      final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
      final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
      final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
      final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
      final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
      final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
      final Language _result;
      if (_cursor.moveToFirst()) {
        _result = new Language();
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final String _tmpIso_639_1_standard;
        if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
          _tmpIso_639_1_standard = null;
        } else {
          _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
        }
        _result.setIso_639_1_standard(_tmpIso_639_1_standard);
        final String _tmpIso_639_2_standard;
        if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
          _tmpIso_639_2_standard = null;
        } else {
          _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
        }
        _result.setIso_639_2_standard(_tmpIso_639_2_standard);
        final String _tmpIso_639_3_standard;
        if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
          _tmpIso_639_3_standard = null;
        } else {
          _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
        }
        _result.setIso_639_3_standard(_tmpIso_639_3_standard);
        final String _tmpLanguage_Type;
        if (_cursor.isNull(_cursorIndexOfLanguageType)) {
          _tmpLanguage_Type = null;
        } else {
          _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
        }
        _result.setLanguage_Type(_tmpLanguage_Type);
        final boolean _tmpLanguageActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
        _tmpLanguageActive = _tmp != 0;
        _result.setLanguageActive(_tmpLanguageActive);
        final long _tmpLangLocalChangeSeqNum;
        _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
        _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
        final long _tmpLangMasterChangeSeqNum;
        _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
        _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
        final int _tmpLangLastChangedBy;
        _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
        _result.setLangLastChangedBy(_tmpLangLastChangedBy);
        final long _tmpLangLct;
        _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
        _result.setLangLct(_tmpLangLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public int totalLanguageCount() {
    final String _sql = "SELECT COUNT(*) FROM LANGUAGE";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _result;
      if (_cursor.moveToFirst()) {
        _result = _cursor.getInt(0);
      } else {
        _result = 0;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Language findByUid(final long primaryLanguageUid) {
    final String _sql = "SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, primaryLanguageUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
      final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
      final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
      final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
      final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
      final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
      final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
      final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
      final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
      final Language _result;
      if (_cursor.moveToFirst()) {
        _result = new Language();
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final String _tmpIso_639_1_standard;
        if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
          _tmpIso_639_1_standard = null;
        } else {
          _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
        }
        _result.setIso_639_1_standard(_tmpIso_639_1_standard);
        final String _tmpIso_639_2_standard;
        if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
          _tmpIso_639_2_standard = null;
        } else {
          _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
        }
        _result.setIso_639_2_standard(_tmpIso_639_2_standard);
        final String _tmpIso_639_3_standard;
        if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
          _tmpIso_639_3_standard = null;
        } else {
          _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
        }
        _result.setIso_639_3_standard(_tmpIso_639_3_standard);
        final String _tmpLanguage_Type;
        if (_cursor.isNull(_cursorIndexOfLanguageType)) {
          _tmpLanguage_Type = null;
        } else {
          _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
        }
        _result.setLanguage_Type(_tmpLanguage_Type);
        final boolean _tmpLanguageActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
        _tmpLanguageActive = _tmp != 0;
        _result.setLanguageActive(_tmpLanguageActive);
        final long _tmpLangLocalChangeSeqNum;
        _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
        _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
        final long _tmpLangMasterChangeSeqNum;
        _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
        _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
        final int _tmpLangLastChangedBy;
        _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
        _result.setLangLastChangedBy(_tmpLangLastChangedBy);
        final long _tmpLangLct;
        _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
        _result.setLangLct(_tmpLangLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long primaryLanguageUid,
      final Continuation<? super Language> $completion) {
    final String _sql = "SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, primaryLanguageUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Language>() {
      @Override
      @Nullable
      public Language call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final Language _result;
          if (_cursor.moveToFirst()) {
            _result = new Language();
            final long _tmpLangUid;
            _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
            _result.setLangUid(_tmpLangUid);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _result.setName(_tmpName);
            final String _tmpIso_639_1_standard;
            if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
              _tmpIso_639_1_standard = null;
            } else {
              _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
            }
            _result.setIso_639_1_standard(_tmpIso_639_1_standard);
            final String _tmpIso_639_2_standard;
            if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
              _tmpIso_639_2_standard = null;
            } else {
              _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
            }
            _result.setIso_639_2_standard(_tmpIso_639_2_standard);
            final String _tmpIso_639_3_standard;
            if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
              _tmpIso_639_3_standard = null;
            } else {
              _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
            }
            _result.setIso_639_3_standard(_tmpIso_639_3_standard);
            final String _tmpLanguage_Type;
            if (_cursor.isNull(_cursorIndexOfLanguageType)) {
              _tmpLanguage_Type = null;
            } else {
              _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
            }
            _result.setLanguage_Type(_tmpLanguage_Type);
            final boolean _tmpLanguageActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
            _tmpLanguageActive = _tmp != 0;
            _result.setLanguageActive(_tmpLanguageActive);
            final long _tmpLangLocalChangeSeqNum;
            _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
            _result.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
            final long _tmpLangMasterChangeSeqNum;
            _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
            _result.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
            final int _tmpLangLastChangedBy;
            _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
            _result.setLangLastChangedBy(_tmpLangLastChangedBy);
            final long _tmpLangLct;
            _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
            _result.setLangLct(_tmpLangLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<Language>> findAllLanguageLive() {
    final String _sql = "SELECT * FROM LANGUAGE";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"LANGUAGE"}, new Callable<List<Language>>() {
      @Override
      @NonNull
      public List<Language> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final List<Language> _result = new ArrayList<Language>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Language _item;
            _item = new Language();
            final long _tmpLangUid;
            _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
            _item.setLangUid(_tmpLangUid);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _item.setName(_tmpName);
            final String _tmpIso_639_1_standard;
            if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
              _tmpIso_639_1_standard = null;
            } else {
              _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
            }
            _item.setIso_639_1_standard(_tmpIso_639_1_standard);
            final String _tmpIso_639_2_standard;
            if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
              _tmpIso_639_2_standard = null;
            } else {
              _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
            }
            _item.setIso_639_2_standard(_tmpIso_639_2_standard);
            final String _tmpIso_639_3_standard;
            if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
              _tmpIso_639_3_standard = null;
            } else {
              _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
            }
            _item.setIso_639_3_standard(_tmpIso_639_3_standard);
            final String _tmpLanguage_Type;
            if (_cursor.isNull(_cursorIndexOfLanguageType)) {
              _tmpLanguage_Type = null;
            } else {
              _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
            }
            _item.setLanguage_Type(_tmpLanguage_Type);
            final boolean _tmpLanguageActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
            _tmpLanguageActive = _tmp != 0;
            _item.setLanguageActive(_tmpLanguageActive);
            final long _tmpLangLocalChangeSeqNum;
            _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
            _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
            final long _tmpLangMasterChangeSeqNum;
            _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
            _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
            final int _tmpLangLastChangedBy;
            _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
            _item.setLangLastChangedBy(_tmpLangLastChangedBy);
            final long _tmpLangLct;
            _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
            _item.setLangLct(_tmpLangLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Long> findByUidList(final List<Long> uidList) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT langUid FROM LANGUAGE WHERE langUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Long _item_1;
        _item_1 = _cursor.getLong(0);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object toggleVisibilityLanguage(final boolean toggleVisibility,
      final List<Long> selectedItem, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE Language ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET languageActive = ");
        _stringBuilder.append("?");
        _stringBuilder.append(", ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               langLct = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE langUid IN (");
        final int _inputSize = selectedItem.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final int _tmp = toggleVisibility ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        for (long _item : selectedItem) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
