package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.VerbLangMapEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class VerbLangMapEntryDao_Impl extends VerbLangMapEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<VerbLangMapEntry> __insertionAdapterOfVerbLangMapEntry;

  public VerbLangMapEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfVerbLangMapEntry = new EntityInsertionAdapter<VerbLangMapEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `VerbLangMapEntry` (`vlmeVerbUid`,`vlmeLangHash`,`vlmeLangCode`,`vlmeEntryString`,`vlmeLastModified`) VALUES (?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final VerbLangMapEntry entity) {
        statement.bindLong(1, entity.getVlmeVerbUid());
        statement.bindLong(2, entity.getVlmeLangHash());
        if (entity.getVlmeLangCode() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getVlmeLangCode());
        }
        if (entity.getVlmeEntryString() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getVlmeEntryString());
        }
        statement.bindLong(5, entity.getVlmeLastModified());
      }
    };
  }

  @Override
  public Object upsertList(final List<VerbLangMapEntry> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfVerbLangMapEntry.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByVerbUidAsync(final long verbUid,
      final Continuation<? super List<VerbLangMapEntry>> $completion) {
    final String _sql = "\n"
            + "        SELECT VerbLangMapEntry.*\n"
            + "          FROM VerbLangMapEntry\n"
            + "         WHERE VerbLangMapEntry.vlmeVerbUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, verbUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<VerbLangMapEntry>>() {
      @Override
      @NonNull
      public List<VerbLangMapEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfVlmeVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "vlmeVerbUid");
          final int _cursorIndexOfVlmeLangHash = CursorUtil.getColumnIndexOrThrow(_cursor, "vlmeLangHash");
          final int _cursorIndexOfVlmeLangCode = CursorUtil.getColumnIndexOrThrow(_cursor, "vlmeLangCode");
          final int _cursorIndexOfVlmeEntryString = CursorUtil.getColumnIndexOrThrow(_cursor, "vlmeEntryString");
          final int _cursorIndexOfVlmeLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "vlmeLastModified");
          final List<VerbLangMapEntry> _result = new ArrayList<VerbLangMapEntry>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final VerbLangMapEntry _item;
            final long _tmpVlmeVerbUid;
            _tmpVlmeVerbUid = _cursor.getLong(_cursorIndexOfVlmeVerbUid);
            final long _tmpVlmeLangHash;
            _tmpVlmeLangHash = _cursor.getLong(_cursorIndexOfVlmeLangHash);
            final String _tmpVlmeLangCode;
            if (_cursor.isNull(_cursorIndexOfVlmeLangCode)) {
              _tmpVlmeLangCode = null;
            } else {
              _tmpVlmeLangCode = _cursor.getString(_cursorIndexOfVlmeLangCode);
            }
            final String _tmpVlmeEntryString;
            if (_cursor.isNull(_cursorIndexOfVlmeEntryString)) {
              _tmpVlmeEntryString = null;
            } else {
              _tmpVlmeEntryString = _cursor.getString(_cursorIndexOfVlmeEntryString);
            }
            final long _tmpVlmeLastModified;
            _tmpVlmeLastModified = _cursor.getLong(_cursorIndexOfVlmeLastModified);
            _item = new VerbLangMapEntry(_tmpVlmeVerbUid,_tmpVlmeLangHash,_tmpVlmeLangCode,_tmpVlmeEntryString,_tmpVlmeLastModified);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
