package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.CacheLockJoin
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class CacheLockJoinDao {
  @Query(`value` =
      "\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljStatus = 1 \n            OR CacheLockJoin.cljStatus = 3\n    ")
  public actual abstract suspend fun findPendingLocks(): List<CacheLockJoin>

  @Query(`value` =
      "\n        UPDATE CacheLockJoin\n           SET cljLockId = :lockId,\n               cljStatus = :status\n         WHERE cljId = :uid   \n    ")
  public actual abstract suspend fun updateLockIdAndStatus(
    uid: Int,
    lockId: Long,
    status: Int,
  )

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertListAsync(list: List<CacheLockJoin>)

  @Query(`value` =
      "\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljTableId = :tableId\n           AND CacheLockJoin.cljEntityUid = :entityUid\n    ")
  public actual abstract suspend fun findByTableIdAndEntityUid(tableId: Int, entityUid: Long):
      List<CacheLockJoin>

  @Delete(entity = Any::class)
  public actual abstract suspend fun deleteListAsync(list: List<CacheLockJoin>)
}
