package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.CourseTerminology
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class CourseTerminologyDao : BaseDao<CourseTerminology> {
  @Query(`value` =
      "\n        SELECT *\n         FROM CourseTerminology\n     ORDER BY ctTitle   \n    ")
  public actual abstract fun findAllCourseTerminologyPagingSource():
      PagingSource<Int, CourseTerminology>

  @Query(`value` =
      "\n        SELECT *\n         FROM CourseTerminology\n     ORDER BY ctTitle   \n    ")
  public actual abstract fun findAllCourseTerminologyList(): List<CourseTerminology>

  @Query(`value` =
      "\n        SELECT *\n          FROM CourseTerminology\n               JOIN Clazz \n               ON Clazz.clazzTerminologyUid = CourseTerminology.ctUid\n         WHERE Clazz.clazzUid = :clazzUid\n    ")
  public actual abstract suspend fun getTerminologyForClazz(clazzUid: Long): CourseTerminology?

  @Query(`value` =
      "\n        SELECT CourseTerminology.*\n          FROM ClazzAssignment\n               JOIN Clazz \n                    ON Clazz.clazzUid = ClazzAssignment.caClazzUid\n               JOIN CourseTerminology\n                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE ClazzAssignment.caUid = :assignmentUid \n         LIMIT 1\n    ")
  public actual abstract suspend fun getTerminologyForAssignment(assignmentUid: Long):
      CourseTerminology?

  @Query(`value` =
      "\n        SELECT * \n         FROM CourseTerminology \n        WHERE ctUid = :uid\n        ")
  public actual abstract suspend fun findByUidAsync(uid: Long): CourseTerminology?

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: CourseTerminology): Int

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertAsync(entity: CourseTerminology): Long
}
