package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.PersonAndClazzLogAttendanceRecord;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzLogAttendanceRecordDao_Impl extends ClazzLogAttendanceRecordDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzLogAttendanceRecord> __insertionAdapterOfClazzLogAttendanceRecord;

  private final EntityInsertionAdapter<ClazzLogAttendanceRecord> __insertionAdapterOfClazzLogAttendanceRecord_1;

  private final EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord> __updateAdapterOfClazzLogAttendanceRecord;

  private final SharedSQLiteStatement __preparedStmtOfUpdateRescheduledClazzLogUids;

  public ClazzLogAttendanceRecordDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzLogAttendanceRecord = new EntityInsertionAdapter<ClazzLogAttendanceRecord>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid`,`clazzLogAttendanceRecordClazzLogUid`,`clazzLogAttendanceRecordPersonUid`,`attendanceStatus`,`clazzLogAttendanceRecordMasterChangeSeqNum`,`clazzLogAttendanceRecordLocalChangeSeqNum`,`clazzLogAttendanceRecordLastChangedBy`,`clazzLogAttendanceRecordLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLogAttendanceRecord entity) {
        statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
        statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
        statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
        statement.bindLong(4, entity.getAttendanceStatus());
        statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
        statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
        statement.bindLong(7, entity.getClazzLogAttendanceRecordLastChangedBy());
        statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
      }
    };
    this.__insertionAdapterOfClazzLogAttendanceRecord_1 = new EntityInsertionAdapter<ClazzLogAttendanceRecord>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid`,`clazzLogAttendanceRecordClazzLogUid`,`clazzLogAttendanceRecordPersonUid`,`attendanceStatus`,`clazzLogAttendanceRecordMasterChangeSeqNum`,`clazzLogAttendanceRecordLocalChangeSeqNum`,`clazzLogAttendanceRecordLastChangedBy`,`clazzLogAttendanceRecordLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLogAttendanceRecord entity) {
        statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
        statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
        statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
        statement.bindLong(4, entity.getAttendanceStatus());
        statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
        statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
        statement.bindLong(7, entity.getClazzLogAttendanceRecordLastChangedBy());
        statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
      }
    };
    this.__updateAdapterOfClazzLogAttendanceRecord = new EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ClazzLogAttendanceRecord` SET `clazzLogAttendanceRecordUid` = ?,`clazzLogAttendanceRecordClazzLogUid` = ?,`clazzLogAttendanceRecordPersonUid` = ?,`attendanceStatus` = ?,`clazzLogAttendanceRecordMasterChangeSeqNum` = ?,`clazzLogAttendanceRecordLocalChangeSeqNum` = ?,`clazzLogAttendanceRecordLastChangedBy` = ?,`clazzLogAttendanceRecordLastChangedTime` = ? WHERE `clazzLogAttendanceRecordUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLogAttendanceRecord entity) {
        statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
        statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
        statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
        statement.bindLong(4, entity.getAttendanceStatus());
        statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
        statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
        statement.bindLong(7, entity.getClazzLogAttendanceRecordLastChangedBy());
        statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
        statement.bindLong(9, entity.getClazzLogAttendanceRecordUid());
      }
    };
    this.__preparedStmtOfUpdateRescheduledClazzLogUids = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzLogAttendanceRecord\n"
                + "           SET clazzLogAttendanceRecordClazzLogUid = ?,\n"
                + "               clazzLogAttendanceRecordLastChangedTime = ?\n"
                + "        WHERE clazzLogAttendanceRecordClazzLogUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzLogAttendanceRecord entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzLogAttendanceRecord entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ClazzLogAttendanceRecord> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzLogAttendanceRecord.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ClazzLogAttendanceRecord> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzLogAttendanceRecord.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<? extends ClazzLogAttendanceRecord> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzLogAttendanceRecord_1.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final ClazzLogAttendanceRecord entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLogAttendanceRecord.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends ClazzLogAttendanceRecord> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzLogAttendanceRecord.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void updateRescheduledClazzLogUids(final long oldClazzLogUid, final long newClazzLogUid,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateRescheduledClazzLogUids.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, newClazzLogUid);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, oldClazzLogUid);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateRescheduledClazzLogUids.release(_stmt);
    }
  }

  @Override
  public ClazzLogAttendanceRecord findByUid(final long uid) {
    final String _sql = "SELECT * from ClazzLogAttendanceRecord WHERE clazzLogAttendanceRecordUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordUid");
      final int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordClazzLogUid");
      final int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordPersonUid");
      final int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceStatus");
      final int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordMasterChangeSeqNum");
      final int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLocalChangeSeqNum");
      final int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedBy");
      final int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedTime");
      final ClazzLogAttendanceRecord _result;
      if (_cursor.moveToFirst()) {
        _result = new ClazzLogAttendanceRecord();
        final long _tmpClazzLogAttendanceRecordUid;
        _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
        _result.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
        final long _tmpClazzLogAttendanceRecordClazzLogUid;
        _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
        _result.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
        final long _tmpClazzLogAttendanceRecordPersonUid;
        _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
        _result.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
        final int _tmpAttendanceStatus;
        _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
        _result.setAttendanceStatus(_tmpAttendanceStatus);
        final long _tmpClazzLogAttendanceRecordMasterChangeSeqNum;
        _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
        _result.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
        final long _tmpClazzLogAttendanceRecordLocalChangeSeqNum;
        _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
        _result.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
        final int _tmpClazzLogAttendanceRecordLastChangedBy;
        _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
        _result.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
        final long _tmpClazzLogAttendanceRecordLastChangedTime;
        _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
        _result.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByClazzLogUid(final long clazzLogUid,
      final Continuation<? super List<ClazzLogAttendanceRecordWithPerson>> $completion) {
    final String _sql = "SELECT ClazzLogAttendanceRecord.*, Person.*\n"
            + "         FROM ClazzLogAttendanceRecord \n"
            + "         LEFT JOIN Person ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid\n"
            + "         WHERE clazzLogAttendanceRecordClazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzLogUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLogAttendanceRecordWithPerson>>() {
      @Override
      @NonNull
      public List<ClazzLogAttendanceRecordWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordUid");
          final int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordClazzLogUid");
          final int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordPersonUid");
          final int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceStatus");
          final int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordMasterChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLocalChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedBy");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedTime");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final List<ClazzLogAttendanceRecordWithPerson> _result = new ArrayList<ClazzLogAttendanceRecordWithPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzLogAttendanceRecordWithPerson _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            _item = new ClazzLogAttendanceRecordWithPerson();
            final long _tmpClazzLogAttendanceRecordUid;
            _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
            _item.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
            final long _tmpClazzLogAttendanceRecordClazzLogUid;
            _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
            _item.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
            final long _tmpClazzLogAttendanceRecordPersonUid;
            _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
            _item.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
            final int _tmpAttendanceStatus;
            _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
            _item.setAttendanceStatus(_tmpAttendanceStatus);
            final long _tmpClazzLogAttendanceRecordMasterChangeSeqNum;
            _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
            _item.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
            final long _tmpClazzLogAttendanceRecordLocalChangeSeqNum;
            _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
            _item.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
            final int _tmpClazzLogAttendanceRecordLastChangedBy;
            _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
            _item.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
            final long _tmpClazzLogAttendanceRecordLastChangedTime;
            _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
            _item.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzAndTime(final long clazzUid, final long clazzLogUid, final long time,
      final Continuation<? super List<PersonAndClazzLogAttendanceRecord>> $completion) {
    final String _sql = "\n"
            + "        \n"
            + "        WITH CurrentlyEnrolledPersonUids(enroledPersonUid) AS\n"
            + "              (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS enroledPersonUid\n"
            + "                 FROM ClazzEnrolment\n"
            + "                WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                  AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                  AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft)\n"
            + "    \n"
            + "                  \n"
            + "        SELECT Person.*, ClazzLogAttendanceRecord.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN ClazzLogAttendanceRecord \n"
            + "                         ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid = \n"
            + "                            (SELECT ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordUid  \n"
            + "                               FROM ClazzLogAttendanceRecord ClazzLogAttendanceRecordInner\n"
            + "                              WHERE ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordClazzLogUid = ?\n"
            + "                                AND ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordPersonUid = Person.personUid\n"
            + "                           ORDER BY ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordLastChangedTime DESC     \n"
            + "                              LIMIT 1  \n"
            + "                            )\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN \n"
            + "               (SELECT CurrentlyEnrolledPersonUids.enroledPersonUid\n"
            + "                  FROM CurrentlyEnrolledPersonUids)                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, time);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzLogUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndClazzLogAttendanceRecord>>() {
      @Override
      @NonNull
      public List<PersonAndClazzLogAttendanceRecord> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordUid");
          final int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordClazzLogUid");
          final int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordPersonUid");
          final int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceStatus");
          final int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordMasterChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLocalChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedBy");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedTime");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndClazzLogAttendanceRecord> _result = new ArrayList<PersonAndClazzLogAttendanceRecord>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndClazzLogAttendanceRecord _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final ClazzLogAttendanceRecord _tmpAttendanceRecord;
            if (!(_cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordUid) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordPersonUid) && _cursor.isNull(_cursorIndexOfAttendanceStatus) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime))) {
              _tmpAttendanceRecord = new ClazzLogAttendanceRecord();
              final long _tmpClazzLogAttendanceRecordUid;
              _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
              final long _tmpClazzLogAttendanceRecordClazzLogUid;
              _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
              final long _tmpClazzLogAttendanceRecordPersonUid;
              _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
              final int _tmpAttendanceStatus;
              _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
              _tmpAttendanceRecord.setAttendanceStatus(_tmpAttendanceStatus);
              final long _tmpClazzLogAttendanceRecordMasterChangeSeqNum;
              _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
              final long _tmpClazzLogAttendanceRecordLocalChangeSeqNum;
              _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
              final int _tmpClazzLogAttendanceRecordLastChangedBy;
              _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
              final long _tmpClazzLogAttendanceRecordLastChangedTime;
              _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
              _tmpAttendanceRecord.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
            } else {
              _tmpAttendanceRecord = null;
            }
            final PersonPicture _tmpPersonPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPersonPicture = null;
            }
            _item = new PersonAndClazzLogAttendanceRecord(_tmpPerson,_tmpPersonPicture,_tmpAttendanceRecord);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
