package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.CourseGroupMemberAndPerson;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupMemberAndName;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseGroupMemberDao_Impl extends CourseGroupMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseGroupMember> __insertionAdapterOfCourseGroupMember;

  private final EntityInsertionAdapter<CourseGroupMember> __insertionAdapterOfCourseGroupMember_1;

  private final EntityDeletionOrUpdateAdapter<CourseGroupMember> __updateAdapterOfCourseGroupMember;

  public CourseGroupMemberDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseGroupMember = new EntityInsertionAdapter<CourseGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseGroupMember` (`cgmUid`,`cgmSetUid`,`cgmGroupNumber`,`cgmPersonUid`,`cgmLct`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupMember entity) {
        statement.bindLong(1, entity.getCgmUid());
        statement.bindLong(2, entity.getCgmSetUid());
        statement.bindLong(3, entity.getCgmGroupNumber());
        statement.bindLong(4, entity.getCgmPersonUid());
        statement.bindLong(5, entity.getCgmLct());
      }
    };
    this.__insertionAdapterOfCourseGroupMember_1 = new EntityInsertionAdapter<CourseGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CourseGroupMember` (`cgmUid`,`cgmSetUid`,`cgmGroupNumber`,`cgmPersonUid`,`cgmLct`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupMember entity) {
        statement.bindLong(1, entity.getCgmUid());
        statement.bindLong(2, entity.getCgmSetUid());
        statement.bindLong(3, entity.getCgmGroupNumber());
        statement.bindLong(4, entity.getCgmPersonUid());
        statement.bindLong(5, entity.getCgmLct());
      }
    };
    this.__updateAdapterOfCourseGroupMember = new EntityDeletionOrUpdateAdapter<CourseGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseGroupMember` SET `cgmUid` = ?,`cgmSetUid` = ?,`cgmGroupNumber` = ?,`cgmPersonUid` = ?,`cgmLct` = ? WHERE `cgmUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupMember entity) {
        statement.bindLong(1, entity.getCgmUid());
        statement.bindLong(2, entity.getCgmSetUid());
        statement.bindLong(3, entity.getCgmGroupNumber());
        statement.bindLong(4, entity.getCgmPersonUid());
        statement.bindLong(5, entity.getCgmLct());
        statement.bindLong(6, entity.getCgmUid());
      }
    };
  }

  @Override
  public long insert(final CourseGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseGroupMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseGroupMember entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseGroupMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseGroupMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<CourseGroupMember> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseGroupMember.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<CourseGroupMember> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseGroupMember_1.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseGroupMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<CourseGroupMember> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCourseGroupMember.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByGroupSetUidAsync(final long groupSetUid,
      final Continuation<? super List<CourseGroupMember>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseGroupMember.*\n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE cgmSetUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupSetUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMember>>() {
      @Override
      @NonNull
      public List<CourseGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final List<CourseGroupMember> _result = new ArrayList<CourseGroupMember>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMember _item;
            final long _tmpCgmUid;
            _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
            final long _tmpCgmSetUid;
            _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
            final int _tmpCgmGroupNumber;
            _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
            final long _tmpCgmPersonUid;
            _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
            final long _tmpCgmLct;
            _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
            _item = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByPersonUid(final long groupSetUid, final long studentUid,
      final Continuation<? super CourseGroupMember> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE cgmPersonUid = ? \n"
            + "          AND cgmSetUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, studentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupSetUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseGroupMember>() {
      @Override
      @Nullable
      public CourseGroupMember call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final CourseGroupMember _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCgmUid;
            _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
            final long _tmpCgmSetUid;
            _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
            final int _tmpCgmGroupNumber;
            _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
            final long _tmpCgmPersonUid;
            _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
            final long _tmpCgmLct;
            _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
            _result = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByCourseGroupSetAndClazz(final long cgsUid, final long clazzUid,
      final long time, final int activeFilter, final long accountPersonUid,
      final Continuation<? super List<CourseGroupMemberAndName>> $completion) {
    final String _sql = "\n"
            + "        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n"
            + "        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n"
            + "             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n"
            + "                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n"
            + "                FROM ClazzEnrolment\n"
            + "               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "        CASE(?)\n"
            + "                         WHEN 0 THEN \n"
            + "                                (SELECT CourseGroupSet.cgsClazzUid\n"
            + "                                   FROM CourseGroupSet\n"
            + "                                  WHERE CourseGroupSet.cgsUid = ?)\n"
            + "                         ELSE ?\n"
            + "                     END\n"
            + "    \n"
            + "                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n"
            + "        --Consolidate and removes any duplicates\n"
            + "             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n"
            + "             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n"
            + "                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n"
            + "                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n"
            + "                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n"
            + "                    ORDER BY AllEnrollmentsInner.isActive DESC\n"
            + "                       LIMIT 1) AS isActive\n"
            + "                FROM AllEnrollmentsAndActiveStatus)\n"
            + "        \n"
            + "        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n"
            + "        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n"
            + "               Person.personUid,\n"
            + "               CourseGroupMember.*,\n"
            + "               PersonPicture.*,\n"
            + "               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n"
            + "               PersonPicture.personPictureThumbnailUri AS pictureUri\n"
            + "          FROM EnrolledStudentPersonUids\n"
            + "               JOIN Person\n"
            + "                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid  \n"
            + "               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n"
            + "               LEFT JOIN CourseGroupMember\n"
            + "                         ON CourseGroupMember.cgmUid = \n"
            + "                            (SELECT CourseGroupMember.cgmUid\n"
            + "                               FROM CourseGroupMember\n"
            + "                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n"
            + "                                AND CourseGroupMember.cgmSetUid = ? \n"
            + "                           ORDER BY CourseGroupMember.cgmLct DESC        \n"
            + "                              LIMIT 1)\n"
            + "         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n"
            + "               /* \n"
            + "                * Begin permission check -  must have course view members permission, or active \n"
            + "                * user must be in the same group \n"
            + "                */ \n"
            + "            AND (\n"
            + "                    ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                  OR EXISTS(\n"
            + "                     SELECT 1\n"
            + "                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n"
            + "                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n"
            + "                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n"
            + "                 )\n"
            + "      ORDER BY Person.firstNames, Person.lastName ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 14);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, time);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, activeFilter);
    _argIndex = 7;
    _statement.bindLong(_argIndex, activeFilter);
    _argIndex = 8;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMemberAndName>>() {
      @Override
      @NonNull
      public List<CourseGroupMemberAndName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final int _cursorIndexOfEnrolmentIsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "enrolmentIsActive");
          final int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "pictureUri");
          final List<CourseGroupMemberAndName> _result = new ArrayList<CourseGroupMemberAndName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMemberAndName _item;
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final boolean _tmpEnrolmentIsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfEnrolmentIsActive);
            _tmpEnrolmentIsActive = _tmp != 0;
            final String _tmpPictureUri;
            if (_cursor.isNull(_cursorIndexOfPictureUri)) {
              _tmpPictureUri = null;
            } else {
              _tmpPictureUri = _cursor.getString(_cursorIndexOfPictureUri);
            }
            final CourseGroupMember _tmpCgm;
            if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
              final long _tmpCgmUid;
              _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
              final long _tmpCgmSetUid;
              _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
              final int _tmpCgmGroupNumber;
              _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
              final long _tmpCgmPersonUid;
              _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
              final long _tmpCgmLct;
              _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
              _tmpCgm = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            } else {
              _tmpCgm = null;
            }
            _item = new CourseGroupMemberAndName(_tmpCgm,_tmpName,_tmpPersonUid,_tmpEnrolmentIsActive,_tmpPictureUri);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<CourseGroupMemberAndName>> findByCourseGroupSetAndClazzAsFlow(final long cgsUid,
      final long clazzUid, final long time, final int activeFilter, final long accountPersonUid) {
    final String _sql = "\n"
            + "        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n"
            + "        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n"
            + "             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n"
            + "                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n"
            + "                FROM ClazzEnrolment\n"
            + "               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "        CASE(?)\n"
            + "                         WHEN 0 THEN \n"
            + "                                (SELECT CourseGroupSet.cgsClazzUid\n"
            + "                                   FROM CourseGroupSet\n"
            + "                                  WHERE CourseGroupSet.cgsUid = ?)\n"
            + "                         ELSE ?\n"
            + "                     END\n"
            + "    \n"
            + "                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n"
            + "        --Consolidate and removes any duplicates\n"
            + "             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n"
            + "             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n"
            + "                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n"
            + "                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n"
            + "                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n"
            + "                    ORDER BY AllEnrollmentsInner.isActive DESC\n"
            + "                       LIMIT 1) AS isActive\n"
            + "                FROM AllEnrollmentsAndActiveStatus)\n"
            + "        \n"
            + "        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n"
            + "        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n"
            + "               Person.personUid,\n"
            + "               CourseGroupMember.*,\n"
            + "               PersonPicture.*,\n"
            + "               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n"
            + "               PersonPicture.personPictureThumbnailUri AS pictureUri\n"
            + "          FROM EnrolledStudentPersonUids\n"
            + "               JOIN Person\n"
            + "                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid  \n"
            + "               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n"
            + "               LEFT JOIN CourseGroupMember\n"
            + "                         ON CourseGroupMember.cgmUid = \n"
            + "                            (SELECT CourseGroupMember.cgmUid\n"
            + "                               FROM CourseGroupMember\n"
            + "                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n"
            + "                                AND CourseGroupMember.cgmSetUid = ? \n"
            + "                           ORDER BY CourseGroupMember.cgmLct DESC        \n"
            + "                              LIMIT 1)\n"
            + "         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n"
            + "               /* \n"
            + "                * Begin permission check -  must have course view members permission, or active \n"
            + "                * user must be in the same group \n"
            + "                */ \n"
            + "            AND (\n"
            + "                    ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                  OR EXISTS(\n"
            + "                     SELECT 1\n"
            + "                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n"
            + "                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n"
            + "                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n"
            + "                 )\n"
            + "      ORDER BY Person.firstNames, Person.lastName ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 14);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, time);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, activeFilter);
    _argIndex = 7;
    _statement.bindLong(_argIndex, activeFilter);
    _argIndex = 8;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment", "CourseGroupSet",
        "Person", "PersonPicture", "CourseGroupMember", "Clazz", "CoursePermission",
        "SystemPermission"}, new Callable<List<CourseGroupMemberAndName>>() {
      @Override
      @NonNull
      public List<CourseGroupMemberAndName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final int _cursorIndexOfEnrolmentIsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "enrolmentIsActive");
          final int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "pictureUri");
          final List<CourseGroupMemberAndName> _result = new ArrayList<CourseGroupMemberAndName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMemberAndName _item;
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final boolean _tmpEnrolmentIsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfEnrolmentIsActive);
            _tmpEnrolmentIsActive = _tmp != 0;
            final String _tmpPictureUri;
            if (_cursor.isNull(_cursorIndexOfPictureUri)) {
              _tmpPictureUri = null;
            } else {
              _tmpPictureUri = _cursor.getString(_cursorIndexOfPictureUri);
            }
            final CourseGroupMember _tmpCgm;
            if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
              final long _tmpCgmUid;
              _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
              final long _tmpCgmSetUid;
              _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
              final int _tmpCgmGroupNumber;
              _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
              final long _tmpCgmPersonUid;
              _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
              final long _tmpCgmLct;
              _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
              _tmpCgm = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            } else {
              _tmpCgm = null;
            }
            _item = new CourseGroupMemberAndName(_tmpCgm,_tmpName,_tmpPersonUid,_tmpEnrolmentIsActive,_tmpPictureUri);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByCourseGroupSetAndClazzAsFlowPersons(final long clazzUid, final long cgsUid,
      final Continuation<? super List<PersonAndPicture>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN\n"
            + "               (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                  FROM ClazzEnrolment\n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "        CASE(?)\n"
            + "                         WHEN 0 THEN \n"
            + "                                (SELECT CourseGroupSet.cgsClazzUid\n"
            + "                                   FROM CourseGroupSet\n"
            + "                                  WHERE CourseGroupSet.cgsUid = ?)\n"
            + "                         ELSE ?\n"
            + "                     END\n"
            + "    )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndPicture>>() {
      @Override
      @NonNull
      public List<PersonAndPicture> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndPicture _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByCourseGroupSetAndClazzAsFlowEnrolments(final long clazzUid, final long cgsUid,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "        CASE(?)\n"
            + "                         WHEN 0 THEN \n"
            + "                                (SELECT CourseGroupSet.cgsClazzUid\n"
            + "                                   FROM CourseGroupSet\n"
            + "                                  WHERE CourseGroupSet.cgsUid = ?)\n"
            + "                         ELSE ?\n"
            + "                     END\n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, cgsUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentInviteUid");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            final long _tmpClazzEnrolmentInviteUid;
            _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
            _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByCourseGroupSetAndGroupNumAsync(final long courseGroupSetUid,
      final int groupNum, final long clazzUid, final long assignmentUid,
      final long accountPersonUid,
      final Continuation<? super List<CourseGroupMemberAndPerson>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseGroupMember.*, Person.*\n"
            + "          FROM CourseGroupMember\n"
            + "               JOIN Person \n"
            + "                    ON Person.personUid = CourseGroupMember.cgmPersonUid\n"
            + "         WHERE (    CourseGroupMember.cgmSetUid = ?\n"
            + "                AND CourseGroupMember.cgmGroupNumber = ?)\n"
            + "           AND (    /* Grant permission where the active person is in the group */ \n"
            + "                    EXISTS(SELECT 1\n"
            + "                             FROM CourseGroupMember CourseGroupMemberInternal\n"
            + "                            WHERE CourseGroupMemberInternal.cgmSetUid = ?\n"
            + "                              AND CourseGroupMemberInternal.cgmPersonUid = ?)\n"
            + "                    /* Grant permission where the activepersonuid is in a group assigned to mark this group */\n"
            + "                 OR EXISTS(SELECT 1\n"
            + "                             FROM PeerReviewerAllocation\n"
            + "                            WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                              AND PeerReviewerAllocation.praMarkerSubmitterUid = ?\n"
            + "                              AND EXISTS(SELECT 1\n"
            + "                                           FROM CourseGroupMember CourseGroupMemberInternal\n"
            + "                                          WHERE CourseGroupMemberInternal.cgmSetUid = PeerReviewerAllocation.praMarkerSubmitterUid\n"
            + "                                            AND CourseGroupMemberInternal.cgmPersonUid = ?)) \n"
            + "                    /* Grant permission where the active person has the select person permission for the class */                        \n"
            + "                 OR ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     8192\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )    \n"
            + "               )\n"
            + "               \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 13);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseGroupSetUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupNum);
    _argIndex = 3;
    _statement.bindLong(_argIndex, courseGroupSetUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, groupNum);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMemberAndPerson>>() {
      @Override
      @NonNull
      public List<CourseGroupMemberAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final List<CourseGroupMemberAndPerson> _result = new ArrayList<CourseGroupMemberAndPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMemberAndPerson _item;
            final CourseGroupMember _tmpCourseGroupMember;
            if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
              final long _tmpCgmUid;
              _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
              final long _tmpCgmSetUid;
              _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
              final int _tmpCgmGroupNumber;
              _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
              final long _tmpCgmPersonUid;
              _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
              final long _tmpCgmLct;
              _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
              _tmpCourseGroupMember = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            } else {
              _tmpCourseGroupMember = null;
            }
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            _item = new CourseGroupMemberAndPerson(_tmpCourseGroupMember,_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
