package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndCoursePic;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndPersonDetails;
import com.ustadmobile.lib.db.entities.CoursePicture;
import com.ustadmobile.lib.db.entities.EnrolmentRequest;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class EnrolmentRequestDao_Impl extends EnrolmentRequestDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<EnrolmentRequest> __insertionAdapterOfEnrolmentRequest;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

  public EnrolmentRequestDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfEnrolmentRequest = new EntityInsertionAdapter<EnrolmentRequest>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `EnrolmentRequest` (`erUid`,`erClazzUid`,`erClazzName`,`erPersonUid`,`erPersonFullname`,`erPersonPictureUri`,`erPersonUsername`,`erRole`,`erRequestTime`,`erStatus`,`erStatusSetByPersonUid`,`erDeleted`,`erStatusSetAuth`,`erLastModified`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final EnrolmentRequest entity) {
        statement.bindLong(1, entity.getErUid());
        statement.bindLong(2, entity.getErClazzUid());
        if (entity.getErClazzName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getErClazzName());
        }
        statement.bindLong(4, entity.getErPersonUid());
        if (entity.getErPersonFullname() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getErPersonFullname());
        }
        if (entity.getErPersonPictureUri() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getErPersonPictureUri());
        }
        if (entity.getErPersonUsername() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getErPersonUsername());
        }
        statement.bindLong(8, entity.getErRole());
        statement.bindLong(9, entity.getErRequestTime());
        statement.bindLong(10, entity.getErStatus());
        statement.bindLong(11, entity.getErStatusSetByPersonUid());
        final int _tmp = entity.getErDeleted() ? 1 : 0;
        statement.bindLong(12, _tmp);
        if (entity.getErStatusSetAuth() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getErStatusSetAuth());
        }
        statement.bindLong(14, entity.getErLastModified());
      }
    };
    this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE EnrolmentRequest\n"
                + "           SET erStatus = ?,\n"
                + "               erLastModified = ?\n"
                + "         WHERE erUid = ?      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final EnrolmentRequest enrolmentRequest,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfEnrolmentRequest.insert(enrolmentRequest);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateStatus(final long uid, final int status, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzAndPerson(final long personUid, final long clazzUid,
      final int statusFilter, final Continuation<? super List<EnrolmentRequest>> $completion) {
    final String _sql = "\n"
            + "        SELECT EnrolmentRequest.*\n"
            + "          FROM EnrolmentRequest\n"
            + "         WHERE EnrolmentRequest.erPersonUid = ?\n"
            + "           AND EnrolmentRequest.erClazzUid = ?\n"
            + "           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, statusFilter);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<EnrolmentRequest>>() {
      @Override
      @NonNull
      public List<EnrolmentRequest> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erClazzUid");
          final int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "erClazzName");
          final int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonUid");
          final int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonFullname");
          final int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonPictureUri");
          final int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonUsername");
          final int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow(_cursor, "erRole");
          final int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow(_cursor, "erRequestTime");
          final int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatus");
          final int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatusSetByPersonUid");
          final int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "erDeleted");
          final int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatusSetAuth");
          final int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastModified");
          final List<EnrolmentRequest> _result = new ArrayList<EnrolmentRequest>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final EnrolmentRequest _item;
            final long _tmpErUid;
            _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
            final long _tmpErClazzUid;
            _tmpErClazzUid = _cursor.getLong(_cursorIndexOfErClazzUid);
            final String _tmpErClazzName;
            if (_cursor.isNull(_cursorIndexOfErClazzName)) {
              _tmpErClazzName = null;
            } else {
              _tmpErClazzName = _cursor.getString(_cursorIndexOfErClazzName);
            }
            final long _tmpErPersonUid;
            _tmpErPersonUid = _cursor.getLong(_cursorIndexOfErPersonUid);
            final String _tmpErPersonFullname;
            if (_cursor.isNull(_cursorIndexOfErPersonFullname)) {
              _tmpErPersonFullname = null;
            } else {
              _tmpErPersonFullname = _cursor.getString(_cursorIndexOfErPersonFullname);
            }
            final String _tmpErPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfErPersonPictureUri)) {
              _tmpErPersonPictureUri = null;
            } else {
              _tmpErPersonPictureUri = _cursor.getString(_cursorIndexOfErPersonPictureUri);
            }
            final String _tmpErPersonUsername;
            if (_cursor.isNull(_cursorIndexOfErPersonUsername)) {
              _tmpErPersonUsername = null;
            } else {
              _tmpErPersonUsername = _cursor.getString(_cursorIndexOfErPersonUsername);
            }
            final int _tmpErRole;
            _tmpErRole = _cursor.getInt(_cursorIndexOfErRole);
            final long _tmpErRequestTime;
            _tmpErRequestTime = _cursor.getLong(_cursorIndexOfErRequestTime);
            final int _tmpErStatus;
            _tmpErStatus = _cursor.getInt(_cursorIndexOfErStatus);
            final long _tmpErStatusSetByPersonUid;
            _tmpErStatusSetByPersonUid = _cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
            final boolean _tmpErDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfErDeleted);
            _tmpErDeleted = _tmp != 0;
            final String _tmpErStatusSetAuth;
            if (_cursor.isNull(_cursorIndexOfErStatusSetAuth)) {
              _tmpErStatusSetAuth = null;
            } else {
              _tmpErStatusSetAuth = _cursor.getString(_cursorIndexOfErStatusSetAuth);
            }
            final long _tmpErLastModified;
            _tmpErLastModified = _cursor.getLong(_cursorIndexOfErLastModified);
            _item = new EnrolmentRequest(_tmpErUid,_tmpErClazzUid,_tmpErClazzName,_tmpErPersonUid,_tmpErPersonFullname,_tmpErPersonPictureUri,_tmpErPersonUsername,_tmpErRole,_tmpErRequestTime,_tmpErStatus,_tmpErStatusSetByPersonUid,_tmpErDeleted,_tmpErStatusSetAuth,_tmpErLastModified);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object hasPendingRequests(final long personUid, final long clazzUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT EnrolmentRequest.erUid\n"
            + "                 FROM EnrolmentRequest\n"
            + "                WHERE EnrolmentRequest.erPersonUid = ?\n"
            + "                  AND EnrolmentRequest.erClazzUid = ?\n"
            + "                  AND EnrolmentRequest.erStatus = 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<EnrolmentRequestAndCoursePic>> findRequestsForUserAsFlow(
      final long accountPersonUid, final int statusFilter) {
    final String _sql = "\n"
            + "        SELECT EnrolmentRequest.*, CoursePicture.*\n"
            + "          FROM EnrolmentRequest\n"
            + "               LEFT JOIN CoursePicture\n"
            + "                         ON CoursePicture.coursePictureUid = EnrolmentRequest.erClazzUid\n"
            + "         WHERE EnrolmentRequest.erPersonUid = ? \n"
            + "           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, statusFilter);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"EnrolmentRequest",
        "CoursePicture"}, new Callable<List<EnrolmentRequestAndCoursePic>>() {
      @Override
      @NonNull
      public List<EnrolmentRequestAndCoursePic> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erClazzUid");
          final int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "erClazzName");
          final int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonUid");
          final int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonFullname");
          final int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonPictureUri");
          final int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "erPersonUsername");
          final int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow(_cursor, "erRole");
          final int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow(_cursor, "erRequestTime");
          final int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatus");
          final int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatusSetByPersonUid");
          final int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "erDeleted");
          final int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "erStatusSetAuth");
          final int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastModified");
          final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
          final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
          final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
          final int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureThumbnailUri");
          final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
          final List<EnrolmentRequestAndCoursePic> _result = new ArrayList<EnrolmentRequestAndCoursePic>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final EnrolmentRequestAndCoursePic _item;
            final EnrolmentRequest _tmpEnrolmentRequest;
            if (!(_cursor.isNull(_cursorIndexOfErUid) && _cursor.isNull(_cursorIndexOfErClazzUid) && _cursor.isNull(_cursorIndexOfErClazzName) && _cursor.isNull(_cursorIndexOfErPersonUid) && _cursor.isNull(_cursorIndexOfErPersonFullname) && _cursor.isNull(_cursorIndexOfErPersonPictureUri) && _cursor.isNull(_cursorIndexOfErPersonUsername) && _cursor.isNull(_cursorIndexOfErRole) && _cursor.isNull(_cursorIndexOfErRequestTime) && _cursor.isNull(_cursorIndexOfErStatus) && _cursor.isNull(_cursorIndexOfErStatusSetByPersonUid) && _cursor.isNull(_cursorIndexOfErDeleted) && _cursor.isNull(_cursorIndexOfErStatusSetAuth) && _cursor.isNull(_cursorIndexOfErLastModified))) {
              final long _tmpErUid;
              _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
              final long _tmpErClazzUid;
              _tmpErClazzUid = _cursor.getLong(_cursorIndexOfErClazzUid);
              final String _tmpErClazzName;
              if (_cursor.isNull(_cursorIndexOfErClazzName)) {
                _tmpErClazzName = null;
              } else {
                _tmpErClazzName = _cursor.getString(_cursorIndexOfErClazzName);
              }
              final long _tmpErPersonUid;
              _tmpErPersonUid = _cursor.getLong(_cursorIndexOfErPersonUid);
              final String _tmpErPersonFullname;
              if (_cursor.isNull(_cursorIndexOfErPersonFullname)) {
                _tmpErPersonFullname = null;
              } else {
                _tmpErPersonFullname = _cursor.getString(_cursorIndexOfErPersonFullname);
              }
              final String _tmpErPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfErPersonPictureUri)) {
                _tmpErPersonPictureUri = null;
              } else {
                _tmpErPersonPictureUri = _cursor.getString(_cursorIndexOfErPersonPictureUri);
              }
              final String _tmpErPersonUsername;
              if (_cursor.isNull(_cursorIndexOfErPersonUsername)) {
                _tmpErPersonUsername = null;
              } else {
                _tmpErPersonUsername = _cursor.getString(_cursorIndexOfErPersonUsername);
              }
              final int _tmpErRole;
              _tmpErRole = _cursor.getInt(_cursorIndexOfErRole);
              final long _tmpErRequestTime;
              _tmpErRequestTime = _cursor.getLong(_cursorIndexOfErRequestTime);
              final int _tmpErStatus;
              _tmpErStatus = _cursor.getInt(_cursorIndexOfErStatus);
              final long _tmpErStatusSetByPersonUid;
              _tmpErStatusSetByPersonUid = _cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
              final boolean _tmpErDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfErDeleted);
              _tmpErDeleted = _tmp != 0;
              final String _tmpErStatusSetAuth;
              if (_cursor.isNull(_cursorIndexOfErStatusSetAuth)) {
                _tmpErStatusSetAuth = null;
              } else {
                _tmpErStatusSetAuth = _cursor.getString(_cursorIndexOfErStatusSetAuth);
              }
              final long _tmpErLastModified;
              _tmpErLastModified = _cursor.getLong(_cursorIndexOfErLastModified);
              _tmpEnrolmentRequest = new EnrolmentRequest(_tmpErUid,_tmpErClazzUid,_tmpErClazzName,_tmpErPersonUid,_tmpErPersonFullname,_tmpErPersonPictureUri,_tmpErPersonUsername,_tmpErRole,_tmpErRequestTime,_tmpErStatus,_tmpErStatusSetByPersonUid,_tmpErDeleted,_tmpErStatusSetAuth,_tmpErLastModified);
            } else {
              _tmpEnrolmentRequest = null;
            }
            final CoursePicture _tmpCoursePicture;
            if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
              final long _tmpCoursePictureUid;
              _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
              final long _tmpCoursePictureLct;
              _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
              final String _tmpCoursePictureUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
                _tmpCoursePictureUri = null;
              } else {
                _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
              }
              final String _tmpCoursePictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri)) {
                _tmpCoursePictureThumbnailUri = null;
              } else {
                _tmpCoursePictureThumbnailUri = _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
              }
              final boolean _tmpCoursePictureActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
              _tmpCoursePictureActive = _tmp_1 != 0;
              _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid,_tmpCoursePictureLct,_tmpCoursePictureUri,_tmpCoursePictureThumbnailUri,_tmpCoursePictureActive);
            } else {
              _tmpCoursePicture = null;
            }
            _item = new EnrolmentRequestAndCoursePic(_tmpEnrolmentRequest,_tmpCoursePicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, EnrolmentRequestAndPersonDetails> findPendingEnrolmentsForCourse(
      final long clazzUid, final boolean includeDeleted, final int statusFilter,
      final String searchText, final int sortOrder) {
    final String _sql = "\n"
            + "        SELECT EnrolmentRequest.*, PersonPicture.*, Person.*\n"
            + "          FROM EnrolmentRequest\n"
            + "               JOIN Person\n"
            + "                    ON Person.personUid = EnrolmentRequest.erPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = EnrolmentRequest.erPersonUid\n"
            + "         WHERE EnrolmentRequest.erClazzUid = ?\n"
            + "           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR NOT EnrolmentRequest.erDeleted)\n"
            + "           AND (? = '%' OR EnrolmentRequest.erPersonFullname LIKE ?)\n"
            + "      ORDER BY CASE(?)\n"
            + "                WHEN 1 THEN EnrolmentRequest.erPersonFullname\n"
            + "                WHEN 3 THEN EnrolmentRequest.erPersonFullname\n"
            + "                ELSE ''\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                WHEN 2 THEN EnrolmentRequest.erPersonFullname\n"
            + "                WHEN 4 THEN EnrolmentRequest.erPersonFullname\n"
            + "                ELSE ''\n"
            + "            END DESC,\n"
            + "            CASE(?)\n"
            + "                WHEN 7 THEN EnrolmentRequest.erRequestTime\n"
            + "                ELSE 0\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 8 THEN EnrolmentRequest.erRequestTime\n"
            + "                ELSE 0\n"
            + "            END DESC     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 4;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 5;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 6;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 7;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 8;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 9;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 10;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<EnrolmentRequestAndPersonDetails>(_statement, __db, "EnrolmentRequest", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<EnrolmentRequestAndPersonDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(cursor, "erUid");
        final int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "erClazzUid");
        final int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow(cursor, "erClazzName");
        final int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "erPersonUid");
        final int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow(cursor, "erPersonFullname");
        final int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "erPersonPictureUri");
        final int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow(cursor, "erPersonUsername");
        final int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow(cursor, "erRole");
        final int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow(cursor, "erRequestTime");
        final int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow(cursor, "erStatus");
        final int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "erStatusSetByPersonUid");
        final int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "erDeleted");
        final int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow(cursor, "erStatusSetAuth");
        final int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "erLastModified");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(cursor, "isPersonalAccount");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final List<EnrolmentRequestAndPersonDetails> _result = new ArrayList<EnrolmentRequestAndPersonDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final EnrolmentRequestAndPersonDetails _item;
          final EnrolmentRequest _tmpEnrolmentRequest;
          if (!(cursor.isNull(_cursorIndexOfErUid) && cursor.isNull(_cursorIndexOfErClazzUid) && cursor.isNull(_cursorIndexOfErClazzName) && cursor.isNull(_cursorIndexOfErPersonUid) && cursor.isNull(_cursorIndexOfErPersonFullname) && cursor.isNull(_cursorIndexOfErPersonPictureUri) && cursor.isNull(_cursorIndexOfErPersonUsername) && cursor.isNull(_cursorIndexOfErRole) && cursor.isNull(_cursorIndexOfErRequestTime) && cursor.isNull(_cursorIndexOfErStatus) && cursor.isNull(_cursorIndexOfErStatusSetByPersonUid) && cursor.isNull(_cursorIndexOfErDeleted) && cursor.isNull(_cursorIndexOfErStatusSetAuth) && cursor.isNull(_cursorIndexOfErLastModified))) {
            final long _tmpErUid;
            _tmpErUid = cursor.getLong(_cursorIndexOfErUid);
            final long _tmpErClazzUid;
            _tmpErClazzUid = cursor.getLong(_cursorIndexOfErClazzUid);
            final String _tmpErClazzName;
            if (cursor.isNull(_cursorIndexOfErClazzName)) {
              _tmpErClazzName = null;
            } else {
              _tmpErClazzName = cursor.getString(_cursorIndexOfErClazzName);
            }
            final long _tmpErPersonUid;
            _tmpErPersonUid = cursor.getLong(_cursorIndexOfErPersonUid);
            final String _tmpErPersonFullname;
            if (cursor.isNull(_cursorIndexOfErPersonFullname)) {
              _tmpErPersonFullname = null;
            } else {
              _tmpErPersonFullname = cursor.getString(_cursorIndexOfErPersonFullname);
            }
            final String _tmpErPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfErPersonPictureUri)) {
              _tmpErPersonPictureUri = null;
            } else {
              _tmpErPersonPictureUri = cursor.getString(_cursorIndexOfErPersonPictureUri);
            }
            final String _tmpErPersonUsername;
            if (cursor.isNull(_cursorIndexOfErPersonUsername)) {
              _tmpErPersonUsername = null;
            } else {
              _tmpErPersonUsername = cursor.getString(_cursorIndexOfErPersonUsername);
            }
            final int _tmpErRole;
            _tmpErRole = cursor.getInt(_cursorIndexOfErRole);
            final long _tmpErRequestTime;
            _tmpErRequestTime = cursor.getLong(_cursorIndexOfErRequestTime);
            final int _tmpErStatus;
            _tmpErStatus = cursor.getInt(_cursorIndexOfErStatus);
            final long _tmpErStatusSetByPersonUid;
            _tmpErStatusSetByPersonUid = cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
            final boolean _tmpErDeleted;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfErDeleted);
            _tmpErDeleted = _tmp_1 != 0;
            final String _tmpErStatusSetAuth;
            if (cursor.isNull(_cursorIndexOfErStatusSetAuth)) {
              _tmpErStatusSetAuth = null;
            } else {
              _tmpErStatusSetAuth = cursor.getString(_cursorIndexOfErStatusSetAuth);
            }
            final long _tmpErLastModified;
            _tmpErLastModified = cursor.getLong(_cursorIndexOfErLastModified);
            _tmpEnrolmentRequest = new EnrolmentRequest(_tmpErUid,_tmpErClazzUid,_tmpErClazzName,_tmpErPersonUid,_tmpErPersonFullname,_tmpErPersonPictureUri,_tmpErPersonUsername,_tmpErRole,_tmpErRequestTime,_tmpErStatus,_tmpErStatusSetByPersonUid,_tmpErDeleted,_tmpErStatusSetAuth,_tmpErLastModified);
          } else {
            _tmpEnrolmentRequest = null;
          }
          final PersonPicture _tmpPersonPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_2 != 0;
            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPersonPicture = null;
          }
          final Person _tmpPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp_3 != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_4;
            _tmp_4 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_4 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_5;
            _tmp_5 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_5 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          _item = new EnrolmentRequestAndPersonDetails(_tmpEnrolmentRequest,_tmpPersonPicture,_tmpPerson);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
