package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ContentEntryVersion
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ContentEntryVersionDao.findLatestVersionUidByContentEntryUidEntity_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_contentEntryUid : Long = request.queryParam("contentEntryUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findLatestVersionUidByContentEntryUidEntity =
      findLatestVersionUidByContentEntryUidEntity(
    contentEntryUid = _arg_contentEntryUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findLatestVersionUidByContentEntryUidEntity?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 738,
          orUid = 0,
          entity = json.encodeToJsonElement(ContentEntryVersion.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ContentEntryVersionDao.findLatestByContentEntryUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_contentEntryUid : Long = request.queryParam("contentEntryUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findLatestByContentEntryUidAsFlow = findLatestByContentEntryUidAsFlow(
    contentEntryUid = _arg_contentEntryUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findLatestByContentEntryUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 738,
          orUid = 0,
          entity = json.encodeToJsonElement(ContentEntryVersion.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
