package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.DiscussionPost
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun DiscussionPostDao.getTopLevelPostsByCourseBlockUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_courseBlockUid : Long = request.queryParam("courseBlockUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_getTopLevelPostsByCourseBlockUid_pagingSource = getTopLevelPostsByCourseBlockUid(
    courseBlockUid = _arg_courseBlockUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_getTopLevelPostsByCourseBlockUid =
      _result_getTopLevelPostsByCourseBlockUid_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_getTopLevelPostsByCourseBlockUid_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_getTopLevelPostsByCourseBlockUid_pagingSource.endOfPaginationReached

  val _result_getTopLevelPostsByCourseBlockUidPersons = getTopLevelPostsByCourseBlockUidPersons(
    courseBlockUid = _arg_courseBlockUid,
  )
  val _result_getTopLevelPostsByCourseBlockUidLatestMessage =
      getTopLevelPostsByCourseBlockUidLatestMessage(
    courseBlockUid = _arg_courseBlockUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getTopLevelPostsByCourseBlockUid.map {
        _row ->
        DoorReplicationEntity(tableId = 132,
          orUid = 0,
          entity = json.encodeToJsonElement(DiscussionPost.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_getTopLevelPostsByCourseBlockUidPersons.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_getTopLevelPostsByCourseBlockUidPersons.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_getTopLevelPostsByCourseBlockUidLatestMessage.map {
        _row ->
        DoorReplicationEntity(tableId = 132,
          orUid = 0,
          entity = json.encodeToJsonElement(DiscussionPost.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun DiscussionPostDao.findByPostIdWithAllReplies_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_postUid : Long = request.queryParam("postUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findByPostIdWithAllReplies_pagingSource = findByPostIdWithAllReplies(
    postUid = _arg_postUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findByPostIdWithAllReplies = _result_findByPostIdWithAllReplies_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findByPostIdWithAllReplies_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findByPostIdWithAllReplies_pagingSource.endOfPaginationReached

  val _result_findByPostIdWithAllRepliesPersons = findByPostIdWithAllRepliesPersons(
    postUid = _arg_postUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByPostIdWithAllReplies.mapNotNull {
        _row ->
        _row.discussionPost?.let {
          DoorReplicationEntity(tableId = 132,
            orUid = 0,
            entity = json.encodeToJsonElement(DiscussionPost.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByPostIdWithAllRepliesPersons.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByPostIdWithAllRepliesPersons.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
