package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.door.entities.OutgoingReplication
import kotlin.Any
import kotlin.collections.List

@Dao
public actual abstract class OutgoingReplicationDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insert(outgoing: List<OutgoingReplication>)

  @Query(`value` =
      "\n        SELECT OutgoingReplication.*\n          FROM OutgoingReplication\n    ")
  public actual abstract suspend fun listReplications(): List<OutgoingReplication>
}
