package com.ustadmobile.core.db

import com.ustadmobile.core.db.dao.ClazzAssignmentDao
import com.ustadmobile.core.db.dao.ClazzAssignmentDao_KtorRoute
import com.ustadmobile.core.db.dao.ClazzDao
import com.ustadmobile.core.db.dao.ClazzDao_KtorRoute
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao_KtorRoute
import com.ustadmobile.core.db.dao.ClazzInviteDao
import com.ustadmobile.core.db.dao.ClazzInviteDao_KtorRoute
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao_KtorRoute
import com.ustadmobile.core.db.dao.ClazzLogDao
import com.ustadmobile.core.db.dao.ClazzLogDao_KtorRoute
import com.ustadmobile.core.db.dao.CommentsDao
import com.ustadmobile.core.db.dao.CommentsDao_KtorRoute
import com.ustadmobile.core.db.dao.ContentEntryDao
import com.ustadmobile.core.db.dao.ContentEntryDao_KtorRoute
import com.ustadmobile.core.db.dao.ContentEntryVersionDao
import com.ustadmobile.core.db.dao.ContentEntryVersionDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionFileDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionFileDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseBlockDao
import com.ustadmobile.core.db.dao.CourseBlockDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseGroupMemberDao
import com.ustadmobile.core.db.dao.CourseGroupMemberDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseGroupSetDao
import com.ustadmobile.core.db.dao.CourseGroupSetDao_KtorRoute
import com.ustadmobile.core.db.dao.CoursePermissionDao
import com.ustadmobile.core.db.dao.CoursePermissionDao_KtorRoute
import com.ustadmobile.core.db.dao.CourseTerminologyDao
import com.ustadmobile.core.db.dao.CourseTerminologyDao_KtorRoute
import com.ustadmobile.core.db.dao.DeletedItemDao
import com.ustadmobile.core.db.dao.DeletedItemDao_KtorRoute
import com.ustadmobile.core.db.dao.DiscussionPostDao
import com.ustadmobile.core.db.dao.DiscussionPostDao_KtorRoute
import com.ustadmobile.core.db.dao.EnrolmentRequestDao
import com.ustadmobile.core.db.dao.EnrolmentRequestDao_KtorRoute
import com.ustadmobile.core.db.dao.MessageDao
import com.ustadmobile.core.db.dao.MessageDao_KtorRoute
import com.ustadmobile.core.db.dao.PeerReviewerAllocationDao
import com.ustadmobile.core.db.dao.PeerReviewerAllocationDao_KtorRoute
import com.ustadmobile.core.db.dao.PersonAuth2Dao
import com.ustadmobile.core.db.dao.PersonAuth2Dao_KtorRoute
import com.ustadmobile.core.db.dao.PersonDao
import com.ustadmobile.core.db.dao.PersonDao_KtorRoute
import com.ustadmobile.core.db.dao.PersonParentJoinDao
import com.ustadmobile.core.db.dao.PersonParentJoinDao_KtorRoute
import com.ustadmobile.core.db.dao.PersonPasskeyDao
import com.ustadmobile.core.db.dao.PersonPasskeyDao_KtorRoute
import com.ustadmobile.core.db.dao.PersonPictureDao
import com.ustadmobile.core.db.dao.PersonPictureDao_KtorRoute
import com.ustadmobile.core.db.dao.ReportDao
import com.ustadmobile.core.db.dao.ReportDao_KtorRoute
import com.ustadmobile.core.db.dao.SiteDao
import com.ustadmobile.core.db.dao.SiteDao_KtorRoute
import com.ustadmobile.core.db.dao.SiteTermsDao
import com.ustadmobile.core.db.dao.SiteTermsDao_KtorRoute
import com.ustadmobile.core.db.dao.StudentResultDao
import com.ustadmobile.core.db.dao.StudentResultDao_KtorRoute
import com.ustadmobile.core.db.dao.SystemPermissionDao
import com.ustadmobile.core.db.dao.SystemPermissionDao_KtorRoute
import com.ustadmobile.core.db.dao.xapi.ActivityLangMapEntryDao
import com.ustadmobile.core.db.dao.xapi.ActivityLangMapEntryDao_KtorRoute
import com.ustadmobile.core.db.dao.xapi.StateEntityDao
import com.ustadmobile.core.db.dao.xapi.StateEntityDao_KtorRoute
import com.ustadmobile.core.db.dao.xapi.StatementDao
import com.ustadmobile.core.db.dao.xapi.StatementDao_KtorRoute
import com.ustadmobile.core.db.dao.xapi.XapiSessionEntityDao
import com.ustadmobile.core.db.dao.xapi.XapiSessionEntityDao_KtorRoute
import com.ustadmobile.door.http.DbAndDao
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDbAdapter
import com.ustadmobile.door.ktor.routes.ReplicationRoute
import com.ustadmobile.door.replication.DoorRepositoryReplicationClient
import io.ktor.server.routing.Route
import io.ktor.server.routing.route

public fun Route.UmAppDatabase_KtorRoute(serverConfig: DoorHttpServerConfig,
    dbCallAdapter: KtorCallDbAdapter<UmAppDatabase>) {
  route(DoorRepositoryReplicationClient.REPLICATION_PATH) {
    ReplicationRoute(serverConfig, dbCallAdapter)
  }
  route("PersonDao") {
    PersonDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PersonDao>(it, it.personDao()) }
      }
    )
  }
  route("ClazzDao") {
    ClazzDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzDao>(it, it.clazzDao()) }
      }
    )
  }
  route("CourseBlockDao") {
    CourseBlockDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseBlockDao>(it, it.courseBlockDao()) }
      }
    )
  }
  route("CourseTerminologyDao") {
    CourseTerminologyDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseTerminologyDao>(it,
            it.courseTerminologyDao()) }
      }
    )
  }
  route("CourseGroupSetDao") {
    CourseGroupSetDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseGroupSetDao>(it, it.courseGroupSetDao()) }
      }
    )
  }
  route("CourseGroupMemberDao") {
    CourseGroupMemberDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseGroupMemberDao>(it,
            it.courseGroupMemberDao()) }
      }
    )
  }
  route("ClazzEnrolmentDao") {
    ClazzEnrolmentDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzEnrolmentDao>(it, it.clazzEnrolmentDao()) }
      }
    )
  }
  route("ContentEntryDao") {
    ContentEntryDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ContentEntryDao>(it, it.contentEntryDao()) }
      }
    )
  }
  route("PersonPictureDao") {
    PersonPictureDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PersonPictureDao>(it, it.personPictureDao()) }
      }
    )
  }
  route("ReportDao") {
    ReportDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ReportDao>(it, it.reportDao()) }
      }
    )
  }
  route("StatementDao") {
    StatementDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<StatementDao>(it, it.statementDao()) }
      }
    )
  }
  route("ClazzLogAttendanceRecordDao") {
    ClazzLogAttendanceRecordDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzLogAttendanceRecordDao>(it,
            it.clazzLogAttendanceRecordDao()) }
      }
    )
  }
  route("ClazzLogDao") {
    ClazzLogDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzLogDao>(it, it.clazzLogDao()) }
      }
    )
  }
  route("ClazzAssignmentDao") {
    ClazzAssignmentDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzAssignmentDao>(it, it.clazzAssignmentDao())
            }
      }
    )
  }
  route("CourseAssignmentSubmissionDao") {
    CourseAssignmentSubmissionDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseAssignmentSubmissionDao>(it,
            it.courseAssignmentSubmissionDao()) }
      }
    )
  }
  route("CourseAssignmentSubmissionFileDao") {
    CourseAssignmentSubmissionFileDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseAssignmentSubmissionFileDao>(it,
            it.courseAssignmentSubmissionFileDao()) }
      }
    )
  }
  route("CourseAssignmentMarkDao") {
    CourseAssignmentMarkDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CourseAssignmentMarkDao>(it,
            it.courseAssignmentMarkDao()) }
      }
    )
  }
  route("CommentsDao") {
    CommentsDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CommentsDao>(it, it.commentsDao()) }
      }
    )
  }
  route("SiteDao") {
    SiteDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<SiteDao>(it, it.siteDao()) }
      }
    )
  }
  route("SiteTermsDao") {
    SiteTermsDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<SiteTermsDao>(it, it.siteTermsDao()) }
      }
    )
  }
  route("PersonParentJoinDao") {
    PersonParentJoinDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PersonParentJoinDao>(it,
            it.personParentJoinDao()) }
      }
    )
  }
  route("PersonAuth2Dao") {
    PersonAuth2Dao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PersonAuth2Dao>(it, it.personAuth2Dao()) }
      }
    )
  }
  route("MessageDao") {
    MessageDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<MessageDao>(it, it.messageDao()) }
      }
    )
  }
  route("PeerReviewerAllocationDao") {
    PeerReviewerAllocationDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PeerReviewerAllocationDao>(it,
            it.peerReviewerAllocationDao()) }
      }
    )
  }
  route("DiscussionPostDao") {
    DiscussionPostDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<DiscussionPostDao>(it, it.discussionPostDao()) }
      }
    )
  }
  route("ContentEntryVersionDao") {
    ContentEntryVersionDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ContentEntryVersionDao>(it,
            it.contentEntryVersionDao()) }
      }
    )
  }
  route("DeletedItemDao") {
    DeletedItemDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<DeletedItemDao>(it, it.deletedItemDao()) }
      }
    )
  }
  route("EnrolmentRequestDao") {
    EnrolmentRequestDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<EnrolmentRequestDao>(it,
            it.enrolmentRequestDao()) }
      }
    )
  }
  route("CoursePermissionDao") {
    CoursePermissionDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<CoursePermissionDao>(it,
            it.coursePermissionDao()) }
      }
    )
  }
  route("SystemPermissionDao") {
    SystemPermissionDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<SystemPermissionDao>(it,
            it.systemPermissionDao()) }
      }
    )
  }
  route("StudentResultDao") {
    StudentResultDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<StudentResultDao>(it, it.studentResultDao()) }
      }
    )
  }
  route("ActivityLangMapEntryDao") {
    ActivityLangMapEntryDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ActivityLangMapEntryDao>(it,
            it.activityLangMapEntryDao()) }
      }
    )
  }
  route("XapiSessionEntityDao") {
    XapiSessionEntityDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<XapiSessionEntityDao>(it,
            it.xapiSessionEntityDao()) }
      }
    )
  }
  route("PersonPasskeyDao") {
    PersonPasskeyDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<PersonPasskeyDao>(it, it.personPasskeyDao()) }
      }
    )
  }
  route("StateEntityDao") {
    StateEntityDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<StateEntityDao>(it, it.stateEntityDao()) }
      }
    )
  }
  route("ClazzInviteDao") {
    ClazzInviteDao_KtorRoute(
      serverConfig = serverConfig,
      daoCallAdapter =  {
        call -> dbCallAdapter(call).let { DbAndDao<ClazzInviteDao>(it, it.clazzInviteDao()) }
      }
    )
  }
}
