package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzAssignment
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.CourseAssignmentMark
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission
import com.ustadmobile.lib.db.entities.CourseBlock
import com.ustadmobile.lib.db.entities.CourseBlockPicture
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.CourseGroupSet
import com.ustadmobile.lib.db.entities.CoursePermission
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import com.ustadmobile.lib.db.entities.SystemPermission
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzAssignmentDao.getAssignmentSubmitterSummaryListForAssignment_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_group : String = request.queryParam("group")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _arg_searchText : String = request.queryParam("searchText")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _arg_sortOption : Int = request.queryParam("sortOption")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_getAssignmentSubmitterSummaryListForAssignment_pagingSource =
      getAssignmentSubmitterSummaryListForAssignment(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
    group = _arg_group,
    searchText = _arg_searchText,
    sortOption = _arg_sortOption,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_getAssignmentSubmitterSummaryListForAssignment =
      _result_getAssignmentSubmitterSummaryListForAssignment_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_getAssignmentSubmitterSummaryListForAssignment_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_getAssignmentSubmitterSummaryListForAssignment_pagingSource.endOfPaginationReached

  val _result_personHasPermissionWithClazzEntities2 =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUidEntities =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUidEntities(
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findByUidAsync = findByUidAsync(
    uid = _arg_assignmentUid,
  )
  val _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).findEnrolmentsAndPersonByClazzUidWithPermissionCheck(
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_getCourseGroupMembersByAssignmentUid = getCourseGroupMembersByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
  )
  val _result_getAssignmentSubmissionsByAssignmentUid = getAssignmentSubmissionsByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
    group = _arg_group,
  )
  val _result_getAssignmentMarksByAssignmentUid = getAssignmentMarksByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
    group = _arg_group,
  )
  val _result_getPeerReviewerAllocationsByAssignmentUid = getPeerReviewerAllocationsByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUidEntities.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.enrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_getCourseGroupMembersByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_getAssignmentSubmissionsByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 522,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentSubmission.serializer(),
              _row).jsonObject,
        )
      }
    )
    addAll(
      _result_getAssignmentMarksByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 523,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentMark.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_getPeerReviewerAllocationsByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 140,
          orUid = 0,
          entity = json.encodeToJsonElement(PeerReviewerAllocation.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzAssignmentDao.getSubmitterUidsAndNameByClazzOrGroupSetUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_groupSetUid : Long = request.queryParam("groupSetUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_date : Long = request.queryParam("date")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_groupStr : String = request.queryParam("groupStr")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _result_getAllClazzEnrolledAtTimeAsync =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).getAllClazzEnrolledAtTimeAsync(
    clazzUid = _arg_clazzUid,
    date = _arg_date,
    roleFilter = 1000,
    personUidFilter = 0,
  )
  val _result_findByGroupSetUidAsync =
      request.db.doorWrapper.getDaoByClass(CourseGroupMemberDao::class).findByGroupSetUidAsync(
    groupSetUid = _arg_groupSetUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getAllClazzEnrolledAtTimeAsync.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_getAllClazzEnrolledAtTimeAsync.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByGroupSetUidAsync.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzAssignmentDao.getSubmitterUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsync = findByUidAsync(
    uid = _arg_assignmentUid,
  )
  val _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).findEnrolmentsAndPersonByClazzUidWithPermissionCheck(
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findCourseGroupMembersByPersonUidAndAssignmentUid =
      findCourseGroupMembersByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.enrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findEnrolmentsAndPersonByClazzUidWithPermissionCheck.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findCourseGroupMembersByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzAssignmentDao.findByUidAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsync = findByUidAsync(
    uid = _arg_uid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzAssignmentDao.findByUidAndClazzUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAndClazzUidAsFlow = findByUidAndClazzUidAsFlow(
    uid = _arg_uid,
    clazzUid = _arg_clazzUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAndClazzUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzAssignmentDao.findByUidWithBlockAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidWithBlockAsync = findByUidWithBlockAsync(
    uid = _arg_uid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidWithBlockAsync?.assignment?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidWithBlockAsync?.block?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzAssignmentDao.findAssignmentCourseBlockAndSubmitterUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAssignmentCourseBlockAndSubmitterUidAsFlow =
      findAssignmentCourseBlockAndSubmitterUidAsFlow(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  ).first()
  val _result_findEnrolmentsByPersonUidAndAssignmentUid = findEnrolmentsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findCourseGroupMembersByPersonUidAndAssignmentUid =
      findCourseGroupMembersByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid =
      findPeerReviewerAllocationsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_personHasPermissionWithClazzEntities2 =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUidEntities =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUidEntities(
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findAssignmentCourseBlockAndSubmitterUidAsFlow?.clazzAssignment?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findAssignmentCourseBlockAndSubmitterUidAsFlow?.courseBlock?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findAssignmentCourseBlockAndSubmitterUidAsFlow?.courseBlockPicture?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6_677,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findAssignmentCourseBlockAndSubmitterUidAsFlow?.courseGroupSet?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 242,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupSet.serializer(), _row).jsonObject,
        )
      )
    }
    addAll(
      _result_findEnrolmentsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findCourseGroupMembersByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 140,
          orUid = 0,
          entity = json.encodeToJsonElement(PeerReviewerAllocation.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUidEntities.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
