/*
 * Decompiled with CFR 0.152.
 */
package androidx.arch.core.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.arch.core.internal.SafeIterableMap;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class FastSafeIterableMap<K, V>
extends SafeIterableMap<K, V> {
    private final HashMap<K, SafeIterableMap.Entry<K, V>> mHashMap = new HashMap();

    @Override
    @Nullable
    protected SafeIterableMap.Entry<K, V> get(K k) {
        return this.mHashMap.get(k);
    }

    @Override
    public V putIfAbsent(@NonNull K key2, @NonNull V v) {
        SafeIterableMap.Entry<K, V> current = this.get(key2);
        if (current != null) {
            return current.mValue;
        }
        this.mHashMap.put(key2, this.put(key2, v));
        return null;
    }

    @Override
    public V remove(@NonNull K key2) {
        Object removed = super.remove(key2);
        this.mHashMap.remove(key2);
        return removed;
    }

    public boolean contains(K key2) {
        return this.mHashMap.containsKey(key2);
    }

    @Nullable
    public Map.Entry<K, V> ceil(K k) {
        if (this.contains(k)) {
            return this.mHashMap.get(k).mPrevious;
        }
        return null;
    }
}

