/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class NanoHTTPD {
    private static final String CONTENT_DISPOSITION_REGEX = "([ |\t]*Content-Disposition[ |\t]*:)(.*)";
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("([ |\t]*Content-Disposition[ |\t]*:)(.*)", 2);
    private static final String CONTENT_TYPE_REGEX = "([ |\t]*content-type[ |\t]*:)(.*)";
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("([ |\t]*content-type[ |\t]*:)(.*)", 2);
    private static final String CONTENT_DISPOSITION_ATTRIBUTE_REGEX = "[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]";
    private static final Pattern CONTENT_DISPOSITION_ATTRIBUTE_PATTERN = Pattern.compile("[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]");
    public static final int SOCKET_READ_TIMEOUT = 5000;
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    private static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";
    private static final Logger LOG = Logger.getLogger(NanoHTTPD.class.getName());
    protected static Map<String, String> MIME_TYPES;
    private final String hostname;
    private final int myPort;
    private volatile ServerSocket myServerSocket;
    private ServerSocketFactory serverSocketFactory = new DefaultServerSocketFactory();
    private Thread myThread;
    protected AsyncRunner asyncRunner;
    private TempFileManagerFactory tempFileManagerFactory;

    public static Map<String, String> mimeTypes() {
        if (MIME_TYPES == null) {
            MIME_TYPES = new HashMap<String, String>();
            NanoHTTPD.loadMimeTypes(MIME_TYPES, "META-INF/nanohttpd/default-mimetypes.properties");
            NanoHTTPD.loadMimeTypes(MIME_TYPES, "META-INF/nanohttpd/mimetypes.properties");
            if (MIME_TYPES.isEmpty()) {
                LOG.log(Level.WARNING, "no mime types found in the classpath! please provide mimetypes.properties");
            }
        }
        return MIME_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMimeTypes(Map<String, String> result2, String resourceName) {
        try {
            Enumeration<URL> resources2 = NanoHTTPD.class.getClassLoader().getResources(resourceName);
            while (resources2.hasMoreElements()) {
                URL url2 = resources2.nextElement();
                Properties properties2 = new Properties();
                InputStream stream = null;
                try {
                    stream = url2.openStream();
                    properties2.load(stream);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "could not load mimetypes from " + url2, e);
                }
                finally {
                    NanoHTTPD.safeClose(stream);
                }
                result2.putAll(properties2);
            }
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "no mime types available at " + resourceName);
        }
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManager[] keyManagers) throws IOException {
        SSLServerSocketFactory res = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(loadedKeyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
            res = ctx.getServerSocketFactory();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return res;
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManagerFactory loadedKeyFactory) throws IOException {
        try {
            return NanoHTTPD.makeSSLSocketFactory(loadedKeyStore, loadedKeyFactory.getKeyManagers());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(String keyAndTrustStoreClasspathPath, char[] passphrase) throws IOException {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream keystoreStream = NanoHTTPD.class.getResourceAsStream(keyAndTrustStoreClasspathPath);
            if (keystoreStream == null) {
                throw new IOException("Unable to load keystore from classpath: " + keyAndTrustStoreClasspathPath);
            }
            keystore.load(keystoreStream, passphrase);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, passphrase);
            return NanoHTTPD.makeSSLSocketFactory(keystore, keyManagerFactory);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String getMimeTypeForFile(String uri2) {
        int dot = uri2.lastIndexOf(46);
        String mime = null;
        if (dot >= 0) {
            mime = NanoHTTPD.mimeTypes().get(uri2.substring(dot + 1).toLowerCase());
        }
        return mime == null ? "application/octet-stream" : mime;
    }

    private static final void safeClose(Object closeable) {
        block5: {
            try {
                if (closeable == null) break block5;
                if (closeable instanceof Closeable) {
                    ((Closeable)closeable).close();
                    break block5;
                }
                if (closeable instanceof Socket) {
                    ((Socket)closeable).close();
                    break block5;
                }
                if (closeable instanceof ServerSocket) {
                    ((ServerSocket)closeable).close();
                    break block5;
                }
                throw new IllegalArgumentException("Unknown object to close");
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not close", e);
            }
        }
    }

    public NanoHTTPD(int port2) {
        this(null, port2);
    }

    public NanoHTTPD(String hostname, int port2) {
        this.hostname = hostname;
        this.myPort = port2;
        this.setTempFileManagerFactory(new DefaultTempFileManagerFactory());
        this.setAsyncRunner(new DefaultAsyncRunner());
    }

    public synchronized void closeAllConnections() {
        this.stop();
    }

    protected ClientHandler createClientHandler(Socket finalAccept, InputStream inputStream2) {
        return new ClientHandler(inputStream2, finalAccept);
    }

    protected ServerRunnable createServerRunnable(int timeout2) {
        return new ServerRunnable(timeout2);
    }

    protected static Map<String, List<String>> decodeParameters(Map<String, String> parms) {
        return NanoHTTPD.decodeParameters(parms.get(QUERY_STRING_PARAMETER));
    }

    protected static Map<String, List<String>> decodeParameters(String queryString) {
        HashMap<String, List<String>> parms = new HashMap<String, List<String>>();
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String propertyValue;
                String propertyName;
                String e = st.nextToken();
                int sep = e.indexOf(61);
                String string = propertyName = sep >= 0 ? NanoHTTPD.decodePercent(e.substring(0, sep)).trim() : NanoHTTPD.decodePercent(e).trim();
                if (!parms.containsKey(propertyName)) {
                    parms.put(propertyName, new ArrayList());
                }
                if ((propertyValue = sep >= 0 ? NanoHTTPD.decodePercent(e.substring(sep + 1)) : null) == null) continue;
                ((List)parms.get(propertyName)).add(propertyValue);
            }
        }
        return parms;
    }

    protected static String decodePercent(String str) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(str, "UTF8");
        }
        catch (UnsupportedEncodingException ignored) {
            LOG.log(Level.WARNING, "Encoding not supported, ignored", ignored);
        }
        return decoded;
    }

    protected boolean useGzipWhenAccepted(Response r) {
        return r.getMimeType() != null && (r.getMimeType().toLowerCase().contains("text/") || r.getMimeType().toLowerCase().contains("/json"));
    }

    public final int getListeningPort() {
        return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean isAlive() {
        return this.wasStarted() && !this.myServerSocket.isClosed() && this.myThread.isAlive();
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public String getHostname() {
        return this.hostname;
    }

    public TempFileManagerFactory getTempFileManagerFactory() {
        return this.tempFileManagerFactory;
    }

    public void makeSecure(SSLServerSocketFactory sslServerSocketFactory, String[] sslProtocols) {
        this.serverSocketFactory = new SecureServerSocketFactory(sslServerSocketFactory, sslProtocols);
    }

    public static Response newChunkedResponse(Response.IStatus status, String mimeType, InputStream data2) {
        return new Response(status, mimeType, data2, -1L);
    }

    public static Response newFixedLengthResponse(Response.IStatus status, String mimeType, InputStream data2, long totalBytes) {
        return new Response(status, mimeType, data2, totalBytes);
    }

    public static Response newFixedLengthResponse(Response.IStatus status, String mimeType, String txt) {
        byte[] bytes;
        ContentType contentType2 = new ContentType(mimeType);
        if (txt == null) {
            return NanoHTTPD.newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(new byte[0]), 0L);
        }
        try {
            CharsetEncoder newEncoder = Charset.forName(contentType2.getEncoding()).newEncoder();
            if (!newEncoder.canEncode(txt)) {
                contentType2 = contentType2.tryUTF8();
            }
            bytes = txt.getBytes(contentType2.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "encoding problem, responding nothing", e);
            bytes = new byte[]{};
        }
        return NanoHTTPD.newFixedLengthResponse(status, contentType2.getContentTypeHeader(), new ByteArrayInputStream(bytes), bytes.length);
    }

    public static Response newFixedLengthResponse(String msg) {
        return NanoHTTPD.newFixedLengthResponse(Response.Status.OK, MIME_HTML, msg);
    }

    public Response serve(IHTTPSession session2) {
        HashMap<String, String> files2 = new HashMap<String, String>();
        Method method2 = session2.getMethod();
        if (Method.PUT.equals((Object)method2) || Method.POST.equals((Object)method2)) {
            try {
                session2.parseBody(files2);
            }
            catch (IOException ioe) {
                return NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
            catch (ResponseException re) {
                return NanoHTTPD.newFixedLengthResponse(re.getStatus(), MIME_PLAINTEXT, re.getMessage());
            }
        }
        Map<String, String> parms = session2.getParms();
        parms.put(QUERY_STRING_PARAMETER, session2.getQueryParameterString());
        return this.serve(session2.getUri(), method2, session2.getHeaders(), parms, files2);
    }

    @Deprecated
    public Response serve(String uri2, Method method2, Map<String, String> headers2, Map<String, String> parms, Map<String, String> files2) {
        return NanoHTTPD.newFixedLengthResponse(Response.Status.NOT_FOUND, MIME_PLAINTEXT, "Not Found");
    }

    public void setAsyncRunner(AsyncRunner asyncRunner) {
        this.asyncRunner = asyncRunner;
    }

    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
        this.tempFileManagerFactory = tempFileManagerFactory;
    }

    public void start() throws IOException {
        this.start(5000);
    }

    public void start(int timeout2) throws IOException {
        this.start(timeout2, true);
    }

    public void start(int timeout2, boolean daemon) throws IOException {
        this.myServerSocket = this.getServerSocketFactory().create();
        this.myServerSocket.setReuseAddress(true);
        ServerRunnable serverRunnable = this.createServerRunnable(timeout2);
        this.myThread = new Thread(serverRunnable);
        this.myThread.setDaemon(daemon);
        this.myThread.setName("NanoHttpd Main Listener");
        this.myThread.start();
        while (!serverRunnable.hasBinded && serverRunnable.bindException == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable e) {}
        }
        if (serverRunnable.bindException != null) {
            throw serverRunnable.bindException;
        }
    }

    public void stop() {
        try {
            NanoHTTPD.safeClose(this.myServerSocket);
            this.asyncRunner.closeAll();
            if (this.myThread != null) {
                this.myThread.join();
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not stop all connections", e);
        }
    }

    public final boolean wasStarted() {
        return this.myServerSocket != null && this.myThread != null;
    }

    public static interface ServerSocketFactory {
        public ServerSocket create() throws IOException;
    }

    public static interface TempFileManagerFactory {
        public TempFileManager create();
    }

    public static interface TempFileManager {
        public void clear();

        public TempFile createTempFile(String var1) throws Exception;
    }

    public static interface TempFile {
        public void delete() throws Exception;

        public String getName();

        public OutputStream open() throws Exception;
    }

    public class ServerRunnable
    implements Runnable {
        private final int timeout;
        private IOException bindException;
        private boolean hasBinded = false;

        public ServerRunnable(int timeout2) {
            this.timeout = timeout2;
        }

        @Override
        public void run() {
            try {
                NanoHTTPD.this.myServerSocket.bind(NanoHTTPD.this.hostname != null ? new InetSocketAddress(NanoHTTPD.this.hostname, NanoHTTPD.this.myPort) : new InetSocketAddress(NanoHTTPD.this.myPort));
                this.hasBinded = true;
            }
            catch (IOException e) {
                this.bindException = e;
                return;
            }
            do {
                try {
                    Socket finalAccept = NanoHTTPD.this.myServerSocket.accept();
                    if (this.timeout > 0) {
                        finalAccept.setSoTimeout(this.timeout);
                    }
                    InputStream inputStream2 = finalAccept.getInputStream();
                    NanoHTTPD.this.asyncRunner.exec(NanoHTTPD.this.createClientHandler(finalAccept, inputStream2));
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "Communication with the client broken", e);
                }
            } while (!NanoHTTPD.this.myServerSocket.isClosed());
        }
    }

    public static final class ResponseException
    extends Exception {
        private static final long serialVersionUID = 6569838532917408380L;
        private final Response.Status status;

        public ResponseException(Response.Status status, String message) {
            super(message);
            this.status = status;
        }

        public ResponseException(Response.Status status, String message, Exception e) {
            super(message, e);
            this.status = status;
        }

        public Response.Status getStatus() {
            return this.status;
        }
    }

    public static class Response
    implements Closeable {
        private IStatus status;
        private String mimeType;
        private InputStream data;
        private long contentLength;
        private final Map<String, String> header = new HashMap<String, String>(){

            @Override
            public String put(String key2, String value) {
                Response.this.lowerCaseHeader.put(key2 == null ? key2 : key2.toLowerCase(), value);
                return super.put(key2, value);
            }
        };
        private final Map<String, String> lowerCaseHeader = new HashMap<String, String>();
        private Method requestMethod;
        private boolean chunkedTransfer;
        private boolean encodeAsGzip;
        private boolean keepAlive;

        protected Response(IStatus status, String mimeType, InputStream data2, long totalBytes) {
            this.status = status;
            this.mimeType = mimeType;
            if (data2 == null) {
                this.data = new ByteArrayInputStream(new byte[0]);
                this.contentLength = 0L;
            } else {
                this.data = data2;
                this.contentLength = totalBytes;
            }
            this.chunkedTransfer = this.contentLength < 0L;
            this.keepAlive = true;
        }

        @Override
        public void close() throws IOException {
            if (this.data != null) {
                this.data.close();
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        public void closeConnection(boolean close2) {
            if (close2) {
                this.header.put("connection", "close");
            } else {
                this.header.remove("connection");
            }
        }

        public boolean isCloseConnection() {
            return "close".equals(this.getHeader("connection"));
        }

        public InputStream getData() {
            return this.data;
        }

        public String getHeader(String name) {
            return this.lowerCaseHeader.get(name.toLowerCase());
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Method getRequestMethod() {
            return this.requestMethod;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setGzipEncoding(boolean encodeAsGzip) {
            this.encodeAsGzip = encodeAsGzip;
        }

        public void setKeepAlive(boolean useKeepAlive) {
            this.keepAlive = useKeepAlive;
        }

        protected void send(OutputStream outputStream2) {
            SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                long pending;
                if (this.status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream2, new ContentType(this.mimeType).getEncoding())), false);
                pw.append("HTTP/1.1 ").append(this.status.getDescription()).append(" \r\n");
                if (this.mimeType != null) {
                    this.printHeader(pw, "Content-Type", this.mimeType);
                }
                if (this.getHeader("date") == null) {
                    this.printHeader(pw, "Date", gmtFrmt.format(new Date()));
                }
                for (Map.Entry<String, String> entry : this.header.entrySet()) {
                    this.printHeader(pw, entry.getKey(), entry.getValue());
                }
                if (this.getHeader("connection") == null) {
                    this.printHeader(pw, "Connection", this.keepAlive ? "keep-alive" : "close");
                }
                if (this.getHeader("content-length") != null) {
                    this.encodeAsGzip = false;
                }
                if (this.encodeAsGzip) {
                    this.printHeader(pw, "Content-Encoding", "gzip");
                    this.setChunkedTransfer(true);
                }
                long l = pending = this.data != null ? this.contentLength : 0L;
                if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                    this.printHeader(pw, "Transfer-Encoding", "chunked");
                } else if (!this.encodeAsGzip) {
                    pending = this.sendContentLengthHeaderIfNotAlreadyPresent(pw, pending);
                }
                pw.append("\r\n");
                pw.flush();
                this.sendBodyWithCorrectTransferAndEncoding(outputStream2, pending);
                outputStream2.flush();
                NanoHTTPD.safeClose(this.data);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Could not send response to the client", ioe);
            }
        }

        protected void printHeader(PrintWriter pw, String key2, String value) {
            pw.append(key2).append(": ").append(value).append("\r\n");
        }

        protected long sendContentLengthHeaderIfNotAlreadyPresent(PrintWriter pw, long defaultSize) {
            String contentLengthString = this.getHeader("content-length");
            long size2 = defaultSize;
            if (contentLengthString != null) {
                try {
                    size2 = Long.parseLong(contentLengthString);
                }
                catch (NumberFormatException ex) {
                    LOG.severe("content-length was no number " + contentLengthString);
                }
            }
            pw.print("Content-Length: " + size2 + "\r\n");
            return size2;
        }

        private void sendBodyWithCorrectTransferAndEncoding(OutputStream outputStream2, long pending) throws IOException {
            if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream2);
                this.sendBodyWithCorrectEncoding(chunkedOutputStream, -1L);
                chunkedOutputStream.finish();
            } else {
                this.sendBodyWithCorrectEncoding(outputStream2, pending);
            }
        }

        private void sendBodyWithCorrectEncoding(OutputStream outputStream2, long pending) throws IOException {
            if (this.encodeAsGzip) {
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream2);
                this.sendBody(gzipOutputStream, -1L);
                gzipOutputStream.finish();
            } else {
                this.sendBody(outputStream2, pending);
            }
        }

        private void sendBody(OutputStream outputStream2, long pending) throws IOException {
            long bytesToRead;
            int read2;
            boolean sendEverything;
            long BUFFER_SIZE = 16384L;
            byte[] buff = new byte[(int)BUFFER_SIZE];
            boolean bl = sendEverything = pending == -1L;
            while ((pending > 0L || sendEverything) && (read2 = this.data.read(buff, 0, (int)(bytesToRead = sendEverything ? BUFFER_SIZE : Math.min(pending, BUFFER_SIZE)))) > 0) {
                outputStream2.write(buff, 0, read2);
                if (sendEverything) continue;
                pending -= (long)read2;
            }
        }

        public void setChunkedTransfer(boolean chunkedTransfer) {
            this.chunkedTransfer = chunkedTransfer;
        }

        public void setData(InputStream data2) {
            this.data = data2;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setRequestMethod(Method requestMethod) {
            this.requestMethod = requestMethod;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }

        private static class ChunkedOutputStream
        extends FilterOutputStream {
            public ChunkedOutputStream(OutputStream out2) {
                super(out2);
            }

            @Override
            public void write(int b2) throws IOException {
                byte[] data2 = new byte[]{(byte)b2};
                this.write(data2, 0, 1);
            }

            @Override
            public void write(byte[] b2) throws IOException {
                this.write(b2, 0, b2.length);
            }

            @Override
            public void write(byte[] b2, int off, int len) throws IOException {
                if (len == 0) {
                    return;
                }
                this.out.write(String.format("%x\r\n", len).getBytes());
                this.out.write(b2, off, len);
                this.out.write("\r\n".getBytes());
            }

            public void finish() throws IOException {
                this.out.write("0\r\n\r\n".getBytes());
            }
        }

        public static enum Status implements IStatus
        {
            SWITCH_PROTOCOL(101, "Switching Protocols"),
            OK(200, "OK"),
            CREATED(201, "Created"),
            ACCEPTED(202, "Accepted"),
            NO_CONTENT(204, "No Content"),
            PARTIAL_CONTENT(206, "Partial Content"),
            MULTI_STATUS(207, "Multi-Status"),
            REDIRECT(301, "Moved Permanently"),
            FOUND(302, "Found"),
            REDIRECT_SEE_OTHER(303, "See Other"),
            NOT_MODIFIED(304, "Not Modified"),
            TEMPORARY_REDIRECT(307, "Temporary Redirect"),
            BAD_REQUEST(400, "Bad Request"),
            UNAUTHORIZED(401, "Unauthorized"),
            FORBIDDEN(403, "Forbidden"),
            NOT_FOUND(404, "Not Found"),
            METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
            NOT_ACCEPTABLE(406, "Not Acceptable"),
            REQUEST_TIMEOUT(408, "Request Timeout"),
            CONFLICT(409, "Conflict"),
            GONE(410, "Gone"),
            LENGTH_REQUIRED(411, "Length Required"),
            PRECONDITION_FAILED(412, "Precondition Failed"),
            PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
            UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
            RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
            EXPECTATION_FAILED(417, "Expectation Failed"),
            TOO_MANY_REQUESTS(429, "Too Many Requests"),
            INTERNAL_ERROR(500, "Internal Server Error"),
            NOT_IMPLEMENTED(501, "Not Implemented"),
            SERVICE_UNAVAILABLE(503, "Service Unavailable"),
            UNSUPPORTED_HTTP_VERSION(505, "HTTP Version Not Supported");

            private final int requestStatus;
            private final String description;

            private Status(int requestStatus, String description2) {
                this.requestStatus = requestStatus;
                this.description = description2;
            }

            public static Status lookup(int requestStatus) {
                for (Status status : Status.values()) {
                    if (status.getRequestStatus() != requestStatus) continue;
                    return status;
                }
                return null;
            }

            @Override
            public String getDescription() {
                return "" + this.requestStatus + " " + this.description;
            }

            @Override
            public int getRequestStatus() {
                return this.requestStatus;
            }
        }

        public static interface IStatus {
            public String getDescription();

            public int getRequestStatus();
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        CONNECT,
        PATCH,
        PROPFIND,
        PROPPATCH,
        MKCOL,
        MOVE,
        COPY,
        LOCK,
        UNLOCK;


        static Method lookup(String method2) {
            if (method2 == null) {
                return null;
            }
            try {
                return Method.valueOf(method2);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static interface IHTTPSession {
        public void execute() throws IOException;

        public CookieHandler getCookies();

        public Map<String, String> getHeaders();

        public InputStream getInputStream();

        public Method getMethod();

        @Deprecated
        public Map<String, String> getParms();

        public Map<String, List<String>> getParameters();

        public String getQueryParameterString();

        public String getUri();

        public void parseBody(Map<String, String> var1) throws IOException, ResponseException;

        public String getRemoteIpAddress();

        public String getRemoteHostName();
    }

    protected class HTTPSession
    implements IHTTPSession {
        private static final int REQUEST_BUFFER_LEN = 512;
        private static final int MEMORY_STORE_LIMIT = 1024;
        public static final int BUFSIZE = 8192;
        public static final int MAX_HEADER_SIZE = 1024;
        private final TempFileManager tempFileManager;
        private final OutputStream outputStream;
        private final BufferedInputStream inputStream;
        private int splitbyte;
        private int rlen;
        private String uri;
        private Method method;
        private Map<String, List<String>> parms;
        private Map<String, String> headers;
        private CookieHandler cookies;
        private String queryParameterString;
        private String remoteIp;
        private String remoteHostname;
        private String protocolVersion;

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream2, OutputStream outputStream2) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new BufferedInputStream(inputStream2, 8192);
            this.outputStream = outputStream2;
        }

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream2, OutputStream outputStream2, InetAddress inetAddress) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new BufferedInputStream(inputStream2, 8192);
            this.outputStream = outputStream2;
            this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
            this.remoteHostname = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "localhost" : inetAddress.getHostName().toString();
            this.headers = new HashMap<String, String>();
        }

        private void decodeHeader(BufferedReader in, Map<String, String> pre2, Map<String, List<String>> parms, Map<String, String> headers2) throws ResponseException {
            try {
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                pre2.put("method", st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String uri2 = st.nextToken();
                int qmi = uri2.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri2.substring(qmi + 1), parms);
                    uri2 = NanoHTTPD.decodePercent(uri2.substring(0, qmi));
                } else {
                    uri2 = NanoHTTPD.decodePercent(uri2);
                }
                if (st.hasMoreTokens()) {
                    this.protocolVersion = st.nextToken();
                } else {
                    this.protocolVersion = "HTTP/1.1";
                    LOG.log(Level.FINE, "no protocol version specified, strange. Assuming HTTP/1.1.");
                }
                String line = in.readLine();
                while (line != null && !line.trim().isEmpty()) {
                    int p2 = line.indexOf(58);
                    if (p2 >= 0) {
                        headers2.put(line.substring(0, p2).trim().toLowerCase(Locale.US), line.substring(p2 + 1).trim());
                    }
                    line = in.readLine();
                }
                pre2.put("uri", uri2);
            }
            catch (IOException ioe) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
            }
        }

        private void decodeMultipartFormData(ContentType contentType2, ByteBuffer fbuf, Map<String, List<String>> parms, Map<String, String> files2) throws ResponseException {
            int pcount = 0;
            try {
                int[] boundaryIdxs = this.getBoundaryPositions(fbuf, contentType2.getBoundary().getBytes());
                if (boundaryIdxs.length < 2) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but contains less than two boundary strings.");
                }
                byte[] partHeaderBuff = new byte[1024];
                for (int boundaryIdx = 0; boundaryIdx < boundaryIdxs.length - 1; ++boundaryIdx) {
                    fbuf.position(boundaryIdxs[boundaryIdx]);
                    int len = fbuf.remaining() < 1024 ? fbuf.remaining() : 1024;
                    fbuf.get(partHeaderBuff, 0, len);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(partHeaderBuff, 0, len), Charset.forName(contentType2.getEncoding())), len);
                    int headerLines = 0;
                    String mpline = in.readLine();
                    ++headerLines;
                    if (mpline == null || !mpline.contains(contentType2.getBoundary())) {
                        throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but chunk does not start with boundary.");
                    }
                    String partName = null;
                    String fileName = null;
                    String partContentType = null;
                    mpline = in.readLine();
                    ++headerLines;
                    while (mpline != null && mpline.trim().length() > 0) {
                        Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(mpline);
                        if (matcher.matches()) {
                            String attributeString = matcher.group(2);
                            matcher = CONTENT_DISPOSITION_ATTRIBUTE_PATTERN.matcher(attributeString);
                            while (matcher.find()) {
                                String key2 = matcher.group(1);
                                if ("name".equalsIgnoreCase(key2)) {
                                    partName = matcher.group(2);
                                    continue;
                                }
                                if (!"filename".equalsIgnoreCase(key2) || (fileName = matcher.group(2)).isEmpty()) continue;
                                if (pcount > 0) {
                                    partName = partName + String.valueOf(pcount++);
                                    continue;
                                }
                                ++pcount;
                            }
                        }
                        if ((matcher = CONTENT_TYPE_PATTERN.matcher(mpline)).matches()) {
                            partContentType = matcher.group(2).trim();
                        }
                        mpline = in.readLine();
                        ++headerLines;
                    }
                    int partHeaderLength = 0;
                    while (headerLines-- > 0) {
                        partHeaderLength = this.scipOverNewLine(partHeaderBuff, partHeaderLength);
                    }
                    if (partHeaderLength >= len - 4) {
                        throw new ResponseException(Response.Status.INTERNAL_ERROR, "Multipart header size exceeds MAX_HEADER_SIZE.");
                    }
                    int partDataStart = boundaryIdxs[boundaryIdx] + partHeaderLength;
                    int partDataEnd = boundaryIdxs[boundaryIdx + 1] - 4;
                    fbuf.position(partDataStart);
                    List<String> values2 = parms.get(partName);
                    if (values2 == null) {
                        values2 = new ArrayList<String>();
                        parms.put(partName, values2);
                    }
                    if (partContentType == null) {
                        byte[] data_bytes = new byte[partDataEnd - partDataStart];
                        fbuf.get(data_bytes);
                        values2.add(new String(data_bytes, contentType2.getEncoding()));
                        continue;
                    }
                    String path = this.saveTmpFile(fbuf, partDataStart, partDataEnd - partDataStart, fileName);
                    if (!files2.containsKey(partName)) {
                        files2.put(partName, path);
                    } else {
                        int count2 = 2;
                        while (files2.containsKey(partName + count2)) {
                            ++count2;
                        }
                        files2.put(partName + count2, path);
                    }
                    values2.add(fileName);
                }
            }
            catch (ResponseException re) {
                throw re;
            }
            catch (Exception e) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, e.toString());
            }
        }

        private int scipOverNewLine(byte[] partHeaderBuff, int index) {
            while (partHeaderBuff[index] != 10) {
                ++index;
            }
            return ++index;
        }

        private void decodeParms(String parms, Map<String, List<String>> p2) {
            if (parms == null) {
                this.queryParameterString = "";
                return;
            }
            this.queryParameterString = parms;
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                String key2 = null;
                String value = null;
                if (sep >= 0) {
                    key2 = NanoHTTPD.decodePercent(e.substring(0, sep)).trim();
                    value = NanoHTTPD.decodePercent(e.substring(sep + 1));
                } else {
                    key2 = NanoHTTPD.decodePercent(e).trim();
                    value = "";
                }
                List<String> values2 = p2.get(key2);
                if (values2 == null) {
                    values2 = new ArrayList<String>();
                    p2.put(key2, values2);
                }
                values2.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void execute() throws IOException {
            Response r = null;
            try {
                byte[] buf = new byte[8192];
                this.splitbyte = 0;
                this.rlen = 0;
                int read2 = -1;
                this.inputStream.mark(8192);
                try {
                    read2 = this.inputStream.read(buf, 0, 8192);
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (IOException e) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                if (read2 == -1) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                while (read2 > 0) {
                    this.rlen += read2;
                    this.splitbyte = this.findHeaderEnd(buf, this.rlen);
                    if (this.splitbyte > 0) break;
                    read2 = this.inputStream.read(buf, this.rlen, 8192 - this.rlen);
                }
                if (this.splitbyte < this.rlen) {
                    this.inputStream.reset();
                    this.inputStream.skip(this.splitbyte);
                }
                this.parms = new HashMap<String, List<String>>();
                if (null == this.headers) {
                    this.headers = new HashMap<String, String>();
                } else {
                    this.headers.clear();
                }
                BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.rlen)));
                HashMap<String, String> pre2 = new HashMap<String, String>();
                this.decodeHeader(hin, pre2, this.parms, this.headers);
                if (null != this.remoteIp) {
                    this.headers.put("remote-addr", this.remoteIp);
                    this.headers.put("http-client-ip", this.remoteIp);
                }
                this.method = Method.lookup((String)pre2.get("method"));
                if (this.method == null) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. HTTP verb " + (String)pre2.get("method") + " unhandled.");
                }
                this.uri = (String)pre2.get("uri");
                this.cookies = new CookieHandler(this.headers);
                String connection = this.headers.get("connection");
                boolean keepAlive = "HTTP/1.1".equals(this.protocolVersion) && (connection == null || !connection.matches("(?i).*close.*"));
                r = NanoHTTPD.this.serve(this);
                if (r == null) {
                    throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                }
                String acceptEncoding = this.headers.get("accept-encoding");
                this.cookies.unloadQueue(r);
                r.setRequestMethod(this.method);
                r.setGzipEncoding(NanoHTTPD.this.useGzipWhenAccepted(r) && acceptEncoding != null && acceptEncoding.contains("gzip"));
                r.setKeepAlive(keepAlive);
                r.send(this.outputStream);
                if (!keepAlive) throw new SocketException("NanoHttpd Shutdown");
                if (r.isCloseConnection()) {
                    throw new SocketException("NanoHttpd Shutdown");
                }
                NanoHTTPD.safeClose(r);
                this.tempFileManager.clear();
                return;
            }
            catch (SocketException e) {
                throw e;
                catch (SocketTimeoutException ste) {
                    throw ste;
                }
                catch (SSLException ssle) {
                    Response resp = NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SSL PROTOCOL FAILURE: " + ssle.getMessage());
                    resp.send(this.outputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    return;
                }
                catch (IOException ioe) {
                    Response resp = NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                    resp.send(this.outputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (ResponseException re) {
                        resp = NanoHTTPD.newFixedLengthResponse(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
                        resp.send(this.outputStream);
                        NanoHTTPD.safeClose(this.outputStream);
                        return;
                    }
                }
            }
            finally {
                NanoHTTPD.safeClose(r);
                this.tempFileManager.clear();
            }
        }

        private int findHeaderEnd(byte[] buf, int rlen) {
            int splitbyte = 0;
            while (splitbyte + 1 < rlen) {
                if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && splitbyte + 3 < rlen && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                    return splitbyte + 4;
                }
                if (buf[splitbyte] == 10 && buf[splitbyte + 1] == 10) {
                    return splitbyte + 2;
                }
                ++splitbyte;
            }
            return 0;
        }

        private int[] getBoundaryPositions(ByteBuffer b2, byte[] boundary) {
            int[] res = new int[]{};
            if (b2.remaining() < boundary.length) {
                return res;
            }
            int search_window_pos = 0;
            byte[] search_window = new byte[4096 + boundary.length];
            int first_fill = b2.remaining() < search_window.length ? b2.remaining() : search_window.length;
            b2.get(search_window, 0, first_fill);
            int new_bytes = first_fill - boundary.length;
            do {
                for (int j = 0; j < new_bytes; ++j) {
                    for (int i2 = 0; i2 < boundary.length && search_window[j + i2] == boundary[i2]; ++i2) {
                        if (i2 != boundary.length - 1) continue;
                        int[] new_res = new int[res.length + 1];
                        System.arraycopy(res, 0, new_res, 0, res.length);
                        new_res[res.length] = search_window_pos + j;
                        res = new_res;
                    }
                }
                search_window_pos += new_bytes;
                System.arraycopy(search_window, search_window.length - boundary.length, search_window, 0, boundary.length);
                new_bytes = search_window.length - boundary.length;
                new_bytes = b2.remaining() < new_bytes ? b2.remaining() : new_bytes;
                b2.get(search_window, boundary.length, new_bytes);
            } while (new_bytes > 0);
            return res;
        }

        @Override
        public CookieHandler getCookies() {
            return this.cookies;
        }

        @Override
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public final Method getMethod() {
            return this.method;
        }

        @Override
        @Deprecated
        public final Map<String, String> getParms() {
            HashMap<String, String> result2 = new HashMap<String, String>();
            for (String key2 : this.parms.keySet()) {
                result2.put(key2, this.parms.get(key2).get(0));
            }
            return result2;
        }

        @Override
        public final Map<String, List<String>> getParameters() {
            return this.parms;
        }

        @Override
        public String getQueryParameterString() {
            return this.queryParameterString;
        }

        private RandomAccessFile getTmpBucket() {
            try {
                TempFile tempFile = this.tempFileManager.createTempFile(null);
                return new RandomAccessFile(tempFile.getName(), "rw");
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        @Override
        public final String getUri() {
            return this.uri;
        }

        public long getBodySize() {
            if (this.headers.containsKey("content-length")) {
                return Long.parseLong(this.headers.get("content-length"));
            }
            if (this.splitbyte < this.rlen) {
                return this.rlen - this.splitbyte;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parseBody(Map<String, String> files2) throws IOException, ResponseException {
            RandomAccessFile randomAccessFile = null;
            try {
                long size2 = this.getBodySize();
                ByteArrayOutputStream baos = null;
                DataOutput requestDataOutput = null;
                if (size2 < 1024L) {
                    baos = new ByteArrayOutputStream();
                    requestDataOutput = new DataOutputStream(baos);
                } else {
                    randomAccessFile = this.getTmpBucket();
                    requestDataOutput = randomAccessFile;
                }
                byte[] buf = new byte[512];
                while (this.rlen >= 0 && size2 > 0L) {
                    this.rlen = this.inputStream.read(buf, 0, (int)Math.min(size2, 512L));
                    size2 -= (long)this.rlen;
                    if (this.rlen <= 0) continue;
                    requestDataOutput.write(buf, 0, this.rlen);
                }
                ByteBuffer fbuf = null;
                if (baos != null) {
                    fbuf = ByteBuffer.wrap(baos.toByteArray(), 0, baos.size());
                } else {
                    fbuf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
                    randomAccessFile.seek(0L);
                }
                if (Method.POST.equals((Object)this.method)) {
                    ContentType contentType2 = new ContentType(this.headers.get("content-type"));
                    if (contentType2.isMultipart()) {
                        String boundary = contentType2.getBoundary();
                        if (boundary == null) {
                            throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                        }
                        this.decodeMultipartFormData(contentType2, fbuf, this.parms, files2);
                    } else {
                        byte[] postBytes = new byte[fbuf.remaining()];
                        fbuf.get(postBytes);
                        String postLine = new String(postBytes, contentType2.getEncoding()).trim();
                        if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType2.getContentType())) {
                            this.decodeParms(postLine, this.parms);
                        } else if (postLine.length() != 0) {
                            files2.put("postData", postLine);
                        }
                    }
                } else if (Method.PUT.equals((Object)this.method)) {
                    files2.put("content", this.saveTmpFile(fbuf, 0, fbuf.limit(), null));
                }
            }
            catch (Throwable throwable) {
                NanoHTTPD.safeClose(randomAccessFile);
                throw throwable;
            }
            NanoHTTPD.safeClose(randomAccessFile);
        }

        private String saveTmpFile(ByteBuffer b2, int offset, int len, String filename_hint) {
            String path = "";
            if (len > 0) {
                FileOutputStream fileOutputStream = null;
                try {
                    TempFile tempFile = this.tempFileManager.createTempFile(filename_hint);
                    ByteBuffer src = b2.duplicate();
                    fileOutputStream = new FileOutputStream(tempFile.getName());
                    FileChannel dest = fileOutputStream.getChannel();
                    src.position(offset).limit(offset + len);
                    dest.write(src.slice());
                    path = tempFile.getName();
                }
                catch (Exception e) {
                    try {
                        throw new Error(e);
                    }
                    catch (Throwable throwable) {
                        NanoHTTPD.safeClose(fileOutputStream);
                        throw throwable;
                    }
                }
                NanoHTTPD.safeClose(fileOutputStream);
            }
            return path;
        }

        @Override
        public String getRemoteIpAddress() {
            return this.remoteIp;
        }

        @Override
        public String getRemoteHostName() {
            return this.remoteHostname;
        }
    }

    protected static class ContentType {
        private static final String ASCII_ENCODING = "US-ASCII";
        private static final String MULTIPART_FORM_DATA_HEADER = "multipart/form-data";
        private static final String CONTENT_REGEX = "[ |\t]*([^/^ ^;^,]+/[^ ^;^,]+)";
        private static final Pattern MIME_PATTERN = Pattern.compile("[ |\t]*([^/^ ^;^,]+/[^ ^;^,]+)", 2);
        private static final String CHARSET_REGEX = "[ |\t]*(charset)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?";
        private static final Pattern CHARSET_PATTERN = Pattern.compile("[ |\t]*(charset)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?", 2);
        private static final String BOUNDARY_REGEX = "[ |\t]*(boundary)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?";
        private static final Pattern BOUNDARY_PATTERN = Pattern.compile("[ |\t]*(boundary)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?", 2);
        private final String contentTypeHeader;
        private final String contentType;
        private final String encoding;
        private final String boundary;

        public ContentType(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            if (contentTypeHeader != null) {
                this.contentType = this.getDetailFromContentHeader(contentTypeHeader, MIME_PATTERN, "", 1);
                this.encoding = this.getDetailFromContentHeader(contentTypeHeader, CHARSET_PATTERN, null, 2);
            } else {
                this.contentType = "";
                this.encoding = "UTF-8";
            }
            this.boundary = MULTIPART_FORM_DATA_HEADER.equalsIgnoreCase(this.contentType) ? this.getDetailFromContentHeader(contentTypeHeader, BOUNDARY_PATTERN, null, 2) : null;
        }

        private String getDetailFromContentHeader(String contentTypeHeader, Pattern pattern, String defaultValue, int group) {
            Matcher matcher = pattern.matcher(contentTypeHeader);
            return matcher.find() ? matcher.group(group) : defaultValue;
        }

        public String getContentTypeHeader() {
            return this.contentTypeHeader;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getEncoding() {
            return this.encoding == null ? ASCII_ENCODING : this.encoding;
        }

        public String getBoundary() {
            return this.boundary;
        }

        public boolean isMultipart() {
            return MULTIPART_FORM_DATA_HEADER.equalsIgnoreCase(this.contentType);
        }

        public ContentType tryUTF8() {
            if (this.encoding == null) {
                return new ContentType(this.contentTypeHeader + "; charset=UTF-8");
            }
            return this;
        }
    }

    public static class SecureServerSocketFactory
    implements ServerSocketFactory {
        private SSLServerSocketFactory sslServerSocketFactory;
        private String[] sslProtocols;

        public SecureServerSocketFactory(SSLServerSocketFactory sslServerSocketFactory, String[] sslProtocols) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            this.sslProtocols = sslProtocols;
        }

        @Override
        public ServerSocket create() throws IOException {
            SSLServerSocket ss = null;
            ss = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
            if (this.sslProtocols != null) {
                ss.setEnabledProtocols(this.sslProtocols);
            } else {
                ss.setEnabledProtocols(ss.getSupportedProtocols());
            }
            ss.setUseClientMode(false);
            ss.setWantClientAuth(false);
            ss.setNeedClientAuth(false);
            return ss;
        }
    }

    public static class DefaultServerSocketFactory
    implements ServerSocketFactory {
        @Override
        public ServerSocket create() throws IOException {
            return new ServerSocket();
        }
    }

    private class DefaultTempFileManagerFactory
    implements TempFileManagerFactory {
        private DefaultTempFileManagerFactory() {
        }

        @Override
        public TempFileManager create() {
            return new DefaultTempFileManager();
        }
    }

    public static class DefaultTempFileManager
    implements TempFileManager {
        private final File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        private final List<TempFile> tempFiles;

        public DefaultTempFileManager() {
            if (!this.tmpdir.exists()) {
                this.tmpdir.mkdirs();
            }
            this.tempFiles = new ArrayList<TempFile>();
        }

        @Override
        public void clear() {
            for (TempFile file2 : this.tempFiles) {
                try {
                    file2.delete();
                }
                catch (Exception ignored) {
                    LOG.log(Level.WARNING, "could not delete file ", ignored);
                }
            }
            this.tempFiles.clear();
        }

        @Override
        public TempFile createTempFile(String filename_hint) throws Exception {
            DefaultTempFile tempFile = new DefaultTempFile(this.tmpdir);
            this.tempFiles.add(tempFile);
            return tempFile;
        }
    }

    public static class DefaultTempFile
    implements TempFile {
        private final File file;
        private final OutputStream fstream;

        public DefaultTempFile(File tempdir) throws IOException {
            this.file = File.createTempFile("NanoHTTPD-", "", tempdir);
            this.fstream = new FileOutputStream(this.file);
        }

        @Override
        public void delete() throws Exception {
            NanoHTTPD.safeClose(this.fstream);
            if (!this.file.delete()) {
                throw new Exception("could not delete temporary file: " + this.file.getAbsolutePath());
            }
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public OutputStream open() throws Exception {
            return this.fstream;
        }
    }

    public static class DefaultAsyncRunner
    implements AsyncRunner {
        private long requestCount;
        private final List<ClientHandler> running = Collections.synchronizedList(new ArrayList());

        public List<ClientHandler> getRunning() {
            return this.running;
        }

        @Override
        public void closeAll() {
            for (ClientHandler clientHandler : new ArrayList<ClientHandler>(this.running)) {
                clientHandler.close();
            }
        }

        @Override
        public void closed(ClientHandler clientHandler) {
            this.running.remove(clientHandler);
        }

        @Override
        public void exec(ClientHandler clientHandler) {
            ++this.requestCount;
            Thread t3 = new Thread(clientHandler);
            t3.setDaemon(true);
            t3.setName("NanoHttpd Request Processor (#" + this.requestCount + ")");
            this.running.add(clientHandler);
            t3.start();
        }
    }

    public class CookieHandler
    implements Iterable<String> {
        private final HashMap<String, String> cookies = new HashMap();
        private final ArrayList<Cookie> queue = new ArrayList();

        public CookieHandler(Map<String, String> httpHeaders) {
            String raw = httpHeaders.get("cookie");
            if (raw != null) {
                String[] tokens;
                for (String token2 : tokens = raw.split(";")) {
                    String[] data2 = token2.trim().split("=");
                    if (data2.length != 2) continue;
                    this.cookies.put(data2[0], data2[1]);
                }
            }
        }

        public void delete(String name) {
            this.set(name, "-delete-", -30);
        }

        @Override
        public Iterator<String> iterator() {
            return this.cookies.keySet().iterator();
        }

        public String read(String name) {
            return this.cookies.get(name);
        }

        public void set(Cookie cookie) {
            this.queue.add(cookie);
        }

        public void set(String name, String value, int expires) {
            this.queue.add(new Cookie(name, value, Cookie.getHTTPTime(expires)));
        }

        public void unloadQueue(Response response2) {
            for (Cookie cookie : this.queue) {
                response2.addHeader("Set-Cookie", cookie.getHTTPHeader());
            }
        }
    }

    public static class Cookie {
        private final String n;
        private final String v;
        private final String e;

        public static String getHTTPTime(int days) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.add(5, days);
            return dateFormat.format(calendar.getTime());
        }

        public Cookie(String name, String value) {
            this(name, value, 30);
        }

        public Cookie(String name, String value, int numDays) {
            this.n = name;
            this.v = value;
            this.e = Cookie.getHTTPTime(numDays);
        }

        public Cookie(String name, String value, String expires) {
            this.n = name;
            this.v = value;
            this.e = expires;
        }

        public String getHTTPHeader() {
            String fmt = "%s=%s; expires=%s";
            return String.format(fmt, this.n, this.v, this.e);
        }
    }

    public class ClientHandler
    implements Runnable {
        private final InputStream inputStream;
        private final Socket acceptSocket;

        public ClientHandler(InputStream inputStream2, Socket acceptSocket) {
            this.inputStream = inputStream2;
            this.acceptSocket = acceptSocket;
        }

        public void close() {
            NanoHTTPD.safeClose(this.inputStream);
            NanoHTTPD.safeClose(this.acceptSocket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream outputStream2 = null;
            try {
                outputStream2 = this.acceptSocket.getOutputStream();
                TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
                HTTPSession session2 = new HTTPSession(tempFileManager, this.inputStream, outputStream2, this.acceptSocket.getInetAddress());
                while (!this.acceptSocket.isClosed()) {
                    session2.execute();
                }
            }
            catch (Exception e) {
                if (!(e instanceof SocketException && "NanoHttpd Shutdown".equals(e.getMessage()) || e instanceof SocketTimeoutException)) {
                    LOG.log(Level.SEVERE, "Communication with the client broken, or an bug in the handler code", e);
                }
            }
            finally {
                NanoHTTPD.safeClose(outputStream2);
                NanoHTTPD.safeClose(this.inputStream);
                NanoHTTPD.safeClose(this.acceptSocket);
                NanoHTTPD.this.asyncRunner.closed(this);
            }
        }
    }

    public static interface AsyncRunner {
        public void closeAll();

        public void closed(ClientHandler var1);

        public void exec(ClientHandler var1);
    }
}

