/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/routing/ContentTypeHeaderRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "contentType", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)V", "getContentType", "()Lio/ktor/http/ContentType;", "failedEvaluation", "Lio/ktor/server/routing/RouteSelectorEvaluation$Failure;", "component1", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/server/routing/RoutingResolveContext;", "segmentIndex", "", "hashCode", "toString", "", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/ContentTypeHeaderRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n288#2,2:701\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/ContentTypeHeaderRouteSelector\n*L\n595#1:701,2\n*E\n"})
public final class ContentTypeHeaderRouteSelector
extends RouteSelector {
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final RouteSelectorEvaluation.Failure failedEvaluation;

    public ContentTypeHeaderRouteSelector(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        this.contentType = contentType2;
        this.failedEvaluation = new RouteSelectorEvaluation.Failure(0.01, HttpStatusCode.Companion.getUnsupportedMediaType());
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(context, "context");
            String headers2 = ApplicationRequestPropertiesKt.header(context.getCall().getRequest(), HttpHeaders.INSTANCE.getContentType());
            List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortContentTypeHeader(headers2);
            Iterable $this$firstOrNull$iv = parsedHeaders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeaderValue it = (HeaderValue)element$iv;
                boolean bl = false;
                if (!ContentType.Companion.parse(it.getValue()).match(this.contentType)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HeaderValue headerValue = v0;
        if (headerValue == null) {
            return this.failedEvaluation;
        }
        HeaderValue header2 = headerValue;
        return new RouteSelectorEvaluation.Success(header2.getQuality(), null, 0, 6, null);
    }

    @NotNull
    public String toString() {
        return "(contentType = " + this.contentType + ')';
    }

    @NotNull
    public final ContentType component1() {
        return this.contentType;
    }

    @NotNull
    public final ContentTypeHeaderRouteSelector copy(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        return new ContentTypeHeaderRouteSelector(contentType2);
    }

    public static /* synthetic */ ContentTypeHeaderRouteSelector copy$default(ContentTypeHeaderRouteSelector contentTypeHeaderRouteSelector, ContentType contentType2, int n, Object object) {
        if ((n & 1) != 0) {
            contentType2 = contentTypeHeaderRouteSelector.contentType;
        }
        return contentTypeHeaderRouteSelector.copy(contentType2);
    }

    public int hashCode() {
        return this.contentType.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentTypeHeaderRouteSelector)) {
            return false;
        }
        ContentTypeHeaderRouteSelector contentTypeHeaderRouteSelector = (ContentTypeHeaderRouteSelector)other;
        return Intrinsics.areEqual(this.contentType, contentTypeHeaderRouteSelector.contentType);
    }
}

