/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/routing/HttpMultiAcceptRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "contentTypes", "", "Lio/ktor/http/ContentType;", "(Ljava/util/List;)V", "getContentTypes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/server/routing/RoutingResolveContext;", "segmentIndex", "", "hashCode", "toString", "", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpMultiAcceptRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n288#2:701\n1747#2,3:702\n289#2:705\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpMultiAcceptRouteSelector\n*L\n638#1:701\n638#1:702,3\n638#1:705\n*E\n"})
public final class HttpMultiAcceptRouteSelector
extends RouteSelector {
    @NotNull
    private final List<ContentType> contentTypes;

    public HttpMultiAcceptRouteSelector(@NotNull List<ContentType> contentTypes) {
        Intrinsics.checkNotNullParameter(contentTypes, "contentTypes");
        this.contentTypes = contentTypes;
    }

    @NotNull
    public final List<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Intrinsics.checkNotNullParameter(context, "context");
        String acceptHeaderContent = context.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getAccept());
        try {
            Object v1;
            block9: {
                List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortContentTypeHeader(acceptHeaderContent);
                if (parsedHeaders.isEmpty()) {
                    return RouteSelectorEvaluation.Companion.getMissing();
                }
                Iterable $this$firstOrNull$iv = parsedHeaders;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block8: {
                        HeaderValue header2 = (HeaderValue)element$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = this.contentTypes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                ContentType it = (ContentType)element$iv2;
                                boolean bl3 = false;
                                if (!it.match(header2.getValue())) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            HeaderValue header3 = v1;
            if (header3 != null) {
                return new RouteSelectorEvaluation.Success(header3.getQuality(), null, 0, 6, null);
            }
            return RouteSelectorEvaluation.Companion.getFailedParameter();
        }
        catch (BadContentTypeFormatException failedToParse) {
            throw new BadRequestException("Illegal Accept header format: " + acceptHeaderContent, failedToParse);
        }
    }

    @NotNull
    public String toString() {
        return "(contentTypes:" + this.contentTypes + ')';
    }

    @NotNull
    public final List<ContentType> component1() {
        return this.contentTypes;
    }

    @NotNull
    public final HttpMultiAcceptRouteSelector copy(@NotNull List<ContentType> contentTypes) {
        Intrinsics.checkNotNullParameter(contentTypes, "contentTypes");
        return new HttpMultiAcceptRouteSelector(contentTypes);
    }

    public static /* synthetic */ HttpMultiAcceptRouteSelector copy$default(HttpMultiAcceptRouteSelector httpMultiAcceptRouteSelector, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = httpMultiAcceptRouteSelector.contentTypes;
        }
        return httpMultiAcceptRouteSelector.copy(list);
    }

    public int hashCode() {
        return ((Object)this.contentTypes).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpMultiAcceptRouteSelector)) {
            return false;
        }
        HttpMultiAcceptRouteSelector httpMultiAcceptRouteSelector = (HttpMultiAcceptRouteSelector)other;
        return Intrinsics.areEqual(this.contentTypes, httpMultiAcceptRouteSelector.contentTypes);
    }
}

