/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

final class Bzip2BitWriter {
    private long bitBuffer;
    private int bitCount;

    Bzip2BitWriter() {
    }

    void writeBits(ByteBuf out2, int count2, long value) {
        if (count2 < 0 || count2 > 32) {
            throw new IllegalArgumentException("count: " + count2 + " (expected: 0-32)");
        }
        int bitCount = this.bitCount;
        long bitBuffer = this.bitBuffer | value << 64 - count2 >>> bitCount;
        if ((bitCount += count2) >= 32) {
            out2.writeInt((int)(bitBuffer >>> 32));
            bitBuffer <<= 32;
            bitCount -= 32;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = bitCount;
    }

    void writeBoolean(ByteBuf out2, boolean value) {
        int bitCount = this.bitCount + 1;
        long bitBuffer = this.bitBuffer | (value ? 1L << 64 - bitCount : 0L);
        if (bitCount == 32) {
            out2.writeInt((int)(bitBuffer >>> 32));
            bitBuffer = 0L;
            bitCount = 0;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = bitCount;
    }

    void writeUnary(ByteBuf out2, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value: " + value + " (expected 0 or more)");
        }
        while (value-- > 0) {
            this.writeBoolean(out2, true);
        }
        this.writeBoolean(out2, false);
    }

    void writeInt(ByteBuf out2, int value) {
        this.writeBits(out2, 32, value);
    }

    void flush(ByteBuf out2) {
        int bitCount = this.bitCount;
        if (bitCount > 0) {
            long bitBuffer = this.bitBuffer;
            int shiftToRight = 64 - bitCount;
            if (bitCount <= 8) {
                out2.writeByte((int)(bitBuffer >>> shiftToRight << 8 - bitCount));
            } else if (bitCount <= 16) {
                out2.writeShort((int)(bitBuffer >>> shiftToRight << 16 - bitCount));
            } else if (bitCount <= 24) {
                out2.writeMedium((int)(bitBuffer >>> shiftToRight << 24 - bitCount));
            } else {
                out2.writeInt((int)(bitBuffer >>> shiftToRight << 32 - bitCount));
            }
        }
    }
}

