/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Snappy;

public class SnappyFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private boolean started;

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out2) throws Exception {
        block6: {
            int dataLength;
            if (!in.isReadable()) {
                return;
            }
            if (!this.started) {
                this.started = true;
                out2.writeBytes(STREAM_START);
            }
            if ((dataLength = in.readableBytes()) > 18) {
                ByteBuf slice;
                int lengthIdx;
                while (true) {
                    lengthIdx = out2.writerIndex() + 1;
                    if (dataLength < 18) {
                        slice = in.readSlice(dataLength);
                        SnappyFrameEncoder.writeUnencodedChunk(slice, out2, dataLength);
                        break block6;
                    }
                    out2.writeInt(0);
                    if (dataLength <= Short.MAX_VALUE) break;
                    slice = in.readSlice(Short.MAX_VALUE);
                    SnappyFrameEncoder.calculateAndWriteChecksum(slice, out2);
                    this.snappy.encode(slice, out2, Short.MAX_VALUE);
                    SnappyFrameEncoder.setChunkLength(out2, lengthIdx);
                    dataLength -= Short.MAX_VALUE;
                }
                slice = in.readSlice(dataLength);
                SnappyFrameEncoder.calculateAndWriteChecksum(slice, out2);
                this.snappy.encode(slice, out2, dataLength);
                SnappyFrameEncoder.setChunkLength(out2, lengthIdx);
            } else {
                SnappyFrameEncoder.writeUnencodedChunk(in, out2, dataLength);
            }
        }
    }

    private static void writeUnencodedChunk(ByteBuf in, ByteBuf out2, int dataLength) {
        out2.writeByte(1);
        SnappyFrameEncoder.writeChunkLength(out2, dataLength + 4);
        SnappyFrameEncoder.calculateAndWriteChecksum(in, out2);
        out2.writeBytes(in, dataLength);
    }

    private static void setChunkLength(ByteBuf out2, int lengthIdx) {
        int chunkLength = out2.writerIndex() - lengthIdx - 3;
        if (chunkLength >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + chunkLength);
        }
        out2.setMediumLE(lengthIdx, chunkLength);
    }

    private static void writeChunkLength(ByteBuf out2, int chunkLength) {
        out2.writeMediumLE(chunkLength);
    }

    private static void calculateAndWriteChecksum(ByteBuf slice, ByteBuf out2) {
        out2.writeIntLE(Snappy.calculateChecksum(slice));
    }
}

