/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private static final int HASH_CODE_PRIME = 31;
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion version2) {
        this(version2, DefaultHttpHeadersFactory.headersFactory());
    }

    @Deprecated
    protected DefaultHttpMessage(HttpVersion version2, boolean validateHeaders, boolean singleFieldHeaders) {
        this(version2, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders).withCombiningHeaders(singleFieldHeaders));
    }

    protected DefaultHttpMessage(HttpVersion version2, HttpHeadersFactory headersFactory) {
        this(version2, headersFactory.newHeaders());
    }

    protected DefaultHttpMessage(HttpVersion version2, HttpHeaders headers2) {
        this.version = ObjectUtil.checkNotNull(version2, "version");
        this.headers = ObjectUtil.checkNotNull(headers2, "headers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion();
    }

    @Override
    public HttpVersion protocolVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + this.headers.hashCode();
        result2 = 31 * result2 + this.version.hashCode();
        result2 = 31 * result2 + super.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttpMessage)) {
            return false;
        }
        DefaultHttpMessage other = (DefaultHttpMessage)o;
        return this.headers().equals(other.headers()) && this.protocolVersion().equals(other.protocolVersion()) && super.equals(o);
    }

    @Override
    public HttpMessage setProtocolVersion(HttpVersion version2) {
        this.version = ObjectUtil.checkNotNull(version2, "version");
        return this;
    }
}

