/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestAdapterCache
extends HashMap<Description, Test> {
    private static final long serialVersionUID = 1L;
    private static final JUnit4TestAdapterCache fInstance = new JUnit4TestAdapterCache();

    public static JUnit4TestAdapterCache getDefault() {
        return fInstance;
    }

    public Test asTest(Description description2) {
        if (description2.isSuite()) {
            return this.createTest(description2);
        }
        if (!this.containsKey(description2)) {
            this.put(description2, this.createTest(description2));
        }
        return (Test)this.get(description2);
    }

    Test createTest(Description description2) {
        if (description2.isTest()) {
            return new JUnit4TestCaseFacade(description2);
        }
        TestSuite suite = new TestSuite(description2.getDisplayName());
        for (Description child2 : description2.getChildren()) {
            suite.addTest(this.asTest(child2));
        }
        return suite;
    }

    public RunNotifier getNotifier(final TestResult result2, JUnit4TestAdapter adapter) {
        RunNotifier notifier = new RunNotifier();
        notifier.addListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                result2.addError(JUnit4TestAdapterCache.this.asTest(failure.getDescription()), failure.getException());
            }

            public void testFinished(Description description2) throws Exception {
                result2.endTest(JUnit4TestAdapterCache.this.asTest(description2));
            }

            public void testStarted(Description description2) throws Exception {
                result2.startTest(JUnit4TestAdapterCache.this.asTest(description2));
            }
        });
        return notifier;
    }

    public List<Test> asTestList(Description description2) {
        if (description2.isTest()) {
            return Arrays.asList(this.asTest(description2));
        }
        ArrayList<Test> returnThis = new ArrayList<Test>();
        for (Description child2 : description2.getChildren()) {
            returnThis.add(this.asTest(child2));
        }
        return returnThis;
    }
}

