/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.text;

import java.util.Map;

public abstract class StrLookup {
    private static final StrLookup NONE_LOOKUP = new MapStrLookup(null);
    private static final StrLookup SYSTEM_PROPERTIES_LOOKUP;

    public static StrLookup noneLookup() {
        return NONE_LOOKUP;
    }

    public static StrLookup systemPropertiesLookup() {
        return SYSTEM_PROPERTIES_LOOKUP;
    }

    public static StrLookup mapLookup(Map map2) {
        return new MapStrLookup(map2);
    }

    protected StrLookup() {
    }

    public abstract String lookup(String var1);

    static {
        StrLookup lookup2 = null;
        try {
            lookup2 = new MapStrLookup(System.getProperties());
        }
        catch (SecurityException ex) {
            lookup2 = NONE_LOOKUP;
        }
        SYSTEM_PROPERTIES_LOOKUP = lookup2;
    }

    static class MapStrLookup
    extends StrLookup {
        private final Map map;

        MapStrLookup(Map map2) {
            this.map = map2;
        }

        public String lookup(String key2) {
            if (this.map == null) {
                return null;
            }
            Object obj = this.map.get(key2);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }
}

