/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.internal;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveTypeFinder {
    private final String methodName;
    private final int expectedNumberOfParameters;
    private final int typedParameter;

    public ReflectiveTypeFinder(String methodName, int expectedNumberOfParameters, int typedParameter) {
        this.methodName = methodName;
        this.expectedNumberOfParameters = expectedNumberOfParameters;
        this.typedParameter = typedParameter;
    }

    public Class<?> findExpectedType(Class<?> fromClass) {
        for (Class<?> c = fromClass; c != Object.class; c = c.getSuperclass()) {
            for (Method method2 : c.getDeclaredMethods()) {
                if (!this.canObtainExpectedTypeFrom(method2)) continue;
                return this.expectedTypeFrom(method2);
            }
        }
        throw new Error("Cannot determine correct type for " + this.methodName + "() method.");
    }

    protected boolean canObtainExpectedTypeFrom(Method method2) {
        return method2.getName().equals(this.methodName) && method2.getParameterTypes().length == this.expectedNumberOfParameters && !method2.isSynthetic();
    }

    protected Class<?> expectedTypeFrom(Method method2) {
        return method2.getParameterTypes()[this.typedParameter];
    }
}

