/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLParserConfiguration;
import org.json.XMLTokener;
import org.json.XMLXsiTypeConverter;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');
    public static final String NULL_ATTR = "xsi:nil";
    public static final String TYPE_ATTR = "xsi:type";

    private static Iterable<Integer> codePointIterator(final String string) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int nextIndex = 0;
                    private int length;
                    {
                        this.length = string.length();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextIndex < this.length;
                    }

                    @Override
                    public Integer next() {
                        int result2 = string.codePointAt(this.nextIndex);
                        this.nextIndex += Character.charCount(result2);
                        return result2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        block7: for (int cp : XML.codePointIterator(string)) {
            switch (cp) {
                case 38: {
                    sb.append("&amp;");
                    continue block7;
                }
                case 60: {
                    sb.append("&lt;");
                    continue block7;
                }
                case 62: {
                    sb.append("&gt;");
                    continue block7;
                }
                case 34: {
                    sb.append("&quot;");
                    continue block7;
                }
                case 39: {
                    sb.append("&apos;");
                    continue block7;
                }
            }
            if (XML.mustEscape(cp)) {
                sb.append("&#x");
                sb.append(Integer.toHexString(cp));
                sb.append(';');
                continue;
            }
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    private static boolean mustEscape(int cp) {
        return Character.isISOControl(cp) && cp != 9 && cp != 10 && cp != 13 || (cp < 32 || cp > 55295) && (cp < 57344 || cp > 65533) && (cp < 65536 || cp > 0x10FFFF);
    }

    public static String unescape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = string.charAt(i2);
            if (c == '&') {
                int semic = string.indexOf(59, i2);
                if (semic > i2) {
                    String entity = string.substring(i2 + 1, semic);
                    sb.append(XMLTokener.unescapeEntity(entity));
                    i2 += entity.length() + 1;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int length = string.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (!Character.isWhitespace(string.charAt(i2))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name, XMLParserConfiguration config2, int currentNestingDepth) throws JSONException {
        String string;
        JSONObject jsonObject = null;
        Object token2 = x.nextToken();
        if (token2 == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token2 = x.nextToken();
                if ("CDATA".equals(token2) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate(config2.getcDataTagName(), string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((token2 = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token2 == LT) {
                    ++i2;
                    continue;
                }
                if (token2 != GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (token2 == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token2 == SLASH) {
            token2 = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + token2);
            }
            if (!token2.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + token2);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token2 instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName2 = (String)token2;
        token2 = null;
        jsonObject = new JSONObject();
        boolean nilAttributeFound = false;
        XMLXsiTypeConverter<?> xmlXsiTypeConverter = null;
        while (true) {
            if (token2 == null) {
                token2 = x.nextToken();
            }
            if (!(token2 instanceof String)) break;
            string = (String)token2;
            token2 = x.nextToken();
            if (token2 == EQ) {
                token2 = x.nextToken();
                if (!(token2 instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                if (config2.isConvertNilAttributeToNull() && NULL_ATTR.equals(string) && Boolean.parseBoolean((String)token2)) {
                    nilAttributeFound = true;
                } else if (config2.getXsiTypeMap() != null && !config2.getXsiTypeMap().isEmpty() && TYPE_ATTR.equals(string)) {
                    xmlXsiTypeConverter = config2.getXsiTypeMap().get(token2);
                } else if (!nilAttributeFound) {
                    jsonObject.accumulate(string, config2.isKeepStrings() ? (String)token2 : XML.stringToValue((String)token2));
                }
                token2 = null;
                continue;
            }
            jsonObject.accumulate(string, "");
        }
        if (token2 == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (config2.getForceList().contains(tagName2)) {
                if (nilAttributeFound) {
                    context.append(tagName2, JSONObject.NULL);
                } else if (jsonObject.length() > 0) {
                    context.append(tagName2, jsonObject);
                } else {
                    context.put(tagName2, new JSONArray());
                }
            } else if (nilAttributeFound) {
                context.accumulate(tagName2, JSONObject.NULL);
            } else if (jsonObject.length() > 0) {
                context.accumulate(tagName2, jsonObject);
            } else {
                context.accumulate(tagName2, "");
            }
            return false;
        }
        if (token2 == GT) {
            while (true) {
                if ((token2 = x.nextContent()) == null) {
                    if (tagName2 != null) {
                        throw x.syntaxError("Unclosed tag " + tagName2);
                    }
                    return false;
                }
                if (token2 instanceof String) {
                    string = (String)token2;
                    if (string.length() <= 0) continue;
                    if (xmlXsiTypeConverter != null) {
                        jsonObject.accumulate(config2.getcDataTagName(), XML.stringToValue(string, xmlXsiTypeConverter));
                        continue;
                    }
                    jsonObject.accumulate(config2.getcDataTagName(), config2.isKeepStrings() ? string : XML.stringToValue(string));
                    continue;
                }
                if (token2 != LT) continue;
                if (currentNestingDepth == config2.getMaxNestingDepth()) {
                    throw x.syntaxError("Maximum nesting depth of " + config2.getMaxNestingDepth() + " reached");
                }
                if (XML.parse(x, jsonObject, tagName2, config2, currentNestingDepth + 1)) break;
            }
            if (config2.getForceList().contains(tagName2)) {
                if (jsonObject.length() == 0) {
                    context.put(tagName2, new JSONArray());
                } else if (jsonObject.length() == 1 && jsonObject.opt(config2.getcDataTagName()) != null) {
                    context.append(tagName2, jsonObject.opt(config2.getcDataTagName()));
                } else {
                    context.append(tagName2, jsonObject);
                }
            } else if (jsonObject.length() == 0) {
                context.accumulate(tagName2, "");
            } else if (jsonObject.length() == 1 && jsonObject.opt(config2.getcDataTagName()) != null) {
                context.accumulate(tagName2, jsonObject.opt(config2.getcDataTagName()));
            } else {
                context.accumulate(tagName2, jsonObject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string, XMLXsiTypeConverter<?> typeConverter) {
        if (typeConverter != null) {
            return typeConverter.convert(string);
        }
        return XML.stringToValue(string);
    }

    public static Object stringToValue(String string) {
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        char initial = string.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            try {
                return XML.stringToNumber(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static Number stringToNumber(String val) throws NumberFormatException {
        char initial = val.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            BigInteger bi;
            char at1;
            if (XML.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        Double d = Double.valueOf(val);
                        if (d.isNaN() || d.isInfinite()) {
                            throw new NumberFormatException("val [" + val + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException ignore) {
                        throw new NumberFormatException("val [" + val + "] is not a valid number.");
                    }
                }
            }
            if (initial == '0' && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            } else if (initial == '-' && val.length() > 2) {
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && at2 <= '9') {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger(val)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return bi;
        }
        throw new NumberFormatException("val [" + val + "] is not a valid number.");
    }

    private static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return XML.toJSONObject(string, XMLParserConfiguration.ORIGINAL);
    }

    public static JSONObject toJSONObject(Reader reader) throws JSONException {
        return XML.toJSONObject(reader, XMLParserConfiguration.ORIGINAL);
    }

    public static JSONObject toJSONObject(Reader reader, boolean keepStrings) throws JSONException {
        if (keepStrings) {
            return XML.toJSONObject(reader, XMLParserConfiguration.KEEP_STRINGS);
        }
        return XML.toJSONObject(reader, XMLParserConfiguration.ORIGINAL);
    }

    public static JSONObject toJSONObject(Reader reader, XMLParserConfiguration config2) throws JSONException {
        JSONObject jo = new JSONObject();
        XMLTokener x = new XMLTokener(reader);
        while (x.more()) {
            x.skipPast("<");
            if (!x.more()) continue;
            XML.parse(x, jo, null, config2, 0);
        }
        return jo;
    }

    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        return XML.toJSONObject((Reader)new StringReader(string), keepStrings);
    }

    public static JSONObject toJSONObject(String string, XMLParserConfiguration config2) throws JSONException {
        return XML.toJSONObject((Reader)new StringReader(string), config2);
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null, XMLParserConfiguration.ORIGINAL);
    }

    public static String toString(Object object, String tagName2) {
        return XML.toString(object, tagName2, XMLParserConfiguration.ORIGINAL);
    }

    public static String toString(Object object, String tagName2, XMLParserConfiguration config2) throws JSONException {
        return XML.toString(object, tagName2, config2, 0, 0);
    }

    private static String toString(Object object, String tagName2, XMLParserConfiguration config2, int indentFactor, int indent) throws JSONException {
        String string;
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            if (tagName2 != null) {
                sb.append(XML.indent(indent));
                sb.append('<');
                sb.append(tagName2);
                sb.append('>');
                if (indentFactor > 0) {
                    sb.append("\n");
                    indent += indentFactor;
                }
            }
            JSONObject jo = (JSONObject)object;
            for (String key2 : jo.keySet()) {
                Object val;
                int i2;
                int jaLength;
                JSONArray ja;
                Object value = jo.opt(key2);
                if (value == null) {
                    value = "";
                } else if (value.getClass().isArray()) {
                    value = new JSONArray(value);
                }
                if (key2.equals(config2.getcDataTagName())) {
                    if (value instanceof JSONArray) {
                        ja = (JSONArray)value;
                        jaLength = ja.length();
                        for (i2 = 0; i2 < jaLength; ++i2) {
                            if (i2 > 0) {
                                sb.append('\n');
                            }
                            val = ja.opt(i2);
                            sb.append(XML.escape(val.toString()));
                        }
                        continue;
                    }
                    sb.append(XML.escape(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    ja = (JSONArray)value;
                    jaLength = ja.length();
                    for (i2 = 0; i2 < jaLength; ++i2) {
                        val = ja.opt(i2);
                        if (val instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key2);
                            sb.append('>');
                            sb.append(XML.toString(val, null, config2, indentFactor, indent));
                            sb.append("</");
                            sb.append(key2);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toString(val, key2, config2, indentFactor, indent));
                    }
                    continue;
                }
                if ("".equals(value)) {
                    sb.append(XML.indent(indent));
                    sb.append('<');
                    sb.append(key2);
                    sb.append("/>");
                    if (indentFactor <= 0) continue;
                    sb.append("\n");
                    continue;
                }
                sb.append(XML.toString(value, key2, config2, indentFactor, indent));
            }
            if (tagName2 != null) {
                sb.append(XML.indent(indent - indentFactor));
                sb.append("</");
                sb.append(tagName2);
                sb.append('>');
                if (indentFactor > 0) {
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        if (object != null && (object instanceof JSONArray || object.getClass().isArray())) {
            JSONArray ja = object.getClass().isArray() ? new JSONArray(object) : (JSONArray)object;
            int jaLength = ja.length();
            for (int i3 = 0; i3 < jaLength; ++i3) {
                Object val = ja.opt(i3);
                sb.append(XML.toString(val, tagName2 == null ? "array" : tagName2, config2, indentFactor, indent));
            }
            return sb.toString();
        }
        String string2 = string = object == null ? "null" : XML.escape(object.toString());
        if (tagName2 == null) {
            return XML.indent(indent) + "\"" + string + "\"" + (indentFactor > 0 ? "\n" : "");
        }
        if (string.length() == 0) {
            return XML.indent(indent) + "<" + tagName2 + "/>" + (indentFactor > 0 ? "\n" : "");
        }
        return XML.indent(indent) + "<" + tagName2 + ">" + string + "</" + tagName2 + ">" + (indentFactor > 0 ? "\n" : "");
    }

    public static String toString(Object object, int indentFactor) {
        return XML.toString(object, null, XMLParserConfiguration.ORIGINAL, indentFactor);
    }

    public static String toString(Object object, String tagName2, int indentFactor) {
        return XML.toString(object, tagName2, XMLParserConfiguration.ORIGINAL, indentFactor);
    }

    public static String toString(Object object, String tagName2, XMLParserConfiguration config2, int indentFactor) throws JSONException {
        return XML.toString(object, tagName2, config2, indentFactor, 0);
    }

    private static final String indent(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < indent; ++i2) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

