/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleContainer {
    private final IdentityHashMap<Object, Integer> orderValues = new IdentityHashMap();
    private final List<TestRule> testRules = new ArrayList<TestRule>();
    private final List<MethodRule> methodRules = new ArrayList<MethodRule>();
    static final Comparator<RuleEntry> ENTRY_COMPARATOR = new Comparator<RuleEntry>(){

        @Override
        public int compare(RuleEntry o1, RuleEntry o2) {
            int result2 = this.compareInt(o1.order, o2.order);
            return result2 != 0 ? result2 : o1.type - o2.type;
        }

        private int compareInt(int a2, int b2) {
            return a2 < b2 ? 1 : (a2 == b2 ? 0 : -1);
        }
    };

    RuleContainer() {
    }

    public void setOrder(Object rule, int order) {
        this.orderValues.put(rule, order);
    }

    public void add(MethodRule methodRule) {
        this.methodRules.add(methodRule);
    }

    public void add(TestRule testRule) {
        this.testRules.add(testRule);
    }

    private List<RuleEntry> getSortedEntries() {
        ArrayList<RuleEntry> ruleEntries = new ArrayList<RuleEntry>(this.methodRules.size() + this.testRules.size());
        for (MethodRule methodRule : this.methodRules) {
            ruleEntries.add(new RuleEntry(methodRule, 0, this.orderValues.get(methodRule)));
        }
        for (TestRule testRule : this.testRules) {
            ruleEntries.add(new RuleEntry(testRule, 1, this.orderValues.get(testRule)));
        }
        Collections.sort(ruleEntries, ENTRY_COMPARATOR);
        return ruleEntries;
    }

    public Statement apply(FrameworkMethod method2, Description description2, Object target, Statement statement2) {
        if (this.methodRules.isEmpty() && this.testRules.isEmpty()) {
            return statement2;
        }
        Statement result2 = statement2;
        for (RuleEntry ruleEntry : this.getSortedEntries()) {
            if (ruleEntry.type == 1) {
                result2 = ((TestRule)ruleEntry.rule).apply(result2, description2);
                continue;
            }
            result2 = ((MethodRule)ruleEntry.rule).apply(result2, method2, target);
        }
        return result2;
    }

    List<Object> getSortedRules() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (RuleEntry entry : this.getSortedEntries()) {
            result2.add(entry.rule);
        }
        return result2;
    }

    static class RuleEntry {
        static final int TYPE_TEST_RULE = 1;
        static final int TYPE_METHOD_RULE = 0;
        final Object rule;
        final int type;
        final int order;

        RuleEntry(Object rule, int type2, Integer order) {
            this.rule = rule;
            this.type = type2;
            this.order = order != null ? order : -1;
        }
    }
}

