/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class DelimiterConvertingContext
implements Context {
    protected Context target;

    public DelimiterConvertingContext(Context ctxt) {
        this.target = ctxt;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.target.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.lookup(name);
    }

    String normalizeSeparator(String name) throws NamingException {
        String delimiter;
        Hashtable env = this.getEnvironment();
        String separator = (String)env.get("jndi.syntax.separator");
        if (separator != null && !separator.equals(delimiter = (String)env.get("org.osjava.sj.delimiter"))) {
            name = name.replace(delimiter, separator);
        }
        return name;
    }

    @Override
    public void bind(Name name, Object value) throws NamingException {
        this.target.bind(name, value);
    }

    @Override
    public void bind(String name, Object value) throws NamingException {
        name = this.normalizeSeparator(name);
        this.target.bind(name, value);
    }

    @Override
    public void rebind(Name name, Object value) throws NamingException {
        this.target.rebind(name, value);
    }

    @Override
    public void rebind(String name, Object value) throws NamingException {
        name = this.normalizeSeparator(name);
        this.target.rebind(name, value);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.target.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        this.target.unbind(name);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.target.rename(name, name2);
    }

    @Override
    public void rename(String name, String name2) throws NamingException {
        name = this.normalizeSeparator(name);
        name2 = this.normalizeSeparator(name2);
        this.target.rename(name, name2);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.target.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.target.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.target.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        this.target.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.target.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.target.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.target.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        name = this.normalizeSeparator(name);
        return this.target.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        return this.target.composeName(name, name2);
    }

    @Override
    public String composeName(String name, String name2) throws NamingException {
        name = this.normalizeSeparator(name);
        name2 = this.normalizeSeparator(name2);
        return this.target.composeName(name, name2);
    }

    @Override
    public Object addToEnvironment(String key2, Object value) throws NamingException {
        return this.target.addToEnvironment(key2, value);
    }

    @Override
    public Object removeFromEnvironment(String key2) throws NamingException {
        return this.target.removeFromEnvironment(key2);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.target.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.target.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.target.getNameInNamespace();
    }
}

