package com.ustadmobile.libcache.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.libcache.db.entities.RequestedEntry
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class RequestedEntryDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract fun insertList(requestedSha256s: List<RequestedEntry>)

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertListAsync(requestedSha256s: List<RequestedEntry>)

  @Query(`value` =
      "\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = :batchId \n           AND NOT EXISTS(\n               SELECT CacheEntry.key\n                 FROM CacheEntry\n                WHERE CacheEntry.key = RequestedEntry.requestedKey\n           )\n        ")
  public actual abstract fun findKeysNotPresent(batchId: Int): List<String>

  @Query(`value` =
      "\n        DELETE FROM RequestedEntry\n         WHERE RequestedEntry.batchId = :batchId    \n    ")
  public actual abstract fun deleteBatch(batchId: Int)
}
