/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CommentsDao;
import com.ustadmobile.lib.db.composites.CommentsAndName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.Comments;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class CommentsDao_Impl
extends CommentsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Comments> __insertionAdapterOfComments;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDeletedByCommentUid;

    public CommentsDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfComments = new EntityInsertionAdapter<Comments>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Comments` (`commentsUid`,`commentsText`,`commentsEntityUid`,`commentsStatus`,`commentsFromPersonUid`,`commentsForSubmitterUid`,`commentsFromSubmitterUid`,`commentsFlagged`,`commentsDeleted`,`commentsDateTimeAdded`,`commentsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Comments entity) {
                statement.bindLong(1, entity.getCommentsUid());
                if (entity.getCommentsText() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCommentsText());
                }
                statement.bindLong(3, entity.getCommentsEntityUid());
                statement.bindLong(4, (long)entity.getCommentsStatus());
                statement.bindLong(5, entity.getCommentsFromPersonUid());
                statement.bindLong(6, entity.getCommentsForSubmitterUid());
                statement.bindLong(7, entity.getCommentsFromSubmitterUid());
                int _tmp = entity.getCommentsFlagged() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                int _tmp_1 = entity.getCommentsDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_1);
                statement.bindLong(10, entity.getCommentsDateTimeAdded());
                statement.bindLong(11, entity.getCommentsLct());
            }
        };
        this.__preparedStmtOfUpdateDeletedByCommentUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE Comments \n           SET commentsDeleted = ?,\n               commentsLct = ?\n         WHERE Comments.commentsUid = ?\n    ";
                return "\n        UPDATE Comments \n           SET commentsDeleted = ?,\n               commentsLct = ?\n         WHERE Comments.commentsUid = ?\n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final Comments comments, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CommentsDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CommentsDao_Impl.this.__insertionAdapterOfComments.insertAndReturnId((Object)comments);
                    CommentsDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CommentsDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateDeletedByCommentUid(final long uid, final boolean deleted, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CommentsDao_Impl.this.__preparedStmtOfUpdateDeletedByCommentUid.acquire();
                int _argIndex = 1;
                int _tmp = deleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    CommentsDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CommentsDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CommentsDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CommentsDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CommentsDao_Impl.this.__preparedStmtOfUpdateDeletedByCommentUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, CommentsAndName> findPrivateCommentsForUserByAssignmentUid(long accountPersonUid, long assignmentUid, boolean includeDeleted) {
        String _sql = "\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n           AND Comments.commentsForSubmitterUid != 0\n           AND Comments.commentsEntityUid = ?\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1) \n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n           AND Comments.commentsForSubmitterUid != 0\n           AND Comments.commentsEntityUid = ?\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1) \n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ", (int)12);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<CommentsAndName>(_statement, this.__db, new String[]{"Comments", "Person", "PersonPicture", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember"}){

            @NonNull
            protected List<CommentsAndName> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsUid");
                int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsText");
                int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsEntityUid");
                int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsStatus");
                int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromPersonUid");
                int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsForSubmitterUid");
                int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromSubmitterUid");
                int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFlagged");
                int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDeleted");
                int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDateTimeAdded");
                int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsLct");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"pictureUri");
                ArrayList<CommentsAndName> _result2 = new ArrayList<CommentsAndName>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                    String _tmpPictureUri = cursor.isNull(_cursorIndexOfPictureUri) ? null : cursor.getString(_cursorIndexOfPictureUri);
                    long _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
                    String _tmpCommentsText = cursor.isNull(_cursorIndexOfCommentsText) ? null : cursor.getString(_cursorIndexOfCommentsText);
                    long _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
                    int _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
                    long _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
                    long _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
                    long _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
                    boolean _tmpCommentsFlagged = _tmp_1 != 0;
                    int _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
                    boolean _tmpCommentsDeleted = _tmp_2 != 0;
                    long _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
                    long _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
                    Comments _tmpComment = new Comments(_tmpCommentsUid, _tmpCommentsText, _tmpCommentsEntityUid, _tmpCommentsStatus, _tmpCommentsFromPersonUid, _tmpCommentsForSubmitterUid, _tmpCommentsFromSubmitterUid, _tmpCommentsFlagged, _tmpCommentsDeleted, _tmpCommentsDateTimeAdded, _tmpCommentsLct);
                    CommentsAndName _item = new CommentsAndName(_tmpComment, _tmpFirstNames, _tmpLastName, _tmpPictureUri);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findPrivateCommentsForUserByAssignmentUidPersons(long accountPersonUid, long assignmentUid, Continuation<? super List<PersonAndPicture>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND Comments.commentsForSubmitterUid != 0\n                   AND Comments.commentsEntityUid = ?\n                   AND CAST(Comments.commentsDeleted AS INTEGER) = 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND Comments.commentsForSubmitterUid != 0\n                   AND Comments.commentsEntityUid = ?\n                   AND CAST(Comments.commentsDeleted AS INTEGER) = 0)\n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndPicture>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndPicture> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CommentsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndPicture> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, CommentsAndName> findPrivateCommentsForSubmitterByAssignmentUid(long submitterUid, long assignmentUid, boolean includeDeleted) {
        String _sql = "\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = ?\n           AND Comments.commentsEntityUid = ?\n           AND (NOT Comments.commentsDeleted OR CAST(? AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC        \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = ?\n           AND Comments.commentsEntityUid = ?\n           AND (NOT Comments.commentsDeleted OR CAST(? AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC        \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 3;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<CommentsAndName>(_statement, this.__db, new String[]{"Comments", "Person", "PersonPicture"}){

            @NonNull
            protected List<CommentsAndName> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsUid");
                int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsText");
                int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsEntityUid");
                int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsStatus");
                int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromPersonUid");
                int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsForSubmitterUid");
                int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromSubmitterUid");
                int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFlagged");
                int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDeleted");
                int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDateTimeAdded");
                int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsLct");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"pictureUri");
                ArrayList<CommentsAndName> _result2 = new ArrayList<CommentsAndName>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                    String _tmpPictureUri = cursor.isNull(_cursorIndexOfPictureUri) ? null : cursor.getString(_cursorIndexOfPictureUri);
                    long _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
                    String _tmpCommentsText = cursor.isNull(_cursorIndexOfCommentsText) ? null : cursor.getString(_cursorIndexOfCommentsText);
                    long _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
                    int _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
                    long _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
                    long _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
                    long _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
                    boolean _tmpCommentsFlagged = _tmp_1 != 0;
                    int _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
                    boolean _tmpCommentsDeleted = _tmp_2 != 0;
                    long _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
                    long _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
                    Comments _tmpComment = new Comments(_tmpCommentsUid, _tmpCommentsText, _tmpCommentsEntityUid, _tmpCommentsStatus, _tmpCommentsFromPersonUid, _tmpCommentsForSubmitterUid, _tmpCommentsFromSubmitterUid, _tmpCommentsFlagged, _tmpCommentsDeleted, _tmpCommentsDateTimeAdded, _tmpCommentsLct);
                    CommentsAndName _item = new CommentsAndName(_tmpComment, _tmpFirstNames, _tmpLastName, _tmpPictureUri);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersonAndPicture> findPrivateCommentsForSubmitterByAssignmentUidPersons(long submitterUid, long assignmentUid) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid \n         WHERE Person.personUid IN \n               (SELECT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = ?\n                   AND Comments.commentsEntityUid = ?\n                   AND NOT Comments.commentsDeleted) \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid \n         WHERE Person.personUid IN \n               (SELECT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = ?\n                   AND Comments.commentsEntityUid = ?\n                   AND NOT Comments.commentsDeleted) \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
            int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
            int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
            int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
            ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                PersonPicture _tmpPicture;
                Person _tmpPerson;
                if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                    long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                    String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                    String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                    String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                    String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                    int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                    int _tmp = _cursor.getInt(_cursorIndexOfActive);
                    boolean _tmpActive = _tmp != 0;
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                    boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                    long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                    String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                    String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                    long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                    long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                    String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                    int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                    long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                    long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                    int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                    int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                    boolean _tmpAdmin = _tmp_2 != 0;
                    String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                    String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                    String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                    String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                    String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                    _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                } else {
                    _tmpPerson = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                    long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                    long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                    String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                    String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                    int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                    int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                    boolean _tmpPersonPictureActive = _tmp_3 != 0;
                    _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                } else {
                    _tmpPicture = null;
                }
                PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                _result2.add(_item);
            }
            ArrayList<PersonAndPicture> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public PagingSource<Integer, CommentsAndName> findCourseCommentsByAssignmentUid(long assignmentUid, boolean includeDeleted) {
        String _sql = "\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsEntityUid = ?\n           AND Comments.commentsForSubmitterUid = 0\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsEntityUid = ?\n           AND Comments.commentsForSubmitterUid = 0\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<CommentsAndName>(_statement, this.__db, new String[]{"Comments", "Person", "PersonPicture"}){

            @NonNull
            protected List<CommentsAndName> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsUid");
                int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsText");
                int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsEntityUid");
                int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsStatus");
                int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromPersonUid");
                int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsForSubmitterUid");
                int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFromSubmitterUid");
                int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsFlagged");
                int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDeleted");
                int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsDateTimeAdded");
                int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentsLct");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"pictureUri");
                ArrayList<CommentsAndName> _result2 = new ArrayList<CommentsAndName>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                    String _tmpPictureUri = cursor.isNull(_cursorIndexOfPictureUri) ? null : cursor.getString(_cursorIndexOfPictureUri);
                    long _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
                    String _tmpCommentsText = cursor.isNull(_cursorIndexOfCommentsText) ? null : cursor.getString(_cursorIndexOfCommentsText);
                    long _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
                    int _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
                    long _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
                    long _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
                    long _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
                    boolean _tmpCommentsFlagged = _tmp_1 != 0;
                    int _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
                    boolean _tmpCommentsDeleted = _tmp_2 != 0;
                    long _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
                    long _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
                    Comments _tmpComment = new Comments(_tmpCommentsUid, _tmpCommentsText, _tmpCommentsEntityUid, _tmpCommentsStatus, _tmpCommentsFromPersonUid, _tmpCommentsForSubmitterUid, _tmpCommentsFromSubmitterUid, _tmpCommentsFlagged, _tmpCommentsDeleted, _tmpCommentsDateTimeAdded, _tmpCommentsLct);
                    CommentsAndName _item = new CommentsAndName(_tmpComment, _tmpFirstNames, _tmpLastName, _tmpPictureUri);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findCourseCommentsByAssignmentUidPersons(long assignmentUid, Continuation<? super List<Person>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                       LEFT JOIN Person \n                            ON Person.personUid = Comments.commentsFromPersonUid\n                 WHERE Comments.commentsEntityUid = ?\n                   AND Comments.commentsForSubmitterUid = 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                       LEFT JOIN Person \n                            ON Person.personUid = Comments.commentsFromPersonUid\n                 WHERE Comments.commentsEntityUid = ?\n                   AND Comments.commentsForSubmitterUid = 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Person>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Person> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CommentsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    ArrayList<Person> _result2 = new ArrayList<Person>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        Person _item = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        _result2.add(_item);
                    }
                    ArrayList<Person> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

