/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.entities.ExternalAppPermission;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/core/db/dao/ExternalAppPermissionDao;", "", "()V", "getExternalAccessPermissionByUid", "Lcom/ustadmobile/lib/db/entities/ExternalAppPermission;", "eapUid", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGrantedAuthToken", "", "packageId", "personUid", "", "currentTime", "(Ljava/lang/String;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPersonUidByAuthToken", "token", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAsync", "externalAppPermission", "(Lcom/ustadmobile/lib/db/entities/ExternalAppPermission;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class ExternalAppPermissionDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertAsync(@NotNull ExternalAppPermission var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT ExternalAppPermission.eapAuthToken\n          FROM ExternalAppPermission\n         WHERE ExternalAppPermission.eapPackageId = :packageId\n           AND ExternalAppPermission.eapPersonUid = :personUid\n           AND :currentTime BETWEEN ExternalAppPermission.eapStartTime AND ExternalAppPermission.eapExpireTime\n         LIMIT 1  \n    ")
    @Nullable
    public abstract Object getGrantedAuthToken(@NotNull String var1, long var2, long var4, @NotNull Continuation<? super String> var6);

    @Query(value="\n        SELECT *\n          FROM ExternalAppPermission\n         WHERE eapUid = :eapUid \n    ")
    @Nullable
    public abstract Object getExternalAccessPermissionByUid(int var1, @NotNull Continuation<? super ExternalAppPermission> var2);

    @Query(value="\n        SELECT COALESCE(\n               (SELECT eapPersonUid\n                  FROM ExternalAppPermission\n                 WHERE eapAuthToken = :token\n                   AND :currentTime BETWEEN eapStartTime AND eapExpireTime\n               ),\n               0)    \n    ")
    @Nullable
    public abstract Object getPersonUidByAuthToken(@NotNull String var1, long var2, @NotNull Continuation<? super Long> var4);
}

