/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.MessageAndOtherPerson;
import com.ustadmobile.lib.db.entities.Message;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH'J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH'\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/core/db/dao/MessageDao;", "", "()V", "conversationsForUserAsPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/composites/MessageAndOtherPerson;", "searchQuery", "", "accountPersonUid", "", "insert", "", "message", "Lcom/ustadmobile/lib/db/entities/Message;", "(Lcom/ustadmobile/lib/db/entities/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "messagesFromOtherUserAsPagingSource", "otherPersonUid", "lib-database_release"})
@Dao
public abstract class MessageDao {
    @Query(value="\n        SELECT Message.*\n          FROM Message\n         WHERE (Message.messageSenderPersonUid = :accountPersonUid\n                AND Message.messageToPersonUid = :otherPersonUid)\n            OR (Message.messageSenderPersonUid = :otherPersonUid\n                AND Message.messageToPersonUid = :accountPersonUid) \n      ORDER BY Message.messageTimestamp DESC          \n    ")
    @NotNull
    public abstract PagingSource<Integer, Message> messagesFromOtherUserAsPagingSource(long var1, long var3);

    @Query(value="\n        SELECT Person.*, LatestMessage.*, PersonPicture.*\n          FROM Person\n               JOIN Message LatestMessage\n                    ON LatestMessage.messageUid = \n                       (SELECT Message.messageUid\n                          FROM Message\n                         WHERE (Message.messageSenderPersonUid = :accountPersonUid\n                                AND Message.messageToPersonUid = Person.personUid)\n                            OR (Message.messageSenderPersonUid = Person.personUid\n                                AND Message.messageToPersonUid = :accountPersonUid)\n                       ORDER BY Message.messageTimestamp DESC\n                          LIMIT 1)\n                          \n                LEFT JOIN PersonPicture\n                          ON PersonPicture.personPictureUid = Person.personUid\n         WHERE :searchQuery = '%' \n               OR (Person.firstNames || ' ' || Person.lastName) LIKE :searchQuery\n      ORDER BY LatestMessage.messageTimestamp DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, MessageAndOtherPerson> conversationsForUserAsPagingSource(@NotNull String var1, long var2);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insert(@NotNull Message var1, @NotNull Continuation<? super Unit> var2);
}

