/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.UserSessionDao;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.UserSession;
import com.ustadmobile.lib.db.entities.UserSessionAndPerson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class UserSessionDao_Impl
extends UserSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserSession> __insertionAdapterOfUserSession;
    private final SharedSQLiteStatement __preparedStmtOfEndSession;
    private final SharedSQLiteStatement __preparedStmtOfEndOtherSessions;

    public UserSessionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserSession = new EntityInsertionAdapter<UserSession>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `UserSession` (`usUid`,`usPcsn`,`usLcsn`,`usLcb`,`usLct`,`usPersonUid`,`usClientNodeId`,`usStartTime`,`usEndTime`,`usStatus`,`usReason`,`usAuth`,`usSessionType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull UserSession entity) {
                statement.bindLong(1, entity.getUsUid());
                statement.bindLong(2, entity.getUsPcsn());
                statement.bindLong(3, entity.getUsLcsn());
                statement.bindLong(4, entity.getUsLcb());
                statement.bindLong(5, entity.getUsLct());
                statement.bindLong(6, entity.getUsPersonUid());
                statement.bindLong(7, entity.getUsClientNodeId());
                statement.bindLong(8, entity.getUsStartTime());
                statement.bindLong(9, entity.getUsEndTime());
                statement.bindLong(10, (long)entity.getUsStatus());
                statement.bindLong(11, (long)entity.getUsReason());
                if (entity.getUsAuth() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getUsAuth());
                }
                statement.bindLong(13, (long)entity.getUsSessionType());
            }
        };
        this.__preparedStmtOfEndSession = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = ?,\n               usReason = ?,\n               usEndTime = ?,\n               usLct = ?\n         WHERE UserSession.usUid = ?\n    ";
                return "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = ?,\n               usReason = ?,\n               usEndTime = ?,\n               usLct = ?\n         WHERE UserSession.usUid = ?\n    ";
            }
        };
        this.__preparedStmtOfEndOtherSessions = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = ?,\n               usReason = ?,\n               usLct = ?\n         WHERE usPersonUid = ?\n           AND usClientNodeId != ?\n           AND usStatus != ?                     \n    ";
                return "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = ?,\n               usReason = ?,\n               usLct = ?\n         WHERE usPersonUid = ?\n           AND usClientNodeId != ?\n           AND usStatus != ?                     \n    ";
            }
        };
    }

    @Override
    public Object insertSession(final UserSession session, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                UserSessionDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = UserSessionDao_Impl.this.__insertionAdapterOfUserSession.insertAndReturnId((Object)session);
                    UserSessionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    UserSessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object endSession(final long sessionUid, final int newStatus, final int reason, final long endTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserSessionDao_Impl.this.__preparedStmtOfEndSession.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)newStatus);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)reason);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, endTime);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, endTime);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, sessionUid);
                try {
                    Unit unit;
                    UserSessionDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        UserSessionDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        UserSessionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    UserSessionDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    UserSessionDao_Impl.this.__preparedStmtOfEndSession.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object endOtherSessions(final long personUid, final long exemptNodeId, final int newStatus, final int reason, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserSessionDao_Impl.this.__preparedStmtOfEndOtherSessions.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)newStatus);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)reason);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, personUid);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, exemptNodeId);
                _argIndex = 6;
                _stmt.bindLong(_argIndex, (long)newStatus);
                try {
                    Unit unit;
                    UserSessionDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        UserSessionDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        UserSessionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    UserSessionDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    UserSessionDao_Impl.this.__preparedStmtOfEndOtherSessions.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findSessionsByPerson(long personUid, Continuation<? super List<UserSession>> $completion) {
        String _sql = "\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE usPersonUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE usPersonUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UserSession>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<UserSession> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usUid");
                    int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPcsn");
                    int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcsn");
                    int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcb");
                    int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLct");
                    int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPersonUid");
                    int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usClientNodeId");
                    int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStartTime");
                    int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usEndTime");
                    int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStatus");
                    int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usReason");
                    int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usAuth");
                    int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usSessionType");
                    ArrayList<UserSession> _result2 = new ArrayList<UserSession>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        UserSession _item = new UserSession();
                        long _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
                        _item.setUsUid(_tmpUsUid);
                        long _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
                        _item.setUsPcsn(_tmpUsPcsn);
                        long _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
                        _item.setUsLcsn(_tmpUsLcsn);
                        long _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
                        _item.setUsLcb(_tmpUsLcb);
                        long _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
                        _item.setUsLct(_tmpUsLct);
                        long _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
                        _item.setUsPersonUid(_tmpUsPersonUid);
                        long _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
                        _item.setUsClientNodeId(_tmpUsClientNodeId);
                        long _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
                        _item.setUsStartTime(_tmpUsStartTime);
                        long _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
                        _item.setUsEndTime(_tmpUsEndTime);
                        int _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
                        _item.setUsStatus(_tmpUsStatus);
                        int _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
                        _item.setUsReason(_tmpUsReason);
                        String _tmpUsAuth = _cursor.isNull(_cursorIndexOfUsAuth) ? null : _cursor.getString(_cursorIndexOfUsAuth);
                        _item.setUsAuth(_tmpUsAuth);
                        int _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
                        _item.setUsSessionType(_tmpUsSessionType);
                        _result2.add(_item);
                    }
                    ArrayList<UserSession> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<UserSessionAndPerson>> findAllLocalSessionsLive() {
        String _sql = "\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"UserSession", "Person", "PersonPicture", "SyncNode"}, (Callable)new Callable<List<UserSessionAndPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<UserSessionAndPerson> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usUid");
                    int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPcsn");
                    int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcsn");
                    int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcb");
                    int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLct");
                    int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPersonUid");
                    int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usClientNodeId");
                    int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStartTime");
                    int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usEndTime");
                    int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStatus");
                    int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usReason");
                    int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usAuth");
                    int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usSessionType");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<UserSessionAndPerson> _result2 = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPersonPicture;
                        Person _tmpPerson;
                        UserSession _tmpUserSession;
                        if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
                            _tmpUserSession = new UserSession();
                            long _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
                            _tmpUserSession.setUsUid(_tmpUsUid);
                            long _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
                            _tmpUserSession.setUsPcsn(_tmpUsPcsn);
                            long _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
                            _tmpUserSession.setUsLcsn(_tmpUsLcsn);
                            long _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
                            _tmpUserSession.setUsLcb(_tmpUsLcb);
                            long _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
                            _tmpUserSession.setUsLct(_tmpUsLct);
                            long _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
                            _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
                            long _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
                            _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
                            long _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
                            _tmpUserSession.setUsStartTime(_tmpUsStartTime);
                            long _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
                            _tmpUserSession.setUsEndTime(_tmpUsEndTime);
                            int _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
                            _tmpUserSession.setUsStatus(_tmpUsStatus);
                            int _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
                            _tmpUserSession.setUsReason(_tmpUsReason);
                            String _tmpUsAuth = _cursor.isNull(_cursorIndexOfUsAuth) ? null : _cursor.getString(_cursorIndexOfUsAuth);
                            _tmpUserSession.setUsAuth(_tmpUsAuth);
                            int _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
                            _tmpUserSession.setUsSessionType(_tmpUsSessionType);
                        } else {
                            _tmpUserSession = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPersonPicture = null;
                        }
                        UserSessionAndPerson _item = new UserSessionAndPerson(_tmpPerson, _tmpPersonPicture, _tmpUserSession);
                        _result2.add(_item);
                    }
                    ArrayList<UserSessionAndPerson> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findAllLocalSessionsAsync(Continuation<? super List<UserSessionAndPerson>> $completion) {
        String _sql = "\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UserSessionAndPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<UserSessionAndPerson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usUid");
                    int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPcsn");
                    int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcsn");
                    int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcb");
                    int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLct");
                    int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPersonUid");
                    int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usClientNodeId");
                    int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStartTime");
                    int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usEndTime");
                    int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStatus");
                    int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usReason");
                    int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usAuth");
                    int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usSessionType");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<UserSessionAndPerson> _result2 = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPersonPicture;
                        Person _tmpPerson;
                        UserSession _tmpUserSession;
                        if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
                            _tmpUserSession = new UserSession();
                            long _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
                            _tmpUserSession.setUsUid(_tmpUsUid);
                            long _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
                            _tmpUserSession.setUsPcsn(_tmpUsPcsn);
                            long _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
                            _tmpUserSession.setUsLcsn(_tmpUsLcsn);
                            long _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
                            _tmpUserSession.setUsLcb(_tmpUsLcb);
                            long _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
                            _tmpUserSession.setUsLct(_tmpUsLct);
                            long _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
                            _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
                            long _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
                            _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
                            long _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
                            _tmpUserSession.setUsStartTime(_tmpUsStartTime);
                            long _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
                            _tmpUserSession.setUsEndTime(_tmpUsEndTime);
                            int _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
                            _tmpUserSession.setUsStatus(_tmpUsStatus);
                            int _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
                            _tmpUserSession.setUsReason(_tmpUsReason);
                            String _tmpUsAuth = _cursor.isNull(_cursorIndexOfUsAuth) ? null : _cursor.getString(_cursorIndexOfUsAuth);
                            _tmpUserSession.setUsAuth(_tmpUsAuth);
                            int _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
                            _tmpUserSession.setUsSessionType(_tmpUsSessionType);
                        } else {
                            _tmpUserSession = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPersonPicture = null;
                        }
                        UserSessionAndPerson _item = new UserSessionAndPerson(_tmpPerson, _tmpPersonPicture, _tmpUserSession);
                        _result2.add(_item);
                    }
                    ArrayList<UserSessionAndPerson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findLocalSessionByUsername(String username, Continuation<? super UserSessionAndPerson> $completion) {
        String _sql = "\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE Person.username = ?\n               AND UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE Person.username = ?\n               AND UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ", (int)1);
        int _argIndex = 1;
        if (username == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, username);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<UserSessionAndPerson>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public UserSessionAndPerson call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    UserSessionAndPerson _result2;
                    int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usUid");
                    int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPcsn");
                    int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcsn");
                    int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcb");
                    int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLct");
                    int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPersonUid");
                    int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usClientNodeId");
                    int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStartTime");
                    int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usEndTime");
                    int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStatus");
                    int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usReason");
                    int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usAuth");
                    int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usSessionType");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        Person _tmpPerson;
                        UserSession _tmpUserSession;
                        if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
                            _tmpUserSession = new UserSession();
                            long _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
                            _tmpUserSession.setUsUid(_tmpUsUid);
                            long _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
                            _tmpUserSession.setUsPcsn(_tmpUsPcsn);
                            long _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
                            _tmpUserSession.setUsLcsn(_tmpUsLcsn);
                            long _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
                            _tmpUserSession.setUsLcb(_tmpUsLcb);
                            long _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
                            _tmpUserSession.setUsLct(_tmpUsLct);
                            long _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
                            _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
                            long _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
                            _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
                            long _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
                            _tmpUserSession.setUsStartTime(_tmpUsStartTime);
                            long _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
                            _tmpUserSession.setUsEndTime(_tmpUsEndTime);
                            int _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
                            _tmpUserSession.setUsStatus(_tmpUsStatus);
                            int _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
                            _tmpUserSession.setUsReason(_tmpUsReason);
                            String _tmpUsAuth = _cursor.isNull(_cursorIndexOfUsAuth) ? null : _cursor.getString(_cursorIndexOfUsAuth);
                            _tmpUserSession.setUsAuth(_tmpUsAuth);
                            int _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
                            _tmpUserSession.setUsSessionType(_tmpUsSessionType);
                        } else {
                            _tmpUserSession = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        _result2 = new UserSessionAndPerson(_tmpPerson, null, _tmpUserSession);
                    } else {
                        _result2 = null;
                    }
                    UserSessionAndPerson userSessionAndPerson = _result2;
                    return userSessionAndPerson;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object countAllLocalSessionsAsync(long maxDateOfBirth, Continuation<? super Integer> $completion) {
        String _sql = "\n        SELECT COUNT(*)\n          FROM UserSession\n               JOIN Person \n                    ON UserSession.usPersonUid = Person.personUid\n         WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n           AND UserSession.usStatus = 1                \n           AND (? = 0 OR Person.dateOfBirth < ?)\n           AND (UserSession.usSessionType & 8) != 8            \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COUNT(*)\n          FROM UserSession\n               JOIN Person \n                    ON UserSession.usPersonUid = Person.personUid\n         WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n           AND UserSession.usStatus = 1                \n           AND (? = 0 OR Person.dateOfBirth < ?)\n           AND (UserSession.usSessionType & 8) != 8            \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, maxDateOfBirth);
        _argIndex = 2;
        _statement.bindLong(_argIndex, maxDateOfBirth);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<UserSession> findByUidLive(long sessionUid) {
        String _sql = "\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE UserSession.usUid = ?\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE UserSession.usUid = ?\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, sessionUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"UserSession"}, (Callable)new Callable<UserSession>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public UserSession call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserSession _result2;
                    int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usUid");
                    int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPcsn");
                    int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcsn");
                    int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLcb");
                    int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usLct");
                    int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usPersonUid");
                    int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usClientNodeId");
                    int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStartTime");
                    int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usEndTime");
                    int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usStatus");
                    int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usReason");
                    int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usAuth");
                    int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usSessionType");
                    if (_cursor.moveToFirst()) {
                        _result2 = new UserSession();
                        long _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
                        _result2.setUsUid(_tmpUsUid);
                        long _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
                        _result2.setUsPcsn(_tmpUsPcsn);
                        long _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
                        _result2.setUsLcsn(_tmpUsLcsn);
                        long _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
                        _result2.setUsLcb(_tmpUsLcb);
                        long _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
                        _result2.setUsLct(_tmpUsLct);
                        long _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
                        _result2.setUsPersonUid(_tmpUsPersonUid);
                        long _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
                        _result2.setUsClientNodeId(_tmpUsClientNodeId);
                        long _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
                        _result2.setUsStartTime(_tmpUsStartTime);
                        long _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
                        _result2.setUsEndTime(_tmpUsEndTime);
                        int _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
                        _result2.setUsStatus(_tmpUsStatus);
                        int _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
                        _result2.setUsReason(_tmpUsReason);
                        String _tmpUsAuth = _cursor.isNull(_cursorIndexOfUsAuth) ? null : _cursor.getString(_cursorIndexOfUsAuth);
                        _result2.setUsAuth(_tmpUsAuth);
                        int _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
                        _result2.setUsSessionType(_tmpUsSessionType);
                    } else {
                        _result2 = null;
                    }
                    UserSession userSession = _result2;
                    return userSession;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findActiveNodeIdsByPersonUids(List<Long> personUids, Continuation<? super List<Long>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM UserSession");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE UserSession.usPersonUid IN (");
        int _inputSize = personUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND UserSession.usStatus = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : personUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _item_1 = _cursor.getLong(0);
                        _result2.add(_item_1);
                    }
                    ArrayList<Long> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findActiveNodesIdsByGroupUids(List<Long> groupUids, Continuation<? super List<Long>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM UserSession");
        _stringBuilder.append("\n");
        _stringBuilder.append("               JOIN PersonGroupMember ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ON PersonGroupMember.groupMemberPersonUid = UserSession.usPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE PersonGroupMember.groupMemberGroupUid IN (");
        int _inputSize = groupUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : groupUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _item_1 = _cursor.getLong(0);
                        _result2.add(_item_1);
                    }
                    ArrayList<Long> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object countActiveSessionsForUserAndNode(long personUid, long nodeId, Continuation<? super Integer> $completion) {
        String _sql = "\n        SELECT COUNT(*)\n          FROM UserSession\n         WHERE UserSession.usPersonUid = ?\n           AND UserSession.usStatus = 1\n           AND UserSession.usClientNodeId = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COUNT(*)\n          FROM UserSession\n         WHERE UserSession.usPersonUid = ?\n           AND UserSession.usStatus = 1\n           AND UserSession.usClientNodeId = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, nodeId);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

