/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.XapiSessionEntityDao;
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class XapiSessionEntityDao_Impl
extends XapiSessionEntityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<XapiSessionEntity> __insertionAdapterOfXapiSessionEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestAsComplete;

    public XapiSessionEntityDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfXapiSessionEntity = new EntityInsertionAdapter<XapiSessionEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `XapiSessionEntity` (`xseUid`,`xseLastMod`,`xseRegistrationHi`,`xseRegistrationLo`,`xseUsUid`,`xseAccountPersonUid`,`xseActorUid`,`xseAccountUsername`,`xseClazzUid`,`xseCbUid`,`xseContentEntryUid`,`xseContentEntryVersionUid`,`xseRootActivityId`,`xseRootActivityUid`,`xseStartTime`,`xseExpireTime`,`xseAuth`,`xseCompleted`,`knownActorUidToPersonUids`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull XapiSessionEntity entity) {
                statement.bindLong(1, entity.getXseUid());
                statement.bindLong(2, entity.getXseLastMod());
                statement.bindLong(3, entity.getXseRegistrationHi());
                statement.bindLong(4, entity.getXseRegistrationLo());
                statement.bindLong(5, entity.getXseUsUid());
                statement.bindLong(6, entity.getXseAccountPersonUid());
                statement.bindLong(7, entity.getXseActorUid());
                statement.bindString(8, entity.getXseAccountUsername());
                statement.bindLong(9, entity.getXseClazzUid());
                statement.bindLong(10, entity.getXseCbUid());
                statement.bindLong(11, entity.getXseContentEntryUid());
                statement.bindLong(12, entity.getXseContentEntryVersionUid());
                statement.bindString(13, entity.getXseRootActivityId());
                statement.bindLong(14, entity.getXseRootActivityUid());
                statement.bindLong(15, entity.getXseStartTime());
                statement.bindLong(16, entity.getXseExpireTime());
                if (entity.getXseAuth() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindString(17, entity.getXseAuth());
                }
                int _tmp = entity.getXseCompleted() ? 1 : 0;
                statement.bindLong(18, (long)_tmp);
                statement.bindString(19, entity.getKnownActorUidToPersonUids());
            }
        };
        this.__preparedStmtOfUpdateLatestAsComplete = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE XapiSessionEntity\n           SET xseCompleted = ?,\n               xseLastMod = ?\n         WHERE xseUid = ?\n\n    ";
                return "\n        UPDATE XapiSessionEntity\n           SET xseCompleted = ?,\n               xseLastMod = ?\n         WHERE xseUid = ?\n\n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final XapiSessionEntity xapiSessionEntity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                XapiSessionEntityDao_Impl.this.__db.beginTransaction();
                try {
                    XapiSessionEntityDao_Impl.this.__insertionAdapterOfXapiSessionEntity.insert((Object)xapiSessionEntity);
                    XapiSessionEntityDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    XapiSessionEntityDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateLatestAsComplete(final boolean completed, final long time, final long xseUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = XapiSessionEntityDao_Impl.this.__preparedStmtOfUpdateLatestAsComplete.acquire();
                int _argIndex = 1;
                int _tmp = completed ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, xseUid);
                try {
                    Unit unit;
                    XapiSessionEntityDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        XapiSessionEntityDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        XapiSessionEntityDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    XapiSessionEntityDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    XapiSessionEntityDao_Impl.this.__preparedStmtOfUpdateLatestAsComplete.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super XapiSessionEntity> $completion) {
        String _sql = "\n        SELECT XapiSessionEntity.*\n          FROM XapiSessionEntity\n         WHERE XapiSessionEntity.xseUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT XapiSessionEntity.*\n          FROM XapiSessionEntity\n         WHERE XapiSessionEntity.xseUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<XapiSessionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public XapiSessionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)XapiSessionEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    XapiSessionEntity _result2;
                    int _cursorIndexOfXseUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseUid");
                    int _cursorIndexOfXseLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseLastMod");
                    int _cursorIndexOfXseRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRegistrationHi");
                    int _cursorIndexOfXseRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRegistrationLo");
                    int _cursorIndexOfXseUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseUsUid");
                    int _cursorIndexOfXseAccountPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAccountPersonUid");
                    int _cursorIndexOfXseActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseActorUid");
                    int _cursorIndexOfXseAccountUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAccountUsername");
                    int _cursorIndexOfXseClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseClazzUid");
                    int _cursorIndexOfXseCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseCbUid");
                    int _cursorIndexOfXseContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseContentEntryUid");
                    int _cursorIndexOfXseContentEntryVersionUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseContentEntryVersionUid");
                    int _cursorIndexOfXseRootActivityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRootActivityId");
                    int _cursorIndexOfXseRootActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRootActivityUid");
                    int _cursorIndexOfXseStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseStartTime");
                    int _cursorIndexOfXseExpireTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseExpireTime");
                    int _cursorIndexOfXseAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAuth");
                    int _cursorIndexOfXseCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseCompleted");
                    int _cursorIndexOfKnownActorUidToPersonUids = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"knownActorUidToPersonUids");
                    if (_cursor.moveToFirst()) {
                        long _tmpXseUid = _cursor.getLong(_cursorIndexOfXseUid);
                        long _tmpXseLastMod = _cursor.getLong(_cursorIndexOfXseLastMod);
                        long _tmpXseRegistrationHi = _cursor.getLong(_cursorIndexOfXseRegistrationHi);
                        long _tmpXseRegistrationLo = _cursor.getLong(_cursorIndexOfXseRegistrationLo);
                        long _tmpXseUsUid = _cursor.getLong(_cursorIndexOfXseUsUid);
                        long _tmpXseAccountPersonUid = _cursor.getLong(_cursorIndexOfXseAccountPersonUid);
                        long _tmpXseActorUid = _cursor.getLong(_cursorIndexOfXseActorUid);
                        String _tmpXseAccountUsername = _cursor.getString(_cursorIndexOfXseAccountUsername);
                        long _tmpXseClazzUid = _cursor.getLong(_cursorIndexOfXseClazzUid);
                        long _tmpXseCbUid = _cursor.getLong(_cursorIndexOfXseCbUid);
                        long _tmpXseContentEntryUid = _cursor.getLong(_cursorIndexOfXseContentEntryUid);
                        long _tmpXseContentEntryVersionUid = _cursor.getLong(_cursorIndexOfXseContentEntryVersionUid);
                        String _tmpXseRootActivityId = _cursor.getString(_cursorIndexOfXseRootActivityId);
                        long _tmpXseRootActivityUid = _cursor.getLong(_cursorIndexOfXseRootActivityUid);
                        long _tmpXseStartTime = _cursor.getLong(_cursorIndexOfXseStartTime);
                        long _tmpXseExpireTime = _cursor.getLong(_cursorIndexOfXseExpireTime);
                        String _tmpXseAuth = _cursor.isNull(_cursorIndexOfXseAuth) ? null : _cursor.getString(_cursorIndexOfXseAuth);
                        int _tmp = _cursor.getInt(_cursorIndexOfXseCompleted);
                        boolean _tmpXseCompleted = _tmp != 0;
                        String _tmpKnownActorUidToPersonUids = _cursor.getString(_cursorIndexOfKnownActorUidToPersonUids);
                        _result2 = new XapiSessionEntity(_tmpXseUid, _tmpXseLastMod, _tmpXseRegistrationHi, _tmpXseRegistrationLo, _tmpXseUsUid, _tmpXseAccountPersonUid, _tmpXseActorUid, _tmpXseAccountUsername, _tmpXseClazzUid, _tmpXseCbUid, _tmpXseContentEntryUid, _tmpXseContentEntryVersionUid, _tmpXseRootActivityId, _tmpXseRootActivityUid, _tmpXseStartTime, _tmpXseExpireTime, _tmpXseAuth, _tmpXseCompleted, _tmpKnownActorUidToPersonUids);
                    } else {
                        _result2 = null;
                    }
                    XapiSessionEntity xapiSessionEntity = _result2;
                    return xapiSessionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findMostRecentSessionByActorAndActivity(long accountPersonUid, long actorUid, long xseRootActivityUid, long contentEntryVersionUid, long clazzUid, Continuation<? super XapiSessionEntity> $completion) {
        String _sql = "\n        SELECT XapiSessionEntity.*\n          FROM XapiSessionEntity\n         WHERE XapiSessionEntity.xseRootActivityUid = ?\n           AND XapiSessionEntity.xseActorUid = ?\n           AND XapiSessionEntity.xseContentEntryVersionUid = ?\n           AND XapiSessionEntity.xseClazzUid = ?\n           AND EXISTS(\n               SELECT 1\n                 FROM ActorEntity\n                WHERE ActorEntity.actorUid = ?\n                  AND ActorEntity.actorPersonUid = ?)     \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT XapiSessionEntity.*\n          FROM XapiSessionEntity\n         WHERE XapiSessionEntity.xseRootActivityUid = ?\n           AND XapiSessionEntity.xseActorUid = ?\n           AND XapiSessionEntity.xseContentEntryVersionUid = ?\n           AND XapiSessionEntity.xseClazzUid = ?\n           AND EXISTS(\n               SELECT 1\n                 FROM ActorEntity\n                WHERE ActorEntity.actorUid = ?\n                  AND ActorEntity.actorPersonUid = ?)     \n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, xseRootActivityUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, contentEntryVersionUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<XapiSessionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public XapiSessionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)XapiSessionEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    XapiSessionEntity _result2;
                    int _cursorIndexOfXseUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseUid");
                    int _cursorIndexOfXseLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseLastMod");
                    int _cursorIndexOfXseRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRegistrationHi");
                    int _cursorIndexOfXseRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRegistrationLo");
                    int _cursorIndexOfXseUsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseUsUid");
                    int _cursorIndexOfXseAccountPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAccountPersonUid");
                    int _cursorIndexOfXseActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseActorUid");
                    int _cursorIndexOfXseAccountUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAccountUsername");
                    int _cursorIndexOfXseClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseClazzUid");
                    int _cursorIndexOfXseCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseCbUid");
                    int _cursorIndexOfXseContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseContentEntryUid");
                    int _cursorIndexOfXseContentEntryVersionUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseContentEntryVersionUid");
                    int _cursorIndexOfXseRootActivityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRootActivityId");
                    int _cursorIndexOfXseRootActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseRootActivityUid");
                    int _cursorIndexOfXseStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseStartTime");
                    int _cursorIndexOfXseExpireTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseExpireTime");
                    int _cursorIndexOfXseAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseAuth");
                    int _cursorIndexOfXseCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xseCompleted");
                    int _cursorIndexOfKnownActorUidToPersonUids = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"knownActorUidToPersonUids");
                    if (_cursor.moveToFirst()) {
                        long _tmpXseUid = _cursor.getLong(_cursorIndexOfXseUid);
                        long _tmpXseLastMod = _cursor.getLong(_cursorIndexOfXseLastMod);
                        long _tmpXseRegistrationHi = _cursor.getLong(_cursorIndexOfXseRegistrationHi);
                        long _tmpXseRegistrationLo = _cursor.getLong(_cursorIndexOfXseRegistrationLo);
                        long _tmpXseUsUid = _cursor.getLong(_cursorIndexOfXseUsUid);
                        long _tmpXseAccountPersonUid = _cursor.getLong(_cursorIndexOfXseAccountPersonUid);
                        long _tmpXseActorUid = _cursor.getLong(_cursorIndexOfXseActorUid);
                        String _tmpXseAccountUsername = _cursor.getString(_cursorIndexOfXseAccountUsername);
                        long _tmpXseClazzUid = _cursor.getLong(_cursorIndexOfXseClazzUid);
                        long _tmpXseCbUid = _cursor.getLong(_cursorIndexOfXseCbUid);
                        long _tmpXseContentEntryUid = _cursor.getLong(_cursorIndexOfXseContentEntryUid);
                        long _tmpXseContentEntryVersionUid = _cursor.getLong(_cursorIndexOfXseContentEntryVersionUid);
                        String _tmpXseRootActivityId = _cursor.getString(_cursorIndexOfXseRootActivityId);
                        long _tmpXseRootActivityUid = _cursor.getLong(_cursorIndexOfXseRootActivityUid);
                        long _tmpXseStartTime = _cursor.getLong(_cursorIndexOfXseStartTime);
                        long _tmpXseExpireTime = _cursor.getLong(_cursorIndexOfXseExpireTime);
                        String _tmpXseAuth = _cursor.isNull(_cursorIndexOfXseAuth) ? null : _cursor.getString(_cursorIndexOfXseAuth);
                        int _tmp = _cursor.getInt(_cursorIndexOfXseCompleted);
                        boolean _tmpXseCompleted = _tmp != 0;
                        String _tmpKnownActorUidToPersonUids = _cursor.getString(_cursorIndexOfKnownActorUidToPersonUids);
                        _result2 = new XapiSessionEntity(_tmpXseUid, _tmpXseLastMod, _tmpXseRegistrationHi, _tmpXseRegistrationLo, _tmpXseUsUid, _tmpXseAccountPersonUid, _tmpXseActorUid, _tmpXseAccountUsername, _tmpXseClazzUid, _tmpXseCbUid, _tmpXseContentEntryUid, _tmpXseContentEntryVersionUid, _tmpXseRootActivityId, _tmpXseRootActivityUid, _tmpXseStartTime, _tmpXseExpireTime, _tmpXseAuth, _tmpXseCompleted, _tmpKnownActorUidToPersonUids);
                    } else {
                        _result2 = null;
                    }
                    XapiSessionEntity xapiSessionEntity = _result2;
                    return xapiSessionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

