/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao;
import com.ustadmobile.lib.db.entities.ContentCategorySchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class ContentCategorySchemaDao_Impl
extends ContentCategorySchemaDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentCategorySchema> __insertionAdapterOfContentCategorySchema;
    private final EntityDeletionOrUpdateAdapter<ContentCategorySchema> __updateAdapterOfContentCategorySchema;

    public ContentCategorySchemaDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentCategorySchema = new EntityInsertionAdapter<ContentCategorySchema>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentCategorySchema` (`contentCategorySchemaUid`,`schemaName`,`schemaUrl`,`contentCategorySchemaLocalChangeSeqNum`,`contentCategorySchemaMasterChangeSeqNum`,`contentCategorySchemaLastChangedBy`,`contentCategorySchemaLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentCategorySchema entity) {
                statement.bindLong(1, entity.getContentCategorySchemaUid());
                if (entity.getSchemaName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getSchemaName());
                }
                if (entity.getSchemaUrl() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getSchemaUrl());
                }
                statement.bindLong(4, entity.getContentCategorySchemaLocalChangeSeqNum());
                statement.bindLong(5, entity.getContentCategorySchemaMasterChangeSeqNum());
                statement.bindLong(6, (long)entity.getContentCategorySchemaLastChangedBy());
                statement.bindLong(7, entity.getContentCategorySchemaLct());
            }
        };
        this.__updateAdapterOfContentCategorySchema = new EntityDeletionOrUpdateAdapter<ContentCategorySchema>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ContentCategorySchema` SET `contentCategorySchemaUid` = ?,`schemaName` = ?,`schemaUrl` = ?,`contentCategorySchemaLocalChangeSeqNum` = ?,`contentCategorySchemaMasterChangeSeqNum` = ?,`contentCategorySchemaLastChangedBy` = ?,`contentCategorySchemaLct` = ? WHERE `contentCategorySchemaUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentCategorySchema entity) {
                statement.bindLong(1, entity.getContentCategorySchemaUid());
                if (entity.getSchemaName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getSchemaName());
                }
                if (entity.getSchemaUrl() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getSchemaUrl());
                }
                statement.bindLong(4, entity.getContentCategorySchemaLocalChangeSeqNum());
                statement.bindLong(5, entity.getContentCategorySchemaMasterChangeSeqNum());
                statement.bindLong(6, (long)entity.getContentCategorySchemaLastChangedBy());
                statement.bindLong(7, entity.getContentCategorySchemaLct());
                statement.bindLong(8, entity.getContentCategorySchemaUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentCategorySchema entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfContentCategorySchema.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ContentCategorySchema entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentCategorySchemaDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentCategorySchemaDao_Impl.this.__insertionAdapterOfContentCategorySchema.insertAndReturnId((Object)entity);
                    ContentCategorySchemaDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentCategorySchemaDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ContentCategorySchema> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentCategorySchema.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ContentCategorySchema entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContentCategorySchema.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentCategorySchema> publicContentCategorySchemas() {
        String _sql = "SELECT ContentCategorySchema.* FROM ContentCategorySchema";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentCategorySchema.* FROM ContentCategorySchema", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaUid");
            int _cursorIndexOfSchemaName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schemaName");
            int _cursorIndexOfSchemaUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schemaUrl");
            int _cursorIndexOfContentCategorySchemaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLocalChangeSeqNum");
            int _cursorIndexOfContentCategorySchemaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaMasterChangeSeqNum");
            int _cursorIndexOfContentCategorySchemaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLastChangedBy");
            int _cursorIndexOfContentCategorySchemaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLct");
            ArrayList<ContentCategorySchema> _result2 = new ArrayList<ContentCategorySchema>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ContentCategorySchema _item = new ContentCategorySchema();
                long _tmpContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfContentCategorySchemaUid);
                _item.setContentCategorySchemaUid(_tmpContentCategorySchemaUid);
                String _tmpSchemaName = _cursor.isNull(_cursorIndexOfSchemaName) ? null : _cursor.getString(_cursorIndexOfSchemaName);
                _item.setSchemaName(_tmpSchemaName);
                String _tmpSchemaUrl = _cursor.isNull(_cursorIndexOfSchemaUrl) ? null : _cursor.getString(_cursorIndexOfSchemaUrl);
                _item.setSchemaUrl(_tmpSchemaUrl);
                long _tmpContentCategorySchemaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaLocalChangeSeqNum);
                _item.setContentCategorySchemaLocalChangeSeqNum(_tmpContentCategorySchemaLocalChangeSeqNum);
                long _tmpContentCategorySchemaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaMasterChangeSeqNum);
                _item.setContentCategorySchemaMasterChangeSeqNum(_tmpContentCategorySchemaMasterChangeSeqNum);
                int _tmpContentCategorySchemaLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategorySchemaLastChangedBy);
                _item.setContentCategorySchemaLastChangedBy(_tmpContentCategorySchemaLastChangedBy);
                long _tmpContentCategorySchemaLct = _cursor.getLong(_cursorIndexOfContentCategorySchemaLct);
                _item.setContentCategorySchemaLct(_tmpContentCategorySchemaLct);
                _result2.add(_item);
            }
            ArrayList<ContentCategorySchema> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentCategorySchema findBySchemaUrl(String schemaUrl) {
        String _sql = "SELECT * FROM ContentCategorySchema WHERE schemaUrl = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentCategorySchema WHERE schemaUrl = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, schemaUrl);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentCategorySchema _result2;
            int _cursorIndexOfContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaUid");
            int _cursorIndexOfSchemaName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schemaName");
            int _cursorIndexOfSchemaUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schemaUrl");
            int _cursorIndexOfContentCategorySchemaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLocalChangeSeqNum");
            int _cursorIndexOfContentCategorySchemaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaMasterChangeSeqNum");
            int _cursorIndexOfContentCategorySchemaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLastChangedBy");
            int _cursorIndexOfContentCategorySchemaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategorySchemaLct");
            if (_cursor.moveToFirst()) {
                _result2 = new ContentCategorySchema();
                long _tmpContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfContentCategorySchemaUid);
                _result2.setContentCategorySchemaUid(_tmpContentCategorySchemaUid);
                String _tmpSchemaName = _cursor.isNull(_cursorIndexOfSchemaName) ? null : _cursor.getString(_cursorIndexOfSchemaName);
                _result2.setSchemaName(_tmpSchemaName);
                String _tmpSchemaUrl = _cursor.isNull(_cursorIndexOfSchemaUrl) ? null : _cursor.getString(_cursorIndexOfSchemaUrl);
                _result2.setSchemaUrl(_tmpSchemaUrl);
                long _tmpContentCategorySchemaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaLocalChangeSeqNum);
                _result2.setContentCategorySchemaLocalChangeSeqNum(_tmpContentCategorySchemaLocalChangeSeqNum);
                long _tmpContentCategorySchemaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaMasterChangeSeqNum);
                _result2.setContentCategorySchemaMasterChangeSeqNum(_tmpContentCategorySchemaMasterChangeSeqNum);
                int _tmpContentCategorySchemaLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategorySchemaLastChangedBy);
                _result2.setContentCategorySchemaLastChangedBy(_tmpContentCategorySchemaLastChangedBy);
                long _tmpContentCategorySchemaLct = _cursor.getLong(_cursorIndexOfContentCategorySchemaLct);
                _result2.setContentCategorySchemaLct(_tmpContentCategorySchemaLct);
            } else {
                _result2 = null;
            }
            ContentCategorySchema contentCategorySchema = _result2;
            return contentCategorySchema;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

